class RelevanceCorrelation:

    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        good = 0
        error = 0
        bad = 0
        total = 0

        for res in results:
            if 'video_relevance_bin' in res.scales and 'video_relevance' in res.scales:
                total += 1

                if (res.scales['video_relevance_bin'] == 'REL' and res.scales['video_relevance'] in ['RELEVANT_PLUS', 'RELEVANT_MINUS']):
                    good += 1
                elif res.scales['video_relevance_bin'] == 'NOT_REL' and res.scales['video_relevance'] == 'IRRELEVANT':
                    good += 1
                elif (res.scales['video_relevance_bin'] == '404' and res.scales['video_relevance'] in ['_404', 'SOFT_404']):
                    good += 1
                elif res.scales['video_relevance_bin'] == '404' or res.scales['video_relevance'] == '_404' or res.scales['video_relevance'] == 'SOFT_404':
                    error += 1
                else:
                    bad += 1

        if total:
            return good * 100.0 / total

class ErrorCorrelation:

    def __init__(self, depth=5):

        self.depth = depth

    def value(self, metric_params):

        results = metric_params.results[:self.depth]

        good = 0
        error = 0
        bad = 0
        total = 0

        for res in results:
            if 'video_relevance_bin' in res.scales and 'video_relevance' in res.scales:
                total += 1

                if (res.scales['video_relevance_bin'] == 'REL' and res.scales['video_relevance'] in ['RELEVANT_PLUS', 'RELEVANT_MINUS']):
                    good += 1
                elif res.scales['video_relevance_bin'] == 'NOT_REL' and res.scales['video_relevance'] == 'IRRELEVANT':
                    good += 1
                elif (res.scales['video_relevance_bin'] == '404' and res.scales['video_relevance'] in ['_404', 'SOFT_404']):
                    good += 1
                elif res.scales['video_relevance_bin'] == '404' or res.scales['video_relevance'] == '_404' or res.scales['video_relevance'] == 'SOFT_404':
                    error += 1
                else:
                    bad += 1

        if total:
            return error * 100.0 / total
