#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import json
from yql.api.v1.client import YqlClient
from videolog_common import YqlRunner, apply_replacements


def get_title(filename):
    fn, ext = os.path.splitext(filename)
    return "{} | YQL".format(fn)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--query", "-q", action="append")

    parsed, unknown = parser.parse_known_args()

    replacements = dict(zip(
        unknown[::2], unknown[1::2]
    ))
    print("replacements: {}".format(json.dumps(replacements, indent=2)))
    print("parsed queries: {}".format(parsed.query))
    import pdb; pdb.set_trace()

    yql_client = YqlClient(
        db=os.environ["YT_PROXY"].split(".")[0].lower(),
        token=os.environ["YQL_TOKEN"]
    )
    yr = YqlRunner(yql_client, title="Yql Runner Wrapper | YQL")

    for query_file in parsed.query:
        with codecs.open(query_file, "r", "utf8") as f:
            query = f.read()
        query = apply_replacements(query, replacements)
        yr.run(query, title=get_title(query_file), wait=True)


if __name__ == "__main__":
    main()
