#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import (
    clusters,
    filters as nf,
    extractors as ne,
    aggregators as na,
    Record
)
import datetime


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--proxy', default='hahn')
    parser.add_argument('--bypass', action='store_true')
    parser.add_argument('--days', type=int, default=3)
    parser.add_argument('--path')
    args = parser.parse_args()
    cluster = clusters.YT(
        proxy=args.proxy,
        token=os.environ['YT_TOKEN']
    )
    yt = cluster.driver.client

    today = datetime.date.today()

    for item in yt.search(
        root=args.path
    ):
        if not yt.exists(item):
            continue
        mod_date = datetime.datetime.strptime(
            yt.get_attribute(item, 'modification_time').split('T')[0],
            '%Y-%m-%d'
        ).date()
        if mod_date < (today - datetime.timedelta(days=args.days)):
            print('removing {}'.format(item))
            if not args.bypass:
                yt.remove(item, recursive=True)


if __name__ == "__main__":
    main()
