#!/bin/bash -e

# 1   Get folders for last three releases of ru dict
# 2   Get last release for super tail
# 3   Loop for ru  dicts
# 3.1 Make suggest-web-daemon config with ru dict and super tail dict
# 3.2 Run quality test for that config, save result of quality test to file (result#iter)
# 4   Send result by email

# include common useful bash functions
. /usr/bin/suggest-deploy-common.sh

suggest_dicts="/var/yandex/suggest-dicts"
root_data_dir="/var/yandex/web-data"
geobase="/var/cache/geobase/geodata3.bin"
gen_config="suggest.conf"
quality_test="./quality_test"
report_file="quality_report.txt"
template_config="suggest-templ.conf"
twin_variants="twin_variants.txt"

sampling_file=""
while getopts s: OPT ; do
    case "$OPT" in
        s) sampling_file="$OPTARG" ;;
    esac
done


tail_dir=`ls -td $root_data_dir/compressed-tail-super-dicts-index* | head -1`
log "got last tail_dir: $tail_dir"
tail_bin_dir=`cat $tail_dir/dict-info.txt | awk '{print $1;}'`
log "got tail bin dir: $tail_bin_dir"

last_ru_dir=`ls -td $root_data_dir/ru-index* | head -1`
log "got last ru index directory: $last_ru_dir"
last_ru_bin_dir=`cat $last_ru_dir/dict-info.txt | awk '{print $1;}'`
log "got source ru bin directory: $last_ru_bin_dir"
if [ -z "$sampling_file" ]; then
    log "try to get last sampling file"
    sampling_file=`ls $suggest_dicts/$last_ru_bin_dir/sampling*`
fi
log "got sampling file for last ru bin directory: $sampling_file"

mv "$report_file" "$report_file.old"
touch "$report_file"
log "use $report_file as work report file"

ru_dir_list=`ls -td $root_data_dir/ru-index*`
#ru_dir_list=`echo -e "$ru_dir_list\nru-index_1439387701"`
echo "ru_dir_list: $ru_dir_list"

echo -e "$ru_dir_list" | while read ru_dir ; do
    log "got ru index directory: $ru_dir"
    if [ ! -d $ru_dir ]; then
        echo "not dir: $ru_dir"
        continue
    fi
    ru_bin_dir=`cat $ru_dir/dict-info.txt | awk '{print $1;}'`
    log "got ru bin directory: $ru_bin_dir"
    # generate config with ru dict and super tail dict
    log "try generate config: $gen_config"
    python gen-suggest-config.py --ru-dir=$ru_dir --tail-dir=$tail_dir --geobase=$geobase --xml-config=$gen_config --twin-variants=$twin_variants --xml-config-template=$template_config
    log "config $gen_config generated"
    log "config content: \n`cat $gen_config`"
    log "====================   date: `echo $ru_bin_dir | awk -F'.' '{print $NF;}' | xargs -I{} date -d @{} +'%Y-%m-%d'`" >> $report_file
    log "====================   $ru_bin_dir($ru_dir)" >> $report_file
    log "====================   $tail_bin_dir" >> $report_file
    log "====================   `echo $sampling_file | awk -F'/' '{print $NF;}'`" >> $report_file
    log "run cmd: $quality_test $gen_config $sampling_file"
    $quality_test $gen_config $sampling_file >> $report_file
    log "done, results of cmd saved to file: $report_file"
done

GNUPLOT_FILE="gnuplot.dat"
log "now try to prepare gnuplot data: $GNUPLOT_FILE"
cat $report_file | python parse_report.py > "$GNUPLOT_FILE"
log "$GNUPLOT_FILE prepared"

CHANGES_FILE="changes.csv"
log "now delta csv file: $CHANGES_FILE"
cat $GNUPLOT_FILE | python calc_changes.py > "$CHANGES_FILE"
log "$CHANGES_FILE prepared"

# make file with csv extension to simplify import to LibreOfficeCalc or Excel
GNUPLOT_CSV="gnuplot.csv"
cp $GNUPLOT_FILE $GNUPLOT_CSV

# now generate pictures for quality_test (saved_*, empty, recall)
# you need gnuplot for this operation
./draw_plots.sh

log "all done"
cat $report_file



