# -*- coding: utf-8 -*-

import sys
import os
from string import Template
import optparse
from xml.sax.saxutils import escape
import traceback


def main():
    try:
        parser = optparse.OptionParser()
        parser.add_option("--ru-dir", dest="RuDir", help="path to ru dict file")
        parser.add_option("--tail-dir", dest="TailDir", help="path to tail dict file")
        parser.add_option("--geobase", dest="GeoBaseFile", help="path to geobase file")
        parser.add_option("--xml-config", dest="XmlConfig", help="path to generated xml config file")
        parser.add_option("--xml-config-template", dest="XmlConfigTempl", help="template for xml suggest config")
        parser.add_option("--twin-variants", dest="TwinFile", help="twin variants file")
        (options, args) = parser.parse_args()
        if not options.RuDir or not options.TailDir or not options.GeoBaseFile or not options.XmlConfig or not options.XmlConfigTempl or not options.TwinFile:
            print >> sys.stderr, "options: %s, args: %s" % (str(options), str(args))
            parser.print_help()
            sys.exit(0)
        confTempl = None
        with open(options.XmlConfigTempl, 'r') as f:
            confTempl = f.read()

        t = Template(confTempl)
        values = {'ru_dir' : escape(options.RuDir), 'tail_dir' : escape(options.TailDir), 'geobase' : escape(options.GeoBaseFile), 'twin_variants' : escape(options.TwinFile)}
        xmlConf = t.substitute(values)

        with open(options.XmlConfig, 'w') as f:
            f.write(xmlConf)
    except:
        exInfo = traceback.format_exc()
        print >> sys.stderr, "Error occured:\n%s" % exInfo
        sys.exit(1)


if __name__ == "__main__":
    main()




