__author__ = 'zyko'
import re
import sys
import json
import os
import codecs
import time
import datetime
import urllib
from datetime import date, timedelta

from mapreducelib import MapReduce, Record


def date_range(d1, d2):
    while d1 <= d2:
        yield d1
        d1 = d1 + timedelta(days=1)


def list_of_dates(start_date, final_date):
    #nado budet peredelat'
    start_date = str(start_date)
    final_date = str(final_date)
    startYear = start_date[0:4]
    startMonth = start_date[4:6]
    startDay = start_date[6:8]
    finalYear = final_date[0:4]
    finalMonth = final_date[4:6]
    finalDay = final_date[6:8]
    d1 = date(int(startYear), int(startMonth), int(startDay))
    d2 = date(int(finalYear), int(finalMonth), int(finalDay))
    list_of_dates = list(date_range(d1, d2))
    result_date_list = []
    for dat in list_of_dates:
        strDate = str(dat)
        result_date_list.append(strDate.split('-')[0] + strDate.split('-')[1] + strDate.split('-')[2])
    return result_date_list


def download_table(table_name, file_name, verbose=False):
    if 1 == len(list(MapReduce.getSample(srcTable=table_name, count=1))):
        output_file = codecs.open(file_name, 'w')
        for rec in MapReduce.getSample(srcTable=table_name, count=None):
            output_file.write('%s\t%s\t%s\n' % (rec.key, rec.subkey, rec.value))
        if verbose:
            print file_name, 'downloaded!'
        output_file.close()
        return True
    else:
        return False


def run_MR(aStart, aEnd, aRL, aName):
    dates = list_of_dates(aStart, aEnd)

    d = aStart + "_" + aEnd
    if "983" in aRL:
        #983 is Turkey
        d = "Tr" + d
    elif "225" in aRL:
        #225 is Russia
        d = "Ru" + d
    else:
        #neither Tr nor Ru
        d = "Oth" + d

    src_list = []

    for iDat in dates:
        src_list.append('user_sessions/%s/%s' % (iDat, aName))

    dst_table = 'zyko/research/1463/%s/%s' % (aName, d)

    #filtering search queries to dst_table
    MapReduce.runReduce(MRParser(region_list = aRL), srcTables=src_list,
                        dstTable=dst_table,
                        sortMode=True)

    get_files(dst_table, '/place/home/zyko/data/research/1463/%s' % (aName), d, aName)


def get_files(table, local_dir, days, aName):
    local_file_name = '%s/%s.txt' % (local_dir, days)
    try:
        os.mkdir('/place/home/zyko/data/research')
    except OSError:
        pass
    try:
        os.mkdir('/place/home/zyko/data/research/1463')
    except OSError:
        pass
    try:
        os.mkdir('/place/home/zyko/data/research/1463/%s' % (aName) )
    except OSError:
        pass

    print 'Downloading....'
    print table
    print local_file_name
    if not download_table(table, local_file_name, verbose=True):
        print 'Problems with ', table


class MRParser(object):
    def __init__(self, region_list):
        self.region_list = region_list

    def __call__(self, key, recs):
        global rec, rec
        #search pattern
        pattern = r"http[s]*://(www|m)\.youtube.com/.*search_query=([^&]*)"
        youtube_re = re.compile(pattern)
        #cleaning pattern
        no_crlf = re.compile(r"(\r|\n|\t|\f|\v)")
        for rec in recs:

            adict = dict(d.split('=', 1) for d in rec.value.split('\t') if '=' in d)
            if not adict:
                continue
            url = adict.get('url')
            if not url:
                continue
            user_region = adict.get('user-region')
            if not user_region:
                continue

            if youtube_re.search(url):
                #url in the 2nd block (starting from 0)
                new_key = urllib.unquote_plus(youtube_re.split(url)[2])
                new_key = no_crlf.sub(" ", new_key)
                new_key = new_key.expandtabs(1)
                new_key = new_key.strip()
                new_key = new_key.lower()

                if (len(new_key) < 256) & (user_region in self.region_list):
                    try:
                        yield Record(new_key, "1", "1")
                    except:
                        print key, '\n', rec.value


def main():

    args = sys.argv[1:]

    if len(args) > 1:
        start_date = datetime.datetime.strptime(args[1], date_format)
        end_date = datetime.datetime.strptime(args[2], date_format)
    else:
        # default 15.09.2015 - 21.09.2015
        start_date = datetime.date(2015, 9, 15)
        end_date = datetime.date(2015, 9, 21)

    start = start_date.strftime("%Y%m%d")
    end = end_date.strftime("%Y%m%d")

    #http://g.ararat-lucid.dev.yandex.ru/?fields=Id&types=1,2,3,4,5,6,7,8,9,10,11,12,13&root=225
    regionsRU = {"225","3","1","213","216","116975","116976","116977","116978","116979","20279","117065","20481","20482","20489","20495","20496","20497","20507","117066","20478","20479","20485","20486","117067","20468","20474","20475","20509","20510","117068","20466","20483","20484","20566","117069","20463","20464","20465","20565","120538","20499","20500","20511","98559","98560","115085","120539","20407","20476","20477",
        "20498","20503","20513","20514","20515","120540","20467","20470","20471","20472","20473","20480","20487","20488","20501","20502","20504","20505","20506","20512","20563","120542","20490","20491","20492","20494","120543","20469","20508","20356","117015","117016","20373","20558","117017","117018","20372","117019","20371","117020","117021","20370","117022","117023","117024","117025","20369","117026","117027","117028","20376",
        "20377","117029","117030","20374","20375","20357","117031","20384","20389","117032","20378","117033","20386","117034","20379","117035","20382","20383","117036","117037","117038","117039","20567","117040","117041","20380","20381","117042","20388","117043","20387","117044","117045","20385","117046","117047","20358","116980","20399","116981","116982","116983","116984","116985","116986","20394","20395","20396","116987","116988","116989",
        "20390","116990","114781","116991","20391","20392","116992","20400","20401","116993","20393","116994","20397","20398","116995","20402","20359","120544","20403","115038","115040","120545","120546","20405","120547","20408","120548","20413","120549","20414","20415","120550","120551","120552","20411","120553","20404","120554","20406","20412","120555","20409","20410","20360","20560","20559","114836","120567","120568","120569","20417",
        "20426","120570","20416","120571","20424","20561","20562","120572","20419","120573","20418","120574","120575","20425","20427","20428","120576","20422","20423","120577","120578","20420","20421","120579","20429","20447","120580","20430","120581","20431","20432","115086","20361","120556","20434","120557","20433","20444","120558","20443","20445","20446","120559","20438","20439","120560","120561","20437","120562","20448","20516",
        "120563","20440","120564","20435","20436","120565","20517","20518","20519","20520","120566","20441","20442","115084","20362","21657","116996","116997","20449","20450","20460","20461","116998","20453","116999","20454","20455","117000","117001","117002","117003","20451","117004","20493","117005","20452","116268","117006","20457","20458","20459","117007","20456","98561","20363","117048","117049","20569","20570","114837","117050",
        "20366","115791","117051","20364","117052","20568","117053","117054","20367","20368","117055","20365","114619","10720","21624","21707","29393","103817","114769","116269","117008","117009","117010","117011","117012","117013","117014","121314","121340","121358","121359","114620","20674","117056","117057","117058","117059","117060","117061","117062","117063","117064","121310","121311","121312","121313","121355","98580","10721","101615","117081",
        "117110","117173","117201","117451","117480","117666","117716","117766","117778","118086","118118","118129","118166","118186","118223","118309","118320","118371","118499","118527","118532","118562","118638","118641","118690","118874","118988","119051","119143","119151","119171","119527","119535","119719","120010","120018","120121","120125","120170","120177","120193","120435","120442","120453","120468","98581","10722","21631","21632","101742","104101",
        "104102","104103","104104","104105","104106","104107","117243","117319","117739","117751","117767","117949","118099","118187","118363","118602","118675","118751","118787","119052","119152","119536","119717","120085","120266","120298","120360","98582","10723","20735","100985","109769","110266","117075","117086","117089","117111","117194","117202","117219","117224","117230","117315","117380","117406","117438","117452","117569","117599","117637","117667",
        "117677","117681","117704","117717","117730","117746","117774","117839","117885","117888","117938","117958","117970","118119","118130","118134","118137","118138","118151","118167","118188","118229","118260","118263","118310","118376","118392","118490","118528","118533","118539","118676","118681","118798","118838","118875","118957","118968","118992","119053","119094","119112","119144","119182","119201","119222","119236","119298","119372","119384","119385",
        "119392","119503","119516","119554","119599","119608","119745","119793","119795","119877","119885","119918","119971","120017","120105","120171","120182","120187","120200","120244","120295","120427","120441","120454","120507","121351","98584","10727","117153","117282","117442","117718","117979","117997","118037","118114","118311","118321","118340","118393","118575","118603","118625","118646","119262","119411","119436","119624","119670","119720","119904",
        "120110","120204","120450","120508","98585","10728","117590","117779","117998","118074","118802","119054","119223","119766","120416","98586","10731","21627","117092","117147","117163","117179","117225","117378","117396","117431","117436","117507","117672","117674","117719","117775","117782","117786","117902","117939","118038","118120","118189","118199","118282","118312","118402","118421","118473","118500","118508","118544","118593","118604","118627",
        "118630","118639","118647","118665","118682","118691","118746","118958","119013","119055","119095","119145","119165","119212","119291","119319","119419","119422","119431","119459","119494","119537","119550","119561","119634","119767","119801","119853","119932","119950","119972","119995","120021","120147","120205","120224","120236","120341","120354","120367","120394","120397","120502","121341","98587","10732","103818","117164","117231","117240","117320",
        "117510","117611","117720","118072","118079","118087","118230","118326","118632","118711","118774","119224","119878","119996","120111","120154","120194","98588","10733","21648","101658","117112","117203","117381","117397","117498","117591","117682","117705","117721","117740","117768","117776","117914","117971","117980","118039","118088","118121","118143","118190","118264","118336","118501","118552","118721","118758","118833","118876","118892","118945",
        "118950","118959","118967","119014","119056","119118","119146","119225","119256","119388","119404","119514","119538","119581","119879","119900","119919","119937","120016","120073","120156","120172","120178","120209","98589","21650","21654","109770","117160","117165","117234","117332","117382","117476","117722","117889","117915","118015","118028","118168","118231","118384","118738","118926","118946","118993","119004","119113","119172","119226","119441",
        "119460","119517","119567","119702","119870","119886","119905","119906","120122","120364","120386","98590","10735","21745","29394","109160","117122","117159","117190","117433","117598","117638","117678","117701","117715","117756","117823","117957","118035","118122","118169","118175","118181","118322","118765","118806","118997","119047","119263","119406","119530","119687","119808","119843","120056","120188","98591","10719","101602","117166","117184",
        "117220","117304","117312","117325","117362","117435","117443","117627","117723","117729","117761","117783","117856","117894","117940","117950","118152","118221","118274","118382","118655","118727","118742","118808","118815","118832","118915","119170","119389","119398","119539","119547","119705","119938","120112","120126","120159","121322","121349","121362","121363","98592","10736","117113","117204","117283","117398","117407","117453","117499","117542",
        "117574","117584","118056","118123","118170","118224","118295","118405","118666","118712","118743","118752","118813","119423","119540","120237","120293","120436","120462","98593","10737","117269","117276","117576","117641","117658","117684","117741","118302","118415","118781","119006","119280","119424","119497","119663","119871","120324","98594","10738","121328","101060","101764","121307","105572","105574","117964","118294","118757","118784","118822",
        "118929","120003","120195","120368","120406","98595","10739","121336","21734","109763","117082","117098","117123","117167","117383","117408","117461","117529","117543","117592","117600","117645","117659","117668","117724","117769","117798","117900","117921","118073","118097","118144","118171","118232","118303","118318","118341","118422","118491","118502","118650","118656","118684","118688","118713","118877","118900","119057","119119","119147","119227",
        "119410","119437","119633","119676","119685","119718","119887","119914","119935","119939","120022","120091","120160","120173","120206","120248","120429","98596","10740","21708","101432","117073","117099","117205","117279","117409","117530","117927","117969","118057","118261","118377","118412","118503","118565","118685","118759","118951","119046","119114","119157","119163","119219","119522","119566","119587","119601","119602","119664","119753","119852",
        "119997","120113","120210","120223","120301","120335","120376","120402","121344","98597","10715","10741","37160","101588","116396","117118","117124","117148","117199","117213","117259","117477","117491","117526","117581","117662","117675","117838","117866","117890","118089","118172","118233","118492","118504","118563","118642","118648","118667","118677","118695","118755","118895","118961","119058","119120","119138","119162","119203","119228","119243",
        "119541","119562","119848","119880","120011","120086","120099","120155","120179","120235","120281","120537","98598","10742","21642","21655","21656","101723","117074","117083","117104","117336","117358","117540","117612","117708","117725","117965","117992","118067","118092","118098","118135","118178","118191","118207","118265","118335","118513","118766","118905","119134","119242","119258","119260","119449","119555","119625","119796","120081","120082",
        "120185","120328","120455","120519","98599","10743","21625","21646","21649","21652","21653","29392","101562","109762","114678","116592","117106","117114","117168","117266","117399","117415","117423","117432","117444","117500","117544","117555","117628","117656","117713","117714","117731","117787","117840","117873","117874","117896","117928","117943","117999","118040","118080","118154","118196","118226","118272","118323","118505","118559","118566",
        "118624","118633","118636","118660","118662","118733","118734","118744","118760","118775","118839","118878","118898","118913","118962","118989","118990","119043","119059","119166","119271","119320","119397","119498","119510","119523","119528","119606","119754","119770","119810","119834","119881","119915","119916","119920","119927","119928","119978","119988","120006","120012","120053","120102","120106","120138","120186","120202","120211","120218","120271",
        "120272","120275","120282","120333","120365","120370","120371","120415","120417","120456","120463","121324","98600","10744","117125","119619","119665","119725","119736","98601","21643","37141","37144","117085","117221","117333","117545","117770","117780","117796","117853","117855","117891","118131","118139","118165","118208","118394","118718","118916","119096","119121","119173","119548","119641","119815","119953","120180","120225","120466","120509",
        "98602","10746","121329","117154","117352","117384","117454","117546","117801","118009","118140","118518","118651","118963","119524","119721","119993","120087","120100","120157","120369","98603","10747","37147","101718","101768","117126","117410","117455","117828","117951","117954","118520","118554","118579","118620","118623","118683","118692","118714","118779","119097","119229","119616","119857","119872","119901","119911","119936","120074","120116",
        "120269","120510","121343","121345","98604","10748","21638","21639","109772","121330","117217","117236","117284","117422","117501","117757","117825","117920","118053","118063","118395","118409","118608","118621","118663","118879","118935","118952","119060","119098","119551","119688","119722","119888","120148","120378","120387","98605","10718","10750","104108","105573","109766","117420","117425","117478","117514","117541","117547","117575","117601",
        "117613","117634","117781","117795","117799","117802","117842","117858","117876","117905","117953","117972","117981","117989","117993","118010","118041","118095","118100","118145","118173","118262","118305","118364","118372","118383","118396","118482","118576","118643","118668","118739","118740","118753","118823","118873","118885","118960","118994","119003","119015","119093","119099","119174","119253","119395","119399","119438","119453","119542","119713",
        "119737","119746","119749","119794","119798","119869","119873","119889","119921","120013","120015","120023","120029","120037","120057","120181","120217","120239","120278","120299","120351","120407","120443","120470","120499","120501","121346","121352","121353","121357","98606","10751","21626","101428","117115","117149","117334","117481","117585","117614","117660","117679","117706","117726","117742","117892","118071","118174","118317","118343","118365",
        "118397","118506","118669","118686","118754","118767","118880","118995","119061","119122","119161","119204","119434","119882","119940","119994","120051","120114","120124","120276","120283","120428","120437","98607","10756","21628","101703","117084","117107","117120","117156","117357","117437","117479","117482","117508","117511","117727","117743","117862","117875","117906","117962","118042","118124","118234","118342","118400","118560","118671","118788",
        "118807","118809","118947","118998","119230","119321","119666","119677","119738","119828","119890","119925","120033","120161","120245","120249","120451","120460","98608","10752","21645","21658","101649","103816","103819","117076","121319","117116","117206","117262","117285","117430","117456","117483","117548","117593","117602","117639","117867","117929","117977","117982","118016","118058","118093","118201","118366","118605","118631","118654","118768",
        "118894","118927","118970","119115","119148","119231","119299","119549","119607","119678","119726","119840","119868","119883","119929","119998","120233","120388","120413","120418","120430","120511","98609","10753","110265","117127","117277","117316","117484","117947","118561","119062","119232","119884","119909","120246","120513","98610","21629","101641","117117","117249","117359","117385","117485","117577","117594","117623","117669","117785","117791",
        "117836","117837","118000","118125","118146","118222","118225","118235","118398","118635","118670","118678","118824","118901","119017","119123","119233","119543","119658","119712","119747","120093","120115","120238","120414","98611","10755","21118","103562","109761","110269","117070","117119","117244","117314","117411","117424","117512","117586","117670","117683","117698","117711","117728","117886","117897","117898","117901","117916","117941","117948",
        "117959","117966","117973","118192","118324","118463","118487","118540","118644","118652","118653","118679","118689","118705","118769","118776","118796","118801","118943","119018","119048","119063","119124","119149","119175","119293","119502","119559","119585","119586","119600","119627","119703","119723","119742","119776","119789","119895","119902","119945","120088","120183","120226","120300","120334","120344","120373","120398","98612","10757","101461",
        "117412","117509","117603","117676","117685","117868","117887","117942","117974","118132","118147","118153","118399","118541","118606","118747","119016","119125","119205","119425","119854","119891","119999","120038","98614","10761","117155","117278","117492","117709","117744","117762","118036","118126","118133","118148","118401","118507","118600","118607","118698","118699","118748","118799","118810","118914","119234","119270","119439","119556","119671",
        "120065","120212","120380","120395","120396","120419","98615","10760","10762","101611","117235","117413","117549","117710","117771","117822","118115","118413","118484","118519","118891","119220","119518","119544","119695","119701","119941","120228","121360","98616","10763","117100","117169","117260","117486","117615","117745","117899","118127","118881","118964","119064","119206","119426","119519","119755","119908","120014","120158","98617","10765",
        "21634","21636","21637","101064","101624","115078","117108","117174","117175","117207","117337","117487","117610","117755","117831","117893","117930","118325","118433","118601","118622","118645","118737","118791","118811","118893","118948","119019","119252","119288","119289","119390","119394","119545","119667","119711","119809","119910","120097","120103","120219","120423","120498","121320","116704","10725","109760","116270","121347","116705","10716",
        "21622","120859","219","120860","21619","120982","10717","120983","102560","120984","21647","120985","101754","120986","110906","120987","102559","120988","10758","10764","21640","120989","10734","120990","10745","120991","20571","120992","215","120993","20523","120994","20728","21620","21633","120995","10754","120996","21630","120997","21623","120998","217","120999","214","121000","10729","121001","20576","121002","21641",
        "121003","21621","121004","37120","121005","100471","121006","21651","121428","121007","21735","121008","21644","121009","21635","10645","98697","20192","98698","116701","117264","117267","117305","117317","117528","117829","117878","117976","118348","118971","119065","119216","119322","119692","119709","119727","119855","120069","120128","120129","120130","120131","120132","120133","120134","120135","120136","98699","100446","117261","117864",
        "98700","20193","98701","100447","98702","100448","117128","117144","98703","20194","117694","118117","118319","98705","100665","117321","98706","20195","101383","117129","117145","117308","117784","118800","119590","98707","100666","98708","34323","118033","119050","120070","98709","100667","117865","98710","10647","117268","119066","119117","120338","98711","10648","101699","118349","98712","100668","110297","117130","98713","100669",
        "101427","119743","98715","21700","117131","119546","120339","98716","20196","117132","118773","118938","119067","119141","119728","119744","98717","20587","101734","117146","117450","117752","120071","120512","116706","10649","121272","116707","10646","121280","120914","4","10650","98718","100670","98719","29399","109768","116702","118101","118522","118803","118996","119686","119841","119912","120198","98720","100671","118327","98721",
        "100672","98722","100673","101503","119805","98723","10651","101577","118697","98724","100674","98725","10652","119733","98726","20184","98727","10655","119734","98728","100675","98729","100676","118102","98730","98731","100677","118328","98732","100678","118103","98733","20185","98734","100679","98735","98736","100680","98737","20186","119735","119777","98738","100681","98739","20187","98740","98741","20908","100682","98742",
        "20189","98743","20190","110295","98744","20191","120933","191","110296","120934","10653","120935","20188","120936","10654","120937","21701","120938","26899","10658","98745","10656","10657","103813","103814","119611","119757","120314","98746","10659","117686","119044","119511","119659","98747","10660","119512","119660","119758","98748","98547","110264","117178","117506","118469","118953","98749","10662","101629","117572","118764",
        "98750","10663","117687","119513","120315","98751","118470","118795","119427","119433","98752","10665","117228","98753","10667","119759","98754","118316","98755","10669","37129","100984","101395","117688","118954","98756","10666","117689","119150","98757","10670","37143","101619","117609","117690","118334","119760","98758","20629","117161","117241","117691","118939","98759","10671","117328","119428","119822","119967","120316","98760",
        "20757","117692","119429","120317","120853","192","120854","10668","120855","10664","120856","10661","120857","20678","10672","98761","10686","119068","119714","119816","98762","10673","101720","109774","118835","98763","10674","98765","10676","119407","98766","100685","98767","100686","101401","117582","118836","119069","98768","100687","118241","98769","20226","98770","10677","117983","119594","98771","100688","98772","10685",
        "101701","117426","118837","119568","98773","20686","98774","10678","117777","119452","120027","120035","98775","20227","98776","100689","117227","117583","118999","119070","119408","98777","34140","117911","119254","119595","98778","100690","117427","98779","10679","119250","98780","10680","117143","120083","98781","100691","119071","98782","100692","98783","20694","118242","98784","100693","119942","98785","100694","117096","117327",
        "119729","119983","119992","120044","120084","120392","120520","98786","100695","98787","10681","119596","98788","10682","117924","118243","118567","119072","98789","10684","119073","98790","100696","98791","20263","98792","10683","116709","10675","120842","193","108206","108207","108208","108209","108210","108211","120843","20268","10687","98793","100697","98794","118004","98795","20597","98796","37152","118017","98797","117208",
        "117326","117335","117449","117955","118005","118141","118344","118407","119245","119520","119592","120390","98798","102554","98799","37137","98800","20610","119569","98801","100698","117209","98802","100699","98803","100700","118006","98804","100701","98805","37127","37130","118883","119500","98806","20613","98807","20659","98808","100702","117210","118007","118884","98809","98810","20682","98811","119501","98812","20648","98813",
        "10692","120942","10689","120943","5","120944","10691","120945","20229","120946","10688","120947","10690","10693","98814","100703","117605","119761","98815","100704","98816","10698","20197","37153","117608","117824","117960","118209","118388","118717","98817","10696","117961","118543","119237","119401","119618","120191","98818","100705","101571","98819","20198","98820","20199","37145","37163","101758","117521","120445","98821",
        "100706","98822","20200","120411","98823","10695","20205","119762","98824","100707","98825","20201","98826","10697","117211","117522","117693","117803","117826","118514","118715","98827","20202","98828","20203","98829","20204","120192","98830","100708","117606","118378","119763","98831","20206","98832","20207","119764","98833","20208","98834","100709","117212","98835","100710","117616","98836","100711","98837","20209","120851",
        "967","120852","6","10699","98838","102538","98839","101631","98840","102539","98841","119074","98842","102540","98843","20215","98844","100501","117186","118026","118266","118389","118986","119075","120297","98845","21704","98846","20216","119076","98847","98848","102541","98849","20621","98850","10702","118391","118553","98851","101596","98852","102542","118416","98853","102543","98854","100650","98855","102544","110289",
        "98856","102545","98857","20218","98858","102546","98859","102547","98860","20219","118027","98861","120858","10704","121262","120957","7","120958","10700","120959","10703","120960","20217","120961","10701","10705","98862","100712","98863","100713","98864","100714","98865","100715","119976","98866","10706","98867","98868","100716","119849","98869","100717","101678","98870","100718","98871","100719","98872","117607","118420",
        "118899","120384","120467","120477","98873","117809","121331","98874","98875","20706","98876","100720","119435","98877","10709","34108","98878","100721","117903","98879","100722","119856","98880","100723","98881","10707","119850","98882","100724","98883","100725","98884","10708","117702","98885","100726","98886","10711","119977","98887","100727","119851","98888","100728","98889","121332","120928","10710","120929","8","120930",
        "20707","120931","20637","120932","20710","10712","98890","100729","98891","20210","117365","117445","117793","118214","119574","98892","20211","118426","98893","20266","101465","98894","100730","98895","100731","118427","120213","98896","117588","118215","118307","98897","20212","117446","118216","98898","100732","120214","98899","100733","98900","20213","121348","98901","100734","120215","98902","101396","117346","117379","117913",
        "118374","118403","118428","118523","118594","119597","120119","120216","98903","100735","117447","117765","98904","100736","118217","98905","20214","118429","98906","100737","98907","10714","117448","117790","120915","10713","120916","9","10772","98908","10768","98909","100738","98910","100739","98911","20593","98912","100741","98913","100742","120030","98914","100743","98915","100744","98916","100745","98917","100746","98918",
        "100747","98919","98920","34012","98921","117421","119405","98922","100749","98923","10771","98924","117310","117963","118198","118293","118361","118534","118985","119009","119572","119576","120031","120068","120438","98925","100750","98926","100751","98927","100752","98928","100753","98929","21722","98930","100754","98931","100755","120939","10769","120940","10770","120941","10","10776","98932","100756","98933","100757","98934",
        "100758","98935","21494","117772","120163","98936","10779","110281","98937","37146","98938","100759","118934","98939","20631","98940","100760","98941","100761","98942","20589","100762","120408","98943","100763","98944","10774","120336","98945","10775","98946","101727","117904","118385","118694","119593","120331","120457","120515","98947","100764","119954","98948","100765","120332","98949","98950","110273","120277","120409","98951",
        "20608","101553","110274","118149","119955","98952","100766","118200","98953","100767","98954","100768","98955","10780","118213","98956","100769","118096","118618","120917","10777","120918","10773","120919","10778","120920","11","10795","98957","10781","98958","10782","117329","117633","120385","98959","10783","98960","100770","98961","10784","101614","98962","10786","117595","98963","10787","117596","119300","98964","10788",
        "117330","98965","100771","119461","98966","100772","98967","10789","119377","98968","10790","98969","100773","98970","10791","119504","119672","120063","120420","98971","10792","117908","98972","10793","117700","98973","10794","117401","119673","98974","101589","117087","117331","117402","117597","117649","117680","117789","117807","118278","118280","118886","119257","119378","119552","119647","120028","98975","10796","101671","98976",
        "100774","119674","98977","10797","98978","10798","117403","118459","119553","98979","10799","110293","118142","98980","10800","119462","98981","10801","120948","12","120949","10785","10802","98982","100775","119463","98983","100776","98984","20661","117339","119430","98985","100777","98986","100778","119464","98987","98988","117990","119207","98989","100779","119213","98990","98991","100780","98992","100781","119465","98993",
        "100782","98994","100783","98995","100784","119466","98996","118068","98997","100532","119467","98998","100785","119507","98999","100786","119699","99000","100787","117991","99001","117340","117843","118419","119135","119468","119508","119612","119964","120075","120078","120152","121350","99002","100788","119208","99003","117341","99004","100789","120950","13","120951","10803","120952","20663","120953","20696","120954","20700","120955",
        "20701","120956","20265","10819","99005","26480","99006","10804","117550","118043","99007","20581","99008","10805","120345","99009","10806","119100","99010","119101","119323","119643","99011","100790","99012","10808","99013","20601","117551","119077","99014","117078","117170","117404","117439","117552","117663","117763","117986","118044","118075","118488","119078","119102","119393","119802","119806","119823","120472","99015","10809",
        "117664","99016","10810","101440","117171","117553","118045","119079","119103","119864","99017","100791","117554","119080","119104","99018","120346","99019","10812","110267","110268","117821","118046","118155","118903","119081","119184","119579","119865","99020","10813","119105","99021","20619","99022","100792","117172","119082","99023","10814","101498","118047","118076","99024","10815","118077","119083","99025","100793","119084","119106",
        "99026","10816","117665","99027","10817","119107","99028","10818","119085","99029","100794","119866","99030","100795","119086","99031","117946","117987","118048","99032","100796","119087","99033","100797","118049","119108","99034","100798","110291","99035","100799","118050","119109","99036","10821","119088","119110","99037","119089","119807","119867","99038","10823","119090","119111","99039","10824","118051","99040","100800","120921",
        "10820","120922","14","120923","10811","120924","102555","120925","102556","120926","10807","120927","10822","10832","99041","10825","99042","100801","118158","119324","119469","120356","99043","37164","118244","118777","99044","20667","118245","99045","10826","101572","117246","117617","118159","118246","119325","119470","119715","99046","100802","117463","99047","100803","117618","99048","10828","99049","100804","118247","99050",
        "100805","99051","10829","118248","99052","20649","37140","37162","100474","118249","119326","99053","100806","118778","99056","100809","117619","99057","20662","119327","99058","10831","37118","119471","120043","120357","99059","100808","119472","120358","99060","10833","101494","118160","118250","119448","99061","100810","117620","118161","119931","99062","10834","37124","118251","119328","119473","120359","120532","99063","20697",
        "117247","118252","119474","116708","10830","37123","121285","120844","15","100807","120789","120845","10827","120846","101692","120847","110907","10841","99064","100443","119176","99065","100444","117440","119588","99066","100445","119177","99067","20257","99068","10835","101437","119178","99069","20592","101438","118460","99070","10836","99071","100811","110292","99072","100812","117441","117869","119179","99073","100813","119180",
        "99074","100477","117870","120207","99075","20596","99076","10838","101439","110290","118206","119892","99077","118195","118254","119181","119329","120094","120530","99078","21154","118367","118461","118812","99079","10840","119188","99080","117871","117988","118136","118271","118442","118462","118521","118614","118955","119525","120232","120464","120517","120528","120848","16","120849","10839","120850","10837","17","10174","2",
        "20280","120600","120601","20339","20340","101378","120602","120603","20341","20343","100651","120604","20342","20344","120605","20281","120606","20338","120607","120608","120609","120610","20337","20282","120611","120612","102531","120613","20318","20330","120614","20321","120615","120616","120617","120618","20319","20320","20283","120619","120620","20327","20328","20329","120621","20331","120622","20326","120623","120624","120625",
        "20284","120626","20301","120627","120628","20300","120629","20302","20303","120630","20304","120631","120632","20285","120633","120634","120635","120636","20345","20346","120637","20286","101511","109773","120638","120639","120640","120641","120642","20287","116271","120643","20308","20309","20310","120644","120645","120646","120647","20306","20307","20288","120648","20315","120649","20314","120650","20312","20313","120651","20311",
        "120652","120653","120654","120655","20316","120656","20317","20289","120657","20332","120658","20335","120659","120660","20336","120661","20333","120662","20334","20290","120663","120664","20324","120665","20323","120666","20322","120667","21743","120668","120669","120670","20291","120671","100652","110348","114839","120672","120673","114838","120674","120675","20305","120676","20292","120677","20347","120678","20348","114766","120679",
        "120680","20354","20355","120681","20350","20351","120682","20349","20352","20353","20293","26081","120583","120584","120585","120586","120587","20294","37180","101564","102557","120592","120593","120594","120595","120596","120597","120598","120599","20295","10875","98546","120591","20297","10884","114765","120588","120589","120590","120791","20298","21776","98618","10861","10879","26099","117366","117881","118454","98619","10863",
        "22891","101533","101668","119698","119874","98620","10864","22914","22917","117367","118236","118299","118313","118339","119011","119282","119446","120034","98621","10865","10887","20325","21147","117088","117188","117368","117428","117459","117465","117490","117556","117647","117882","118008","118012","118227","118237","118276","118297","118337","118414","118515","118525","118526","118551","118578","118612","118617","118626","118680","118834",
        "118936","118944","118991","119183","119217","119391","119622","119654","119708","119724","119769","119930","120032","120036","120055","120101","120123","120196","120253","120400","120461","120475","120496","120523","120524","120525","121326","121327","98622","969","10869","10882","10885","10886","10889","37142","101500","101755","103815","117369","117414","117565","117578","117640","117648","117703","117935","118001","118238","118360","118598",
        "118658","119495","119509","119583","119638","119675","119694","119803","119842","119861","119893","119968","98623","10862","10867","21666","26069","101580","101635","101655","101722","101735","113195","117354","117370","117429","117567","118002","118315","118674","118726","118729","118736","118941","119277","119278","119613","119642","119682","119756","120096","120108","120144","120166","98624","10868","10870","117539","118290","118345","118390",
        "118404","119383","119771","119944","120288","120329","98625","10871","101605","117371","118548","98626","10872","10878","21795","101630","101640","117372","118785","119417","119418","119689","119923","119986","98627","10874","101565","117150","117373","117835","118455","98628","117176","117344","117504","117534","117707","117750","118292","118314","118456","118574","118731","119012","119185","119215","119218","119409","119451","119499","119631",
        "119704","119731","119772","119792","119835","120256","120516","98629","10876","101674","117883","118239","119386","119732","121325","98630","10881","22829","22925","117566","118457","118564","119049","98631","10873","10883","101600","116272","117764","118435","118659","119578","119626","119837","98632","10888","117374","117630","98633","10892","117375","118794","119875","98634","10877","10893","21023","117177","117568","117673","118240",
        "118458","119194","119283","119804","119876","120259","120292","120313","120321","120518","121356","121010","10891","10176","102441","10903","100664","101670","102442","121034","10902","10842","99081","10843","21688","117493","118069","99082","101044","99083","101045","99084","21463","99085","10844","118070","99086","21687","99087","21686","21690","22884","99088","101046","110276","99089","21691","101047","99090","101048","99091",
        "20114","99092","20602","99093","10847","21689","99094","10848","101558","99095","21043","21692","101563","119814","99096","21125","117494","118279","118696","120145","99098","20724","101529","99099","10850","101771","99100","10851","102447","102448","121011","20","121012","10849","121013","20115","121014","10846","121015","10845","121016","20117","10853","99101","20118","99102","101049","117386","99103","20119","120302",
        "99104","101050","117387","99105","10854","22980","99106","101051","99107","21679","117388","119784","99108","117389","117895","117923","117932","118511","118611","118761","118782","118897","119296","119515","119785","119824","120303","99109","20120","117390","119786","99110","20121","110288","99111","21680","117391","120347","99112","20122","117417","117933","119825","120304","99113","101052","99114","101053","99115","20123","117934",
        "99116","21681","120348","99117","20124","37148","117392","99118","101054","119787","99119","21683","99120","10855","21685","120305","99121","101055","99122","10856","118762","99123","20125","99124","100950","117393","119826","99125","29383","117394","117418","118304","119979","120452","120533","99126","21684","117395","118783","120306","121017","21","120790","121018","968","10857","99127","20135","101620","118975","119000",
        "99128","20136","20620","20671","99129","20137","101679","117360","117488","118011","118730","118976","119750","120446","99130","20138","99131","20139","117322","117489","99132","20140","99133","20141","20709","99134","20142","118977","99135","20143","99136","20145","99137","20146","20711","99138","20148","99139","20149","120447","110932","10858","20578","110933","10859","20599","121022","22","121023","20580","121024",
        "20603","121025","20144","121026","20147","121027","10860","121028","110928","10897","99140","20153","99141","10901","20154","100512","101733","101743","118054","118917","118937","120231","99142","101068","99143","10900","20151","100660","120024","99144","101069","101749","10895","101750","118061","110927","10899","20157","21665","116715","10894","116716","10896","116717","20156","116718","20155","116719","20152","116724","22049",
        "116725","10898","121287","121019","100536","121020","20150","121021","23","121228","10904","99145","10905","99146","10906","101409","99147","10907","101566","119779","99148","10908","99149","10913","99150","10914","118974","119187","99151","10915","101622","101707","99152","10909","99153","10910","119127","99154","10911","99155","10919","117288","117580","117759","118628","119128","119137","119591","120118","120220","120444",
        "99156","10912","101626","113187","117289","118629","120252","99157","10916","119129","99158","10920","37131","99159","10921","120221","99160","10922","99161","10923","119130","119780","99162","10917","99163","10924","99164","10925","119131","99165","10918","121031","24","10926","99166","10927","99167","117400","99168","20583","117827","119400","99169","21663","118406","99170","10929","99171","101071","99172","101072",
        "99173","21664","99174","20681","99175","20582","99176","10930","99177","20633","99178","20641","99179","101073","99180","10931","118150","99181","21659","99182","20623","99183","118978","119985","120247","99184","20585","99185","21046","99186","20584","99187","10932","21662","120004","99188","21660","99189","101074","121032","25","121033","10928","10933","99190","10938","101741","99191","21459","99192","20126",
        "22420","99193","10934","21696","118370","99194","20127","99195","101075","101584","101648","99196","20128","22737","101568","99197","101076","99198","20129","99199","20130","99200","117532","118797","99201","101077","120362","99202","20131","99203","10936","101639","99204","20132","110934","10937","22805","117635","116726","10935","121030","18","10939","99205","20133","99206","20811","101078","99207","20134","99208",
        "21444","101079","99209","101080","99210","10942","99211","21041","99212","10943","99213","101544","102443","118059","99214","101081","99215","21150","29049","99216","21363","100913","101082","101576","99218","21695","101083","99219","21160","118060","99220","101084","116720","10945","116721","10940","116722","10944","116723","10941","121029","19","109765","26","10946","99221","20167","21369","119990","120025","99222",
        "20616","118162","99223","100653","117570","119091","99224","100654","118163","118441","99225","20168","119092","99226","100655","110275","99227","100656","99228","20169","117313","119644","119991","120046","120227","99229","100657","118267","118530","119403","120203","120514","99230","20170","117218","99231","100658","121164","10947","121165","37","10950","99232","10948","99233","10949","99234","10952","117931","118524","119275",
        "99235","10953","99236","10954","99237","10955","99238","10956","118480","99239","10957","99240","10958","119330","119697","99241","10973","101694","117181","118889","120280","99242","10974","99243","10960","99244","10961","99245","10962","99246","10963","99247","10964","101567","117732","99248","10965","101793","101794","119860","120050","99249","10966","99250","10967","99251","10968","99252","10969","99253","10970",
        "99254","10971","119331","99255","10972","10984","119811","99256","10975","99257","10976","117356","119710","120189","120355","99258","10977","99259","10978","34567","118338","121333","99260","10979","118481","99261","10980","99262","101795","119534","99263","101796","99264","10983","101552","121159","38","108218","108220","108221","108222","108223","108224","108225","108226","101792","121160","10951","101791","121161","10959",
        "121162","10982","121163","10981","10995","99265","20183","117216","120340","99267","10986","37016","101711","118018","99268","100630","101672","99269","10988","100545","117505","118019","118350","119751","120484","99270","100631","119506","120377","99271","100632","117280","118020","118183","118443","119169","119196","119332","119957","99272","20675","117661","118351","118436","119189","119249","119958","99273","20264","101610","117093",
        "117495","118024","118965","119247","119570","120048","120485","99274","10993","101499","117348","117832","118437","118921","119333","119959","120440","99275","10996","100633","118211","118352","119334","99276","100634","117758","118568","120040","99277","21129","101450","118220","119167","120375","99278","20688","118353","119571","120486","99279","100635","118116","118379","118425","118772","119200","119335","119668","120049","120222","99280",
        "100636","99281","10997","101809","117537","118289","118444","118471","118904","119002","119248","119420","120487","99282","20702","118354","118445","119336","119752","120165","120488","99283","21016","117671","118301","118355","118430","118446","119337","119707","99284","21018","101468","109764","118447","119669","99285","20230","118580","119338","99286","21030","21313","99287","20231","117349","118356","119650","119656","119956","120489",
        "99288","100637","101442","118021","118510","118982","119339","119960","120490","99289","100638","101451","115082","120491","99290","20269","101586","119340","120492","99291","11000","116176","119341","121334","99292","100639","118176","118448","118693","119168","119190","119342","119947","120389","121361","99293","20704","117157","118380","119651","119965","99294","100640","99295","100641","119343","119961","120433","99296","20677","101470",
        "101508","101628","116843","117215","117538","117573","117631","117695","118014","118472","119344","119505","119657","119896","120072","120151","99297","21141","117350","118357","118449","118581","118789","118981","119193","119345","119748","119962","99298","11002","101647","117189","117351","118450","119440","119645","119963","120493","99299","1058","21479","112002","117091","117804","118180","118431","118485","118496","118610","118973","119199",
        "119346","119582","119646","120243","120431","99300","100642","117808","118022","118362","99301","20693","117258","117587","117792","118023","118296","118451","118556","118987","119347","120494","99302","100643","101590","116897","970","101808","116898","10990","103560","116579","116899","10991","101807","116900","239","114797","20910","114798","10994","20777","114799","10992","10998","116577","116578","121308","114801","116901","10987",
        "101806","116902","1107","10989","101621","101710","101805","121158","35","108213","108214","108216","108217","11004","99303","100624","119264","99304","100625","99305","100626","99306","100627","100659","101617","119584","119858","119966","99307","21731","117214","119126","119265","119276","120039","120473","120503","99308","100628","120190","99309","101810","121166","1093","121167","11005","11015","99365","20177","99366","100577",
        "99367","21528","99368","20178","99369","100578","99370","100579","99371","100580","99372","100581","99373","100582","99374","100583","99375","100584","99376","21527","99377","21526","121168","1094","11029","99408","101827","117844","118210","118475","118531","119155","119295","119830","99409","11031","21668","21669","117363","118466","118582","120465","120526","121335","99410","11032","99411","11034","117338","117738","118329",
        "118583","120007","99412","100557","99413","100558","119690","99414","100559","99415","101828","117845","118555","99416","100525","117846","118584","99417","11039","120137","99418","100560","99419","11040","117847","118805","99420","11041","99421","21671","117604","118902","119159","99422","100561","118911","99423","11044","118467","99424","11046","101705","99425","11045","118298","118912","99426","100562","99427","100563","99428",
        "100564","99429","11047","101696","117579","118585","119156","99430","100565","99431","11048","117848","118586","99432","21670","117355","118468","118497","118588","118589","99433","11050","101390","117162","119831","119924","99434","100566","99435","11042","101598","117223","118182","118212","118423","118489","99436","100567","117849","99437","100568","99438","20713","99439","100569","99440","21667","99441","11051","117655","99442",
        "20638","99443","100570","99444","100571","117133","99445","100572","117457","117968","99446","100573","119691","99447","20228","120026","99448","11052","99449","100574","99450","11035","121146","39","108163","108165","108167","108168","108169","108170","108171","108173","121147","971","121148","11036","121149","238","121150","11043","110277","121151","11053","121152","11030","121153","11037","121154","11049","121155","11033",
        "121156","11038","121157","100451","40","11070","99477","101085","99478","101086","119621","99479","20019","119442","99480","101087","99481","20022","99482","101088","118083","99483","37122","118417","99484","101089","99485","20021","99486","101090","99487","101091","118828","99488","119443","99489","117851","99490","101092","119005","99491","101093","99492","20024","113204","99493","20025","99494","20026","99495","101094",
        "99496","101095","117496","99497","20027","99498","20028","99499","101096","99500","101097","118829","120077","99501","20029","99502","101098","99503","101099","99504","101100","99505","101101","99506","117497","118084","99507","11074","117852","99508","101102","99509","101103","99510","101104","99511","20030","99512","101105","99513","101106","99514","101107","118940","99515","11075","120973","46","11072","120974","110926",
        "120975","20020","120976","11071","110299","120977","11073","120978","20023","11077","99516","99517","119267","99518","20627","110307","120109","120426","99519","101201","99520","101202","99521","101203","99522","101204","115658","119268","119279","119284","120107","99523","21723","101205","99524","101206","99525","101207","99526","101208","99527","101209","99528","20642","99529","101210","120979","41","120980","20721","120981",
        "20630","11079","99530","20611","110300","120254","99531","117251","118920","99532","20035","117361","117657","99533","20036","101435","117854","118517","119302","99534","101108","99535","101109","99536","20037","118634","119381","99537","101110","99538","101111","99539","101112","99540","21710","102537","99541","20038","119739","99542","101113","99543","11081","20039","110279","110280","118164","118932","119740","120479","99544",
        "101114","99545","101115","117252","99546","20040","118928","120439","99547","21711","99548","20041","20042","117253","99549","101116","99550","101117","99551","20043","99552","100538","119348","99553","101118","99554","101119","99555","20044","29391","117254","117343","117861","117952","119116","119382","119741","120307","99556","20045","99557","20046","99558","20047","117376","99559","20048","99560","11082","37155","37157",
        "117830","99561","20049","20258","99562","20609","99563","101120","99564","101121","110285","99565","20050","117255","99566","20051","120255","99567","101122","99568","100508","99569","101123","99570","101124","99571","101125","117256","99572","101126","110298","99573","20052","117257","99574","20053","99575","101127","99576","20817","117377","99577","20054","116727","972","101961","120582","120911","47","101949","116593",
        "116594","101942","101957","116595","116596","116597","116598","116599","116600","116601","116602","116603","116604","101940","101941","116605","116606","116607","116608","116609","116653","116654","116655","101939","101950","116610","116611","101934","116612","116613","101944","116614","116615","116616","116617","116618","116619","116620","116621","116683","101935","101951","116622","116623","116624","101937","116625","116626","101938","116627","116628",
        "116629","116630","116631","116632","101936","101952","116633","116634","116635","116636","116637","116638","101945","101946","116639","116640","116641","116642","116643","101953","116644","116645","116646","116647","116648","116649","116650","116398","116651","116652","101954","116656","116657","116658","116659","116660","116661","116662","116663","116664","116665","116666","116667","116668","116669","116670","116671","116672","101955","116673","116674",
        "116675","116676","116677","116678","116679","116680","116681","116682","101956","116685","116686","116687","116688","116689","116690","116691","116692","116693","116694","116695","116696","116697","116698","116699","116700","120912","11083","120913","11080","11084","99578","20031","99579","101129","99580","21716","99581","101130","99582","101131","99583","101132","99584","118104","118843","99585","110282","99586","11087","99587","101133",
        "99588","21715","99589","21717","21718","99590","21719","99591","21714","118105","99592","11088","99593","101134","118106","118844","99594","101135","99595","21720","120474","99596","11089","99597","101136","118107","118845","99598","29390","117527","118108","118177","118587","118979","99599","11092","99600","21713","99601","101137","101534","118846","99602","21721","118847","99603","11093","99604","20600","99605","101138",
        "118848","99606","11094","118849","99607","20033","118109","99608","101139","99609","20254","99610","21712","118110","99611","101140","99612","20034","120872","48","120873","11085","120874","20032","120875","11090","121251","120876","11091","120882","11086","120883","102536","11095","99613","101141","99614","101142","99615","11096","99616","11097","117466","120379","99617","101143","117467","99618","20056","29652","120361",
        "99619","100623","99620","101144","99621","11099","99622","101145","99623","11100","99624","101681","119623","99625","101146","99626","11102","99627","101147","99628","11103","118029","99629","101148","99630","101149","99631","11104","118030","99632","11105","110286","99633","101150","99634","110925","117187","118031","118595","99635","11106","109771","119781","99636","101151","99637","37121","99638","101152","117468","99639",
        "11107","120962","49","120963","11098","120964","11101","11108","99640","101153","99641","102535","99642","101154","113189","99643","20634","99644","20628","119447","120174","99645","101155","99646","20909","101156","119349","99647","21739","110308","119813","99648","101157","99649","20249","99650","101158","99651","117290","117926","118358","118599","119575","120410","99652","20245","20251","118942","119192","120322","99653",
        "20252","99654","101159","99655","20246","21737","119375","119846","99656","20607","117291","99657","20247","119421","99658","21738","37149","37161","101436","117232","117646","118359","118529","118535","118649","118933","119286","119350","119573","120286","120308","120323","120480","99659","21740","99660","99661","21742","117292","120318","99662","101160","117192","99663","20590","117293","119041","99664","101161","99665","20588",
        "21152","118288","119285","119847","99666","20679","117095","119376","100462","20653","120285","120506","100463","20626","100464","20248","100465","20236","21741","119317","119373","100466","20635","100467","20244","117841","118550","100468","20712","117286","117516","118700","110910","110923","119903","110911","110922","110912","110921","119318","110913","11109","21736","119294","110915","117265","117287","110916","20243","118281","119374",
        "119649","120319","110917","110919","118347","110918","110920","118706","119812","120888","50","108186","120683","120684","120685","120686","120687","120688","120689","120690","120691","120692","108187","120693","120694","120695","120696","120697","120698","120699","120700","120701","120702","120703","120704","108188","120705","120706","120707","120708","120709","120710","108190","120711","120712","120713","108191","120714","120715","120716","120717",
        "120718","120719","120720","120721","120722","120723","120724","120725","120726","108192","120729","120730","120731","120732","120733","120734","120735","120736","120737","120738","120739","120740","120741","120742","120743","120744","120745","120746","120747","120748","120749","108193","120727","120728","108195","120889","20237","120890","11110","120891","20250","120892","11076","120893","102534","11111","99667","37165","101162","118064","118411",
        "118850","99668","101163","118851","119024","99669","101164","119025","99670","101165","118852","99671","101166","118853","119026","99672","20673","99673","101167","118854","119027","99674","101168","99675","20714","101543","117101","119833","99676","101169","99677","20259","37173","110283","117956","119028","119153","99678","101170","118855","119412","99679","20689","119029","99680","101171","117811","99681","11112","117812","118856",
        "119030","99682","101172","118857","99683","101173","119031","99684","101174","99685","101175","117813","118858","119413","99686","20639","118859","99687","101176","118860","119351","99688","20668","118922","99689","101177","117102","118701","118861","99690","101178","99691","101179","117814","99692","101180","118862","119352","99693","101181","99694","20718","118203","118863","119414","99695","101182","99696","101183","119353","99697",
        "101184","117103","117815","118702","118864","119032","99698","101185","99699","101187","99700","101200","113206","117513","99701","101199","99702","101198","118865","119415","99703","20715","37150","117816","118866","119033","99704","101197","99705","101196","118867","119034","99706","101195","119035","99707","101194","119416","99708","102530","120521","99709","101193","117817","99710","117994","118750","118868","118972","119036","119782",
        "99711","101192","99712","20717","101575","119037","119897","120089","99713","117080","117222","117818","118090","118569","118814","118869","118931","119001","119038","119281","119354","119791","120153","120393","120497","121323","99714","20680","118923","120263","99715","101191","118870","119039","99716","101190","101663","118871","99717","101189","119040","99718","101188","117151","117152","117805","117819","118091","99719","101186","118872",
        "99720","20656","120868","11114","120869","11113","120870","20716","120871","172","108174","108175","108177","108179","121318","108180","108181","108183","120903","11116","120904","11115","120905","20235","120906","37172","120907","37139","11117","42","20010","20011","99721","20006","120234","99722","101211","99723","101212","120363","99724","101213","99725","101214","99726","101215","118408","99727","101216","99728","29382",
        "110272","110284","119301","99729","20007","99730","101217","118202","99731","101218","99732","99733","101219","99734","20008","99735","101220","117198","117303","117342","99736","101221","99737","99738","101222","99739","20009","99740","101223","99741","101224","99742","101225","110306","11119","11120","11121","11122","11123","11124","11125","11126","11127","11128","11129","20013","20586","99743","20012","99744","117109",
        "99745","101342","99746","101343","99747","101344","117294","99748","101345","99749","37128","101736","117295","99750","101346","99751","100514","99752","101347","99753","99754","101348","99755","117296","99756","99757","101349","118949","119355","99758","101350","117297","118542","118708","119894","120267","120391","121321","99759","101351","101713","99760","99761","99762","29396","101613","110301","110302","117097","117263","117884",
        "119202","119356","119396","99763","101352","110304","99764","101353","99765","101354","99766","20606","117298","117636","118709","118735","119526","120064","120268","99767","99768","20015","99769","20016","99770","20017","99771","101355","101448","99772","118255","118465","118710","99773","101356","99774","117299","99775","101357","99776","101360","117306","99777","101359","110303","99778","100516","115447","99779","20014","99780",
        "20018","99781","117307","117347","99782","101358","99783","101361","99784","117300","99785","100980","120894","43","102022","116402","116404","116405","102023","116403","102024","102029","102030","102031","102032","102033","102034","102025","102026","102027","102028","120895","236","11131","99786","98566","117077","99787","29384","117469","119521","99788","101362","120310","99789","101363","120495","99790","101364","99791","101365",
        "117470","99792","101666","117519","117880","118545","118657","119160","119529","119605","119661","119783","120079","120080","99793","101366","99794","101367","99795","101368","99796","100533","118494","120175","120311","99797","101402","117651","117833","118291","120117","99798","101369","99799","101370","99800","101371","99801","29388","117471","117571","118333","118830","119221","119269","99802","11134","120291","99803","101372","99804",
        "117472","99805","101373","119292","120312","99806","101374","101538","120104","99807","101676","117473","117629","118065","119604","119790","120184","120505","99808","29389","117464","117474","117531","118792","99809","101375","99810","101376","118495","99811","101377","117475","99812","101379","120861","51","102039","102048","102040","102041","102049","102050","102051","102052","102053","102042","102056","102043","102054","102055","102044",
        "121317","102045","102046","102047","120862","11132","120863","11133","121300","120864","11135","120865","11138","120866","11139","120867","11141","120908","240","120909","11137","120910","11136","11146","99813","11142","99814","20057","118111","118969","119357","99815","20058","117134","99816","101254","99817","11143","118112","99818","11144","119358","119478","120058","120343","99819","101255","117135","99820","11145","101463",
        "117323","99821","101256","120270","99822","101257","117182","119359","119479","99823","101262","117136","99824","101263","117137","120478","99825","20059","117183","118453","119360","99826","20719","99827","20060","99828","20061","99829","20062","99830","101264","119361","99831","101265","119362","119480","99832","20063","117138","120059","99833","101266","117139","99834","20064","119481","99835","100530","99836","101267","119363",
        "99837","20065","99838","101268","99839","20066","99840","101269","99841","101270","99842","20067","117140","119482","99843","101261","99844","117141","117281","117872","118085","119164","119970","120424","99845","21724","117142","99846","101260","120067","120425","99847","101259","99848","101258","99849","20068","101434","118113","99850","11147","117650","119235","119636","119655","120060","120458","120884","102532","120885","194",
        "108227","108228","108229","108230","108231","121309","108233","120886","34087","120887","110924","11148","99851","101320","119564","99852","101321","101772","99853","101322","119364","99854","119483","99855","119365","99856","101323","99857","101324","99858","101325","117462","119366","119484","119565","120042","120349","99859","101326","120296","99860","20072","99861","101327","99862","101328","99863","101329","99864","101330","119485",
        "99865","101331","99866","101332","120264","99867","118283","99868","37135","101737","102528","119367","119486","99869","101333","99870","101334","99871","101336","99872","101337","99873","101338","99874","101339","99875","101340","120877","44","120878","11152","120879","11150","120880","11151","120881","11149","11153","99876","101239","99877","11154","99878","101240","117270","99879","20069","110287","99880","21733","101548",
        "99881","101241","99882","101242","99883","119136","99884","29140","101244","117271","99885","101245","99886","37134","99887","101246","99888","101247","119368","99889","20071","119917","99890","101248","99891","101249","117820","99892","101250","117272","99893","101251","99894","101769","117353","118558","99895","101252","99896","101253","117191","118661","118831","119369","120965","11155","120966","195","120967","20070","11156",
        "99897","99898","101226","99899","101227","99900","101228","118204","99901","100535","99902","99903","20075","99904","101229","99905","101230","99906","101231","99907","20076","99908","101232","118256","99909","101233","119799","99910","101234","99911","20077","119800","99912","101235","101690","118205","119922","99913","101236","118257","99914","99915","20079","118258","99916","101237","99917","101238","120968","20073","120969",
        "45","120970","37133","120971","20078","120972","20074","52","11158","99918","100815","99919","100816","99920","100472","99921","20640","99922","100817","99923","100818","120372","99924","20646","99925","11157","117275","117502","118615","119140","99926","20683","99927","100819","99928","20612","99929","100820","117503","99930","100821","99931","20625","99932","100822","99933","100823","99934","100824","99935","100825",
        "99936","100826","99937","101473","119589","99938","100827","99939","20708","99940","20618","118790","99941","100828","119274","121138","53","121139","11159","11162","99942","20695","101638","99943","37168","121258","121261","99944","100829","99945","100830","99946","100831","99947","20579","121250","121279","121281","121290","99948","20233","121247","99949","11161","99950","20605","99951","101664","102438","99952","116739",
        "99953","116738","121260","99954","29398","117909","119290","119370","119620","99955","116740","121270","99956","20654","121294","121302","99957","20624","37138","110271","117517","120005","99958","20636","100522","121254","99960","37126","99961","20684","121278","99962","110311","99963","100832","99964","20256","118546","99965","20262","20595","21821","29402","121252","121282","121284","121296","121303","121305","99966","100833",
        "99967","20685","99968","20225","121283","121297","121304","99969","100834","121273","99970","20705","99971","37119","100835","121259","114703","116154","121286","114704","37169","114705","11160","114707","29397","114708","110305","114709","116160","114711","114712","114713","21370","121255","114715","20720","117238","118003","118193","118452","119617","114716","37159","114719","103820","114721","114794","114795","116737","119045","114722",
        "37154","114724","20657","114727","20703","114729","11164","114732","20669","114733","20234","114734","20604","114735","11165","119788","114736","20660","114738","11166","116307","114739","11167","114740","116155","121268","114742","116156","114743","11169","114744","11168","114745","20687","114746","11170","114747","116157","114748","11171","117309","119158","119251","120052","114749","21726","114751","20224","114752","114796","114753",
        "116161","114756","20672","114757","11172","114758","21725","118373","114759","116159","114760","116158","121110","54","101975","101982","101976","101977","101983","101984","101978","101947","101948","101979","101980","116399","116400","101981","101985","101986","121111","11163","121112","20664","121113","20691","11176","99972","100836","118619","99973","100837","99974","100838","99975","100839","118896","99976","100840","120294","99977",
        "100841","99978","100842","120273","99979","100843","119984","99980","117589","120076","99981","100844","99982","100845","117180","99983","100846","119926","99984","21119","99985","100847","99986","119648","99987","101056","117318","117535","117748","117800","118277","118664","118924","119379","119445","119496","120274","120381","121271","99988","20750","21336","100848","117797","99989","100849","99990","100850","99991","99992","100851",
        "118780","99993","114761","20647","121134","55","121337","121135","11175","121136","11173","121137","11178","11193","99994","11179","101582","99995","21128","98567","100852","101460","99996","11183","101385","101546","113203","99997","101387","118273","119829","99998","21728","101496","119154","100000","11190","101625","113207","100001","20676","21727","101573","101612","117245","117273","119827","119981","100002","101539","117274",
        "117734","118285","119730","100683","100853","101421","101603","120146","121121","57","121122","973","121123","1091","121124","11184","121125","11186","121126","11177","121127","11180","121128","11192","121129","11188","121130","11189","121131","11181","121132","11182","121264","121133","11187","11225","100003","11194","118723","119454","100004","11195","120250","100005","11196","20617","37125","37171","118493","119455","100006",
        "11197","101058","100007","11198","100008","11199","118793","119943","120019","100009","100854","101554","117922","100010","11203","37136","117912","100011","11204","101388","120242","100012","11205","20759","100013","11206","119303","100014","11213","118557","118724","118817","119304","119531","120309","100015","100855","120279","100016","11209","118703","119305","100017","100856","119402","119532","100018","20632","119456","100019","11215",
        "119533","100020","11217","37166","101645","100021","11201","117458","117945","118013","118432","118483","118719","118725","118818","119272","119615","119778","119817","119949","119982","120149","100022","119818","100023","11221","118819","100024","11222","118820","119306","100025","118821","120176","120201","100026","11226","100469","20666","118034","118424","100470","11208","119458","119768","114702","11216","116879","235","116880","11212",
        "29653","116881","11214","116882","11207","116883","11202","116884","11210","116885","11223","116886","11200","116887","20650","121114","102439","121115","56","108155","108156","108157","108159","108160","108161","108162","121338","121116","11218","121117","11220","121118","11227","121119","11219","37151","121120","11224","11232","100027","20875","100490","100028","11229","21694","101382","101502","113188","100029","100857","101579",
        "100030","20255","103557","117626","119683","119684","120330","100031","100858","113191","100032","100859","100033","21136","23341","121140","58","121141","11231","121142","11230","121143","11228","121144","11174","121145","23329","59","10231","98644","11320","98645","11321","118549","120009","98646","101011","118268","98647","11322","117810","98648","101012","101783","98649","101013","118269","120504","98650","11323","98651",
        "21729","118270","120289","120469","98652","11324","119913","98653","11325","121107","11319","10233","98654","101027","98655","11332","98656","11336","98657","11334","98658","101778","101779","98659","101028","101780","98660","101029","98661","11335","98662","101030","98663","11331","98664","101031","98665","101032","98666","11337","98667","101033","98668","101034","98669","11338","101781","101782","121108","11333","121109",
        "36079","11235","100034","119307","100035","100860","100036","100861","100037","117925","118732","119487","100038","11238","120061","100039","100862","119488","100040","100863","100041","100864","100042","100865","118570","119489","100043","100866","100044","100867","100045","100868","100046","101686","100047","11241","119308","100048","100869","101455","117434","119309","100049","100870","100050","119310","100051","100871","100052","100872","100053",
        "100873","118571","100054","100874","100055","100875","100056","11243","119311","100057","100876","100058","100877","119312","100059","11239","100060","11244","100061","11245","100062","100878","100063","100879","100064","11247","118572","119259","120382","100065","100880","100066","118573","119490","119836","119980","100067","100882","100068","11248","100069","11249","100070","11250","100071","100883","100072","100073","100074","100884","119491",
        "120120","120481","100075","100885","118331","100076","100886","100077","100887","100078","100888","119313","100079","100889","100080","11253","101537","100081","100890","100082","100891","100083","100892","100084","11254","119314","100085","100893","100086","100894","100087","11255","100088","100895","100089","100896","100090","100897","117419","100091","100898","100092","100899","100093","21698","101775","121085","197","108234","108236","108237",
        "108239","108241","121086","975","121087","11251","121088","11240","121089","11236","121090","11252","121091","11242","121092","11234","121093","20080","121094","11246","121095","21697","11266","98673","110944","98674","110945","98675","110943","98676","110942","98677","110941","98678","11354","118386","100094","11256","118786","100095","100915","100096","11260","100097","11262","119610","120482","100098","100917","118907","100099",
        "100918","120241","100100","100101","30813","117754","117806","118156","118716","118720","118728","118745","118908","119297","119444","119558","119577","119948","120141","120287","120342","120483","100102","100919","101403","120257","100103","11263","21145","100104","100920","100105","11267","120258","100106","100921","100107","100922","100108","11264","21038","120350","100109","11268","37170","118547","120459","100110","30629","100923","100111",
        "11257","20096","100487","117158","118536","100112","11259","11270","118369","120142","120500","100113","98545","120432","100114","11258","118537","118890","119197","120143","120164","100115","119859","100116","20097","100117","100924","100118","118840","100119","100925","100120","11275","117233","117364","121075","63","108242","108243","108245","108247","121076","976","121077","11273","121078","11271","121079","11272","121080","11265",
        "121081","11269","121082","30614","121083","11274","11282","100121","100122","11280","11294","102430","120000","100123","11281","100124","102433","117242","117523","117919","118704","118804","119238","120001","120536","100125","11284","118062","100126","100127","11286","102431","100129","102427","117910","117995","119239","120002","120150","120404","121339","100130","102429","119240","100131","11293","119432","119580","100132","11295","20820",
        "102440","118284","100133","11296","100134","11297","102432","100135","11298","100136","11279","100137","102428","119662","100138","11301","119241","120092","100139","11300","118332","121059","110939","110309","121060","64","121061","237","121062","11287","121063","11299","121064","11291","121065","11278","121066","11285","121067","11277","101607","121269","121068","20645","121069","11283","121070","11276","121227","121071","11290",
        "121072","11288","121073","11292","121074","21703","11309","10235","11344","11345","11346","113197","113198","10239","11372","20753","21155","113186","113194","100140","100926","117558","100141","100142","100927","117917","120405","100143","100987","117559","117936","117944","118094","118286","120167","100144","100988","100145","100146","21822","120139","100147","100989","117918","100148","100990","100149","20692","117560","100150","100991",
        "117857","119987","120290","100151","101753","117071","100152","100992","117561","100153","100993","117562","100154","20089","100155","100994","120230","100156","100995","117643","100157","100158","100996","100159","11308","20643","120140","100160","100997","110936","100161","100998","100162","29772","100999","100163","101000","100164","100165","101001","101493","100166","118418","120062","100167","101002","118287","119010","100168","101003","100169",
        "101004","100170","101005","100171","20087","118185","119839","120262","100172","101006","117072","117563","100173","100510","100174","101007","118816","100175","101008","100176","11305","11313","119862","100177","101009","117564","100178","20092","120168","100179","20093","100180","117863","100181","101010","117937","121040","114844","121042","110937","121043","62","108196","108197","108200","108201","108202","108203","108204","121044","11311",
        "11306","11312","121277","113199","121045","11302","121046","11310","121047","20088","121048","20086","121049","20091","121050","11307","121051","20090","121052","20094","121267","121053","20085","121055","20670","121056","11304","121057","20084","121058","11303","11316","100182","100928","118596","100183","20098","102035","100184","20099","100185","100929","100186","100930","100187","100931","100188","102036","118640","118887","100189",
        "20101","100190","20102","100191","100932","117621","100192","100933","118613","100193","100934","100194","100935","119819","100195","20103","102037","100196","20104","100197","100936","100198","100937","100199","100938","117237","117735","119973","100200","11315","117250","117524","117622","117699","118464","118486","118516","118597","118756","118888","118930","119195","119706","119820","120197","120229","120471","120527","100201","100939","100202",
        "100940","100203","21130","100204","20105","102038","100205","20106","117736","100206","100941","100207","100942","100208","102079","100209","20107","117850","100210","100491","119821","100211","20108","121035","20100","121036","110935","121037","65","102057","102058","102069","102070","102076","102077","102059","102060","102071","102072","102061","102073","102074","102062","102063","102064","102067","102068","102065","102075","102066","102078",
        "116401","121038","11314","121039","11317","11318","100212","100954","100213","100955","118476","119773","100214","100956","100215","100957","100216","100958","100217","20109","117185","100218","20110","100219","100959","100220","100960","100221","100961","118477","100222","100962","118478","100223","100963","100224","100964","118672","118984","100225","100965","100226","20111","119774","100227","100966","100228","100967","110310","118479","100229",
        "100968","100230","100969","100231","117749","117860","118184","118438","118673","118919","119209","119637","119693","119775","120208","120284","100232","100970","100233","100971","100234","100972","100235","100973","100236","100974","100237","100975","100238","20112","100239","100520","100240","20113","100241","21158","118439","100242","100976","100243","100977","118440","121084","66","108138","108141","108145","108149","108152","11330","100244",
        "21161","30636","100245","101014","101384","101803","101804","100246","101015","100247","101016","101776","100248","101017","100249","101018","101724","119191","119380","100250","20081","100251","101019","120008","120095","120337","100252","11328","30729","30822","115626","117625","100253","101020","100254","30547","100255","20082","100256","101021","101484","100257","101022","101556","100258","101023","100259","30731","30732","101024","100260",
        "101748","101773","100261","11326","100262","101025","119042","100263","30806","98544","100264","101026","121100","198","121101","11327","11340","100265","101035","119603","100266","101036","101702","117311","117518","100267","101037","119186","100268","101038","117405","120383","100269","101039","100270","101040","119008","100271","29400","101777","118066","119716","100272","11343","113193","121102","1095","121103","11341","115662","121104",
        "11342","121256","121105","20083","121106","11339","11353","100273","11347","100274","20658","119844","100275","21672","100276","21674","100277","101041","100278","21675","21676","21709","118909","100279","101042","100280","11349","100281","101043","101765","100282","101784","100283","11350","101785","100284","98568","100285","21677","100286","21951","117324","118082","118300","118308","118375","118381","118910","120399","121364","100287",
        "21673","100288","101786","121096","11351","121097","67","121098","11352","121099","11348","21949","100415","100900","100416","100901","100417","30866","100418","11355","120434","100419","100902","100420","11356","117788","100421","11362","101479","115627","100422","100903","100423","11357","101642","117196","120265","100424","11358","100425","100904","100426","100905","100427","11360","117773","118306","118509","100428","11361","101691",
        "100429","100906","117737","100430","11363","120531","120535","100431","100907","100432","117239","118722","119211","100433","11365","100434","11366","118330","100435","100908","100436","100909","117525","100437","11367","121266","100438","11368","117229","100439","11369","117105","117967","100440","116277","117197","117520","117834","117978","118032","119133","119946","100441","100910","100442","11371","119457","102435","115047","119210","120837",
        "116735","113190","121276","116736","113196","120838","11233","120839","68","120840","102436","120841","11364","73","10243","98682","101845","117460","119681","98683","101273","117226","98684","11394","100981","101486","103559","98685","101274","98686","101275","119023","119635","121187","11393","10251","98691","11461","101310","98692","11459","98693","21034","101311","98694","101312","98695","11460","98696","11462","101836",
        "121189","11458","11375","100289","11373","100290","101840","117557","119639","100291","101841","100292","11376","20242","101839","100293","11378","100294","21186","100295","11380","100296","11381","100297","11382","120240","100298","11383","21039","100299","11384","100300","11377","100301","11386","100302","101842","100303","101272","101583","100304","11388","100305","11389","21501","21699","100306","11390","100307","101844","100308",
        "101843","121173","77","121174","100452","121175","114764","121176","11374","121177","11391","121178","11379","121179","11387","121180","11385","121181","11392","11398","100309","11397","100310","101276","100311","11396","101549","117624","118387","119020","119560","119845","120169","100312","101277","100313","21120","100314","101280","100315","11399","113200","100453","11401","100454","101545","101849","100455","11402","101279","100456",
        "101278","121183","11400","121184","78","121186","11395","11403","100316","21026","101282","100317","101283","101797","101798","101799","101801","100318","21116","100319","11404","100320","20883","101284","100321","101285","100322","101286","100458","101281","101800","101802","121188","79","101847","11409","100323","101287","100325","101866","117696","100326","11413","100327","11415","101740","117079","100328","11420","113192","100329",
        "101288","119969","100331","11418","119021","119255","100332","11410","117794","119261","120127","100333","11423","117644","118637","100334","101289","118841","100335","11408","101594","117697","117907","118081","119022","119898","120251","100336","11422","119899","100337","11417","100338","101870","117879","100339","21140","101599","100341","11414","117193","100342","11424","11427","118025","118410","100343","11428","120529","100344","11429",
        "101746","100345","11430","118842","100346","101290","101752","120449","100347","11431","119244","116888","974","101869","121306","116889","11426","101871","121263","121275","121295","116890","11406","121248","121293","116891","11411","101848","116892","11405","116893","11407","116894","11416","101868","116895","100459","101867","116896","11421","120833","75","120836","121299","120834","11425","120835","11412","11443","100348","101291",
        "100349","11432","20270","31005","100350","11441","29290","100351","101292","100352","101293","100353","11440","100354","101294","100355","101295","100356","11433","114763","100357","11434","100358","11442","101296","100359","21497","100360","101297","100361","11435","20276","100362","101298","113201","100363","11436","24321","105434","100364","101300","100365","101301","100366","20822","100367","20614","101989","100368","11438","101637",
        "100369","24944","101684","118763","100370","11439","100371","25206","100372","21135","100373","101302","100374","101303","113202","100375","101304","100376","101305","113205","100377","101306","100378","20615","101990","100379","101308","100380","101309","101987","11437","101988","117302","119907","121171","114762","121172","74","11450","100381","11444","101991","100382","20158","121298","100383","20159","101992","121291","121292","100384",
        "11445","101993","100385","11446","110278","100386","20598","100387","20160","101994","100388","20267","100389","11447","101995","100390","20161","101996","100391","11448","100392","32090","100393","20162","100394","32071","100395","20163","32087","100396","20164","101997","100397","11449","121182","80","11457","100398","11451","100948","100399","101313","115048","100400","20165","118609","100401","11452","118918","119315","100402",
        "100914","114806","100403","20166","100404","101958","117345","117642","119273","119316","119557","119863","119951","120352","100405","101314","100406","11454","101960","100407","11455","100408","11456","101959","117985","100409","101315","117301","117712","119952","120353","100410","101316","100411","101317","101689","100412","121229","121230","121231","121232","121233","121234","121235","121236","121237","121238","121239","121240","121241","121242",
        "121243","121244","121245","121246","100413","101318","121289","121301","100414","101319","121169","76","121170","11453","102444","11010","99310","100587","99311","100588","99312","100589","99313","100590","99314","100591","120098","99315","100592","99316","101811","99317","100593","99318","100594","99319","100595","99320","100596","99321","101819","118741","99322","100597","99323","100598","118590","99324","100599","99325","21520",
        "117090","118592","99326","100600","101820","99327","101815","116406","99328","101816","99329","100601","99330","100602","99331","100603","99332","100604","99333","100605","101557","99334","100606","99335","100607","99336","101821","118591","99337","100609","99338","100610","99339","100611","99340","100612","99341","100613","99342","100614","99343","100615","99344","101818","99345","100616","99346","100617","99347","100619","99348",
        "100620","99349","100621","99350","100622","121199","28","101817","121200","11007","121201","11009","101813","121202","21521","101812","121203","11011","121204","11006","121205","11008","121206","21732","121207","21519","101814","121208","100450","11012","99351","21522","99352","101822","99353","101823","99354","21702","121216","1092","121217","20180","121218","20181","121219","20179","11013","99355","101825","117195","118052",
        "118197","119680","99356","100585","119838","99357","100586","99358","20172","99359","101824","119214","119653","119975","99360","20175","99361","20173","117654","120054","120401","99362","21524","118055","118253","118966","120374","120412","120522","99363","21523","117200","99364","11014","20176","21525","121209","30","121253","121210","20174","121211","20171","11020","99378","100644","99379","21529","100645","119007","120066",
        "99380","37117","118538","119142","119628","99381","100646","99382","100647","117859","120366","99383","100648","99384","11019","119132","99385","100649","101787","101788","119679","101789","101790","117094","118157","120476","121212","1104","121213","11016","11017","11018","11021","99386","20591","118275","99387","20665","99388","20622","99389","21530","99390","100575","99391","11022","99392","11023","119371","99393","100576",
        "101634","118228","118882","121198","33","101826","11024","99394","21532","99395","21531","99396","101832","119640","99397","11026","101833","99398","100549","99399","100550","99400","100552","99401","100553","99402","100554","99403","100555","99404","20699","101834","99405","20690","101835","99406","20698","99407","100556","121214","1106","121215","11025","11069","99451","20238","104109","99452","101410","118218","119989",
        "99453","20239","118749","99454","101411","99455","11054","120020","99456","11055","101829","118194","119609","119629","119632","120041","99457","101830","117121","117652","118687","118983","119266","119287","120260","120421","99458","101412","118512","120047","99459","11060","101728","118925","119765","119797","120045","99460","11061","99461","11066","101717","117733","118346","99462","101413","117248","117653","117984","118128","119700",
        "120199","99463","101414","101687","119614","119630","120448","99464","101415","118825","99465","101416","119475","99466","11063","101831","117416","117753","117996","118078","118259","118474","118577","118770","118826","119246","119476","119652","120261","99467","20655","99468","11065","117760","118434","119477","99469","20240","99470","11068","118368","119387","120422","99471","101417","101732","118827","118980","119139","119598","119696",
        "119832","120090","120534","99472","11059","101731","117747","119974","99473","20241","101394","99474","101418","99475","20232","99476","101271","117515","117632","117877","118219","118956","119198","119450","120162","121190","36","121191","11067","121249","121265","121274","121288","121192","11057","121193","11064","121194","11062","121257","121195","11056","121196","20261","121197","11058","109767","115092","977","959","26995",
        "27012","27032","27050","104127","24696","27121","27217","27519","28179","28227","28314","28319","28515","28544","28587","28913","29270","116178","117533","24697","27085","27161","27395","27452","27729","27733","27910","28088","28696","29271","24698","27580","27776","27831","28049","28264","28389","28409","28516","28783","28838","28961","118498","118707","119933","24699","27281","27706","27753","28374","28656",
        "28813","29002","29273","117975","119492","24700","27322","27699","28177","28194","28342","28390","28500","29272","118771","24701","27320","28059","28671","24702","27219","27292","27373","27423","27777","27802","27826","27974","27999","28060","28195","28702","28786","29269","29275","29277","29278","101660","24703","27229","27282","27882","28169","28229","28315","28588","28657","120325","24704","27293","27652",
        "27674","28196","28200","28255","28675","28735","29019","120326","24705","27111","28116","28357","28447","28981","119934","24706","27313","27333","27683","28371","28375","28982","29012","29274","114813","118616","120327","24707","27509","27952","27976","28270","28540","28676","103561","117536","118906","119493","119563","120320","120403","24708","28197","28391","28541","28954","29276","24709","27394","27707","27778",
        "27914","28198","28201","114845","114679","11470","26991","26999","27013","27031","27033","27037","27047","27054","27055","27061","27070","98573","98574","114666","114846","116765","11469","26990","27008","27010","27030","27039","116394","116766","11471","27019","27020","27038","27040","27048","27051","114847","116177","116584","116767","11472","27016","27028","121220","146","27064","27065","29268","121221","11464",
        "121222","11463","27005","27018","27024","121223","27693","121224","27555","121225","20556","121226","28892"}

    #http://g.ararat-lucid.dev.yandex.ru/?fields=Id&types=1,2,3,4,5,6,7,8,9,10,11,12,13&root=983
    regionsTR = {"983","103668","103851","106044","106045","104674","104707","106474","106475","116020","116021","116022","106040","103669","11501","104688","104697","104713","106477","107784","115735","115736","115737","115738","115739","115740","115741","115742","115743","114547","115744","103670","103893","104694","104722","108048",
        "108049","116023","116024","116025","116026","103671","20889","106133","107945","103845","107944","104661","106061","104679","106014","106250","106480","107939","107940","107943","107941","107947","107948","107949","115910","115911","115912","115913","107950","115914","103672","103834","106197","107847","104675","107846","115805","115806","115807","115808","103673","103852","104742","104751","108050","108051","106050","116027","116028","103674","11503",
        "104668","106172","104673","106485","104770","106147","104775","104782","106260","106261","106321","106263","106482","106483","106484","106262","106486","106058","107762","115676","115677","115678","115679","115680","115681","115682","115683","115684","115685","115686","115687","104734","103675","11502","17308","17309","101061","11511","17303","17305","17306","17307","21031","106055","21091","17304","104667","21062","104685","107765","107769",
        "107770","107772","107773","115727","115728","115729","115730","106053","115731","115732","115733","115734","116363","103676","103853","108015","106156","115968","115969","115970","115971","103677","103854","106013","108052","108055","116029","116030","116031","116032","106059","103678","103855","104670","104708","104714","104719","106004","108017","108018","108019","115972","115973","115974","106038","115975","115976","115977","115978","115979","106039",
        "115980","103679","103858","106100","106101","116033","116034","103680","103829","104705","106011","107900","107901","104715","104724","107903","107905","104763","104777","106015","106017","106051","106063","106065","107898","107899","107902","107904","107906","115880","115881","106064","115882","115883","106060","106062","115884","103681","103859","106158","106160","115924","115925","103682","103827","106287","107848","107849","115809","106289","106290",
        "106291","114549","115810","106288","103683","103860","106068","104717","108020","108022","115981","115982","115983","115984","103684","103847","106018","108056","116035","116036","116037","116038","116039","103685","103844","104655","104733","108023","108024","108026","115985","103686","17070","108057","106162","108058","116040","116041","106070","116042","104780","116043","116044","116045","116387","103687","103849","106074","107964","107965","115926",
        "115927","115928","115929","115930","115931","115932","115933","103688","11504","17117","104747","104754","104759","104760","106078","107779","104765","106020","106075","106076","107777","107778","115751","115752","115753","115754","115755","106077","115756","115757","115758","103689","103861","107966","104703","107968","107969","107971","107972","107975","115934","115935","106254","115936","106256","106257","115937","106255","115938","103690","103825",
        "104678","106312","107800","107802","107801","115764","115765","106310","106313","115766","106311","115767","106315","115768","115769","103691","103862","104744","104762","104773","107976","107978","107980","107981","107983","107985","115939","115940","115941","115942","115943","115944","103692","103863","106230","108060","108061","116046","116047","116048","103693","103842","106021","106082","107929","107931","107932","107933","107935","107936","107937",
        "107938","115900","115901","115902","115903","115904","115905","115906","115907","115908","115909","103694","103828","104664","106084","104700","106092","106094","104720","106083","106085","106087","106089","106091","106093","106096","106088","107840","107841","107842","106090","107843","106086","107844","107845","115801","115802","115803","115804","103695","103864","108062","108065","108066","108067","116049","116050","116051","103696","103850","107986",
        "107987","107990","104768","107992","106019","106069","107988","107989","107991","103697","11505","20851","107781","104650","104652","104653","106129","104676","106130","106131","106135","106138","104683","106142","104692","104723","106136","106141","106155","104726","106139","106140","106132","107763","107764","107782","106134","106143","115711","115712","115713","115714","115715","106137","115716","115717","115718","115719","115720","106144","115721",
        "115722","115723","115724","115725","115726","116275","116356","103698","103824","104646","104659","107793","106259","107794","107795","107796","107797","107798","107799","115760","115761","115762","106258","115763","103699","103831","106164","104657","104709","106166","107878","107879","106163","107880","107882","107883","115832","115833","115834","115835","106169","115836","106167","115837","115838","115839","103700","103865","104745","108068","116052",
        "116053","116054","106153","103701","103848","107993","115945","106052","115946","115947","115948","103702","103886","106023","106042","106046","106048","106047","108027","115986","115987","115988","106043","106049","115989","103703","103887","106146","106149","106157","106145","107924","106161","107928","115885","115886","115887","115888","106148","106150","115889","115890","106159","115891","115892","115893","115894","115895","115896","115897","115898",
        "115899","103704","103888","104699","104704","106190","104732","106189","108070","106191","108075","108071","108073","108072","108074","116055","116056","103705","103889","106317","115990","115991","115992","103706","101515","103841","106173","104736","104758","104764","106022","107780","107789","107790","107791","107792","115759","103707","101474","104666","106054","104686","106212","104693","104701","104710","104728","106033","106028","107814","107815",
        "107820","107816","107817","106265","107818","106057","107821","115773","115774","115775","115776","115777","115778","115779","115780","115781","115782","106056","115783","115784","106029","115785","106003","115786","115787","115788","115789","115790","103708","103890","104752","106171","108077","108079","116057","106170","116058","116059","103709","103891","108080","108081","106196","108082","108083","108084","116060","103710","103892","104691","108028",
        "115993","115994","115995","115996","115997","115998","103711","103839","106174","104654","107884","104663","106175","106176","115851","115852","115853","115854","115855","115856","115857","115858","103712","103885","106178","108034","108029","106177","108030","108031","106180","108033","108036","108032","108037","115999","116000","116001","116002","116003","116004","106179","116005","103713","103837","104651","104660","107869","104671","106187","106188",
        "104687","106183","104727","104729","106185","106186","107864","106182","107865","107866","107867","107868","107870","115817","115818","115819","106181","103714","103884","108090","104645","106269","104677","106271","106280","104682","106273","106275","106277","108089","104689","106274","106281","108085","108086","106279","108088","106267","106268","108091","106278","116061","106270","106276","103715","21032","106025","106481","107785","107788","103823",
        "104656","106027","106117","107787","104680","104702","107775","107776","104725","107774","106026","107786","115745","115746","115747","115748","115749","115750","103716","20971","107833","116393","21178","107829","107836","107839","21257","21509","21445","103832","104681","106012","17294","107830","106192","107835","107837","115799","115800","116276","116358","116591","103717","103883","104716","106193","106194","108092","108093","116062","103718",
        "103840","106198","106478","108039","108040","106195","108041","116006","116007","103719","103882","104718","108043","106118","116008","116009","116010","103720","103881","104739","104753","104766","106199","108094","108095","108096","106200","108097","108098","106203","108099","116063","116064","116065","116066","116067","116068","116069","106202","116070","103721","103880","104695","106309","108101","108102","116071","116072","103722","103879","106204",
        "104779","106205","107895","107896","115873","115874","115875","115876","115877","115878","115879","103723","103843","104757","104761","106206","107951","107952","107953","115915","115916","115917","115918","115919","115920","115921","115922","115923","103724","103833","104772","104778","106072","107819","107885","107886","106208","107887","107889","107890","107891","115859","115860","115861","115862","115863","115864","115865","103725","103838","106215",
        "107994","107995","107996","107997","107998","108000","106165","106213","108001","106214","115949","115950","115951","115952","115953","115954","115955","115956","115957","103726","103878","106282","106284","106285","104684","106283","108002","115958","115959","115960","106286","115961","103727","11507","106209","106211","108103","108104","108105","116073","116074","116075","116076","103728","11508","104743","104767","106119","106120","106122","106124",
        "106125","106126","106127","106128","106121","107755","107756","107757","104756","107758","104750","107759","107760","115688","115689","115690","115691","115692","115693","115694","115695","115696","115697","115698","115699","115700","115701","115702","115703","115704","115705","115706","115707","115708","106037","115709","115710","103729","21033","106221","103836","106223","104771","107954","107961","107955","106217","106222","107956","107957","106218",
        "106220","107958","107959","106216","107962","107963","103730","103877","106225","104735","106224","106227","104740","104749","106228","104769","106226","108044","116011","116012","116013","116014","116015","103731","103830","107851","104737","104748","104776","104781","107858","107850","106229","107853","107854","107857","107860","106232","107861","107863","115811","115812","115813","115814","115815","115816","103732","103876","108106","108107","116077",
        "116078","106233","116079","116080","116081","103733","103875","106253","108108","116082","116083","116084","103734","103874","104644","108109","108110","106264","103735","101657","107807","107809","104672","104690","104696","107810","104706","107804","107812","106024","107803","107805","107813","107811","115770","106115","115771","115772","106116","103736","103873","108011","104774","108004","108006","108007","106079","108009","108010","108012","115962",
        "115963","115964","115965","106210","103737","103872","106154","106151","108111","108112","116085","116086","116087","116088","116089","116090","116091","116092","103738","103871","106080","104741","104746","108113","108114","106081","108115","116093","116094","116095","116096","116097","116098","116099","116100","103739","103870","106235","106244","106247","106248","108116","104648","106241","104658","106245","106246","106252","104662","106234","106237",
        "106243","106249","104712","106238","104721","104730","106236","106240","106242","106239","108117","116101","106251","116102","103740","103869","104665","106293","104711","106294","106295","106297","106298","106300","106301","106302","108013","106296","106304","106306","106308","108014","106299","115966","106292","115967","103741","103868","108118","116103","106316","116104","103742","103846","104647","106031","104669","107892","107893","106030","107894",
        "115866","106036","115867","115868","115869","115870","115871","106035","115872","103743","11509","106097","104738","104755","106098","108046","108045","108047","116016","106099","116017","116018","116019","103744","103826","107826","107828","107822","107824","107825","115792","115793","115794","115795","115796","115797","115798","103745","103867","104649","116105","116106","116107","116108","116109","116110","116111","103746","11510","106106","104698",
        "107872","106107","107874","106103","107875","107876","107877","115820","115821","106104","115822","106111","106112","115823","106102","115824","115825","106105","115826","106110","115827","106109","115828","106108","115829","115830","115831","116370","103747","103835","106487","106488","106489","115840","115841","115842","115843","106113","115844","115845","106067","115846","115847","106066","115848","106114","115849","115850","103748","103866","106318",
        "108119","108120","106123","106319","106320","108121","116112","116113"}

    MapReduce.useDefaults(server='sakura', verbose=True, mrExec="mapreduce-dev")

    run_MR(aStart = start, aEnd = end, aName = "spy_log", aRL = regionsRU) #'spy_log', 'similargroup', 'shinypages'
    run_MR(aStart = start, aEnd = end, aName = "similargroup", aRL = regionsRU) #'spy_log', 'similargroup', 'shinypages'
    run_MR(aStart = start, aEnd = end, aName = "shinypages", aRL = regionsRU) #'spy_log', 'similargroup', 'shinypages'
    run_MR(aStart = start, aEnd = end, aName = "spy_log", aRL = regionsTR) #'spy_log', 'similargroup', 'shinypages'
    run_MR(aStart = start, aEnd = end, aName = "similargroup", aRL = regionsTR) #'spy_log', 'similargroup', 'shinypages'
    run_MR(aStart = start, aEnd = end, aName = "shinypages", aRL = regionsTR) #'spy_log', 'similargroup', 'shinypages'


if __name__ == '__main__':
    main()
