📦 AAB-release (релизы анти Адблока)
========================

В этом репозитории (папка dist) лежат собранные антиадблочне файлы. Их исходники, а так же частичное описание лежат вот здесь: https://github.yandex-team.ru/any/common/tree/master/ts/adblock.

### Описание файлов:

- `detect.common.min.js` — Детектор адблока в формате commonjs. экспортирует функцию detect, которая принимает единственным параметром callback. Коллбек вызовется, когда будет определён тип блокировщика или то, что никакой блокировщик на странице не используется. В коллбек будет передан объект с двумя полями: `blocked` - булевая переменная, устанавливается в true, если обнаружен блокировщик, и blocker - строка-идентификатор полученного блокировщика.

- `detect.global.min.js` — Детектор адблока, экспортирует функцию `detect`, от предыдущего отличается тем, что экспортирует функцию в глобальную область видимости.

- `detect.global.no.bots.min.js` — Детектор адблока, экспортирует функцию `detect` в глобальную область видимости, не производит проверку на поисковых ботов.   

- `lib.server.min.js` — Общая библиотека методов, в формате commonjs. Требует замены части переменных при помощи прокси. Содержит в себе методы:
  
  - `encode` — Функция кодирования урлов. Принимает на вход строку - урл, который надо закодировать. Возвращает закодированный урл.
  - `decode` — Функция раскодирования урлов. Принимает на вход строку - урл, который надо раскодировать. Возвращает раскодированный урл.
  - `isEncoded` — Функция проверки, является ли строка закодированной при помощи прокси или функции `encode`. На вход принимает строку, возвращает `true` или `false`.
  - `encodeCSS` — Функция кодирования css-классов. Кодирование данным способом является необратимым. 

- `loader.min.js` — Загрузчик клиентской библиотеки. Параметры описаны в файле `src/src.md`. Подгружает `lib.browser.min.js`, если не получается сделать это и время попытки загрузки меньше секунды, то вызывает коллбек, в котором говорит, что находится под адблоком. После загрузки библиотеки вызывает метод `init`, который на данный момент вызывает только детект адблока.

- `lib.browser.min.js` —  Браузерная версия библиотеки. Экспортирует в переданный контекст метод `init`. Этот метод автоматически вызывается загрузчиком. 

### CommonJS и обычный js.
 - CommonJS – система модулей, изначально встроенная в сервер Node.JS. Для поддержки на клиентской стороне необходимо наличие сборщика (grunt, gulp, webpack) у партнёра. 
 Модуль экспортирует наружу функцию detect. Пример использования:
 ```javascript
var detect = require('path_to_detect/detect');
detect(function(result) {console.log(result)});
```
 
 - Версия с экспортом переменной в глобальную область видимости не требует никаких сборщиков. Достаточно подключить файл на страницу и тогда в глобальной области видимости появится функция detect.
 
### Релизы 
Версионирование ведется по спецификации SemVer. Подробное описание релизного процесса можно найти на [вики](https://wiki.yandex-team.ru/antiadb/Reliz-skripta-detekta/).

### Параметры загрузчика.
* `src` - ***обязательный параметр***. Принимает на вход url, который необходимо загрузить.
* `cookie` - имя куки, которую необходимо установить, если загрузчик или библиотека обнаружила наличие адблока. Имеет значение по умолчанию (`bltsr`).
* `time` - время на которое будет проставлена кука, в часах. Значение по умолчанию - 2 недели.
* `context` - ссылка на переменную, куда будет записан библиотечный код. Следует передавать только в том случае, если есть необходимость использовать методы библиотеки напрямую. В большинстве случаев такой необходимости нет.
* `callback` - функция, которая будет вызвана в том случае, если бибилиотека обнаружила наличие или отсутствие блокировщика. Время обнаружения блокировщика рекламы может быть длительным (но не блокирующим основной поток работы браузера), поскольку часть блокировщиков начинают работать не сразу или блокирует только определённые ресурсы.

##### Пример вызова загрузчика.
Изменения вносятся в самом конце файла, вот тут:
```javascript
(window,document,{src:""});
```

Подлючение клиентской библиотеки:
```javascript
var test = {};

...
(window,document,{
    src: "https://static-mon.yandex.net/static/main.js?pid=<PARTNER-ID>",
    cookie: "",
    time: 24,
    context: test,
    callback: function (result) { ... }
});
```

