export const SCHEMA = [
    {
        group_name: 'TESTGROUP',
        title: 'testgroup-title',
        hint: 'testgroup-hint',
        items: [
            {
                key: {
                    default: [],
                    name: 'ACCEL_REDIRECT_URL_RE',
                    type_schema: {
                        children: {
                            placeholder: 'regexp-placeholder',
                            type: 'regexp'
                        },
                        hint: 'accel-redirect-url-re-hint',
                        title: 'accel-redirect-url-re-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: true,
                    name: 'ADB_ENABLED',
                    type_schema: {
                        hint: 'adb-enabled-hint',
                        placeholder: {
                            placeholder_off: 'adb-enabled-off-placeholder',
                            placeholder_on: 'adb-enabled-on-placeholder'
                        },
                        title: 'adb-enabled-title',
                        type: 'bool'
                    }
                }
            },
            {
                key: {
                    default: false,
                    name: 'ADFOX_DEBUG',
                    type_schema: {
                        hint: 'adfox-debug-hint',
                        placeholder: {
                            placeholder_off: 'adfox-debug-off-placeholder',
                            placeholder_on: 'adfox-debug-on-placeholder'
                        },
                        title: 'adfox-debug-title',
                        type: 'bool'
                    }
                }
            },
            {
                key: {
                    default: [],
                    name: 'CLASSES_FOR_REPLACE',
                    type_schema: {
                        children: {
                            placeholder: 'classes-for-replace-placeholder',
                            type: 'string'
                        },
                        hint: 'classes-for-replace-hint',
                        title: 'classes-for-replace-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: [],
                    name: 'CLIENT_REDIRECT_URL_RE',
                    type_schema: {
                        children: {
                            placeholder: 'regexp-placeholder',
                            type: 'regexp'
                        },
                        hint: 'client-redirect-url-re-hint',
                        title: 'client-redirect-url-re-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: 'https://statchecker.yandex.ru/mapuid/',
                    name: 'CM_IMAGE_URL',
                    type_schema: {
                        hint: 'cm-image-url-hint',
                        placeholder: 'link-placeholder',
                        title: 'cm-image-url-title',
                        type: 'string'
                    }
                }
            },
            {
                key: {
                    default: '//an.yandex.ru/mapuid/',
                    name: 'CM_REDIRECT_URL',
                    type_schema: {
                        hint: 'cm-redirect-url-hint',
                        placeholder: 'link-placeholder',
                        title: 'cm-redirect-url-title',
                        type: 'string'
                    }
                }
            },
            {
                key: {
                    default: 3,
                    name: 'CM_TYPE',
                    type_schema: {
                        hint: 'cm-type-hint',
                        placeholder: 'cm-type-placeholder',
                        title: 'cm-type-title',
                        type: 'select',
                        values: {
                            'cookiematching-disabled-placeholder': 0,
                            'cookiematching-image-or-refresh-placeholder': 3,
                            'cookiematching-image-placeholder': 1,
                            'cookiematching-refresh-placeholder': 2
                        }
                    }
                }
            },
            {
                key: {
                    default: null,
                    name: 'CRYPTED_HOST',
                    type_schema: {
                        hint: 'crypted-host-hint',
                        placeholder: 'crypted-host-placeholder',
                        title: 'crypted-host-title',
                        type: 'string'
                    }
                }
            },
            {
                key: {
                    default: false,
                    name: 'CRYPTED_URL_LENGTH_PREFIX',
                    type_schema: {
                        hint: 'crypted-url-length-prefix-hint',
                        placeholder: {
                            placeholder_off: 'crypted-url-length-prefix-off-placeholder',
                            placeholder_on: 'crypted-url-length-prefix-on-placeholder'
                        },
                        title: 'crypted-url-length-prefix-title',
                        type: 'bool'
                    }
                }
            },
            {
                key: {
                    default: {},
                    name: 'CRYPT_BODY_RE',
                    type_schema: {
                        hint: {
                            crypt_hint: 'crypt-body-re-crypt-hint',
                            substitute_hint: 'crypt-body-re-substitute-hint'
                        },
                        placeholder: {
                            crypt_placeholder: 'regexp-placeholder',
                            replaceable_placeholder: 'regexp-placeholder',
                            substitute_placeholder: 'crypt-body-re-substitute-placeholder'
                        },
                        title: {
                            crypt_title: 'crypt-body-re-crypt-title',
                            substitute_title: 'crypt-body-re-substitute-title'
                        },
                        type: 'crypt_body'
                    }
                }
            },
            {
                key: {
                    default: false,
                    name: 'CRYPT_ENABLE_TRAILING_SLASH',
                    type_schema: {
                        hint: 'crypt-enable-trailing-slash-hint',
                        placeholder: {
                            placeholder_off: 'crypt-enable-trailing-slash-off-placeholder',
                            placeholder_on: 'crypt-enable-trailing-slash-on-placeholder'
                        },
                        title: 'crypt-enable-trailing-slash-title',
                        type: 'bool'
                    }
                }
            },
            {
                key: {
                    default: [],
                    name: 'CRYPT_RELATIVE_URL_RE',
                    type_schema: {
                        children: {
                            placeholder: 'regexp-placeholder',
                            type: 'string'
                        },
                        hint: 'crypt-relative-url-re-hint',
                        title: 'crypt-relative-url-re-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: null,
                    name: 'CRYPT_SECRET_KEY',
                    required: true,
                    type_schema: {
                        hint: 'crypt-secret-key-hint',
                        placeholder: 'crypt-secret-key-placeholder',
                        title: 'crypt-secret-key-title',
                        type: 'string'
                    }
                }
            },
            {
                key: {
                    default: '/',
                    name: 'CRYPT_URL_PREFFIX',
                    type_schema: {
                        hint: 'crypt-url-preffix-hint',
                        placeholder: 'crypt-url-preffix-placeholder',
                        title: 'crypt-url-preffix-title',
                        type: 'string'
                    }
                }
            },
            {
                key: {
                    default: [],
                    name: 'CRYPT_URL_RE',
                    required: true,
                    type_schema: {
                        children: {
                            placeholder: 'regexp-placeholder',
                            type: 'regexp'
                        },
                        hint: 'crypt-url-re-hint',
                        title: 'crypt-url-re-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: [],
                    name: 'DETECT_COOKIE_DOMAINS',
                    type_schema: {
                        children: {
                            placeholder: 'detect-cookie-domains-placeholder',
                            type: 'string'
                        },
                        hint: 'detect-cookie-domains-hint',
                        title: 'detect-cookie-domains-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: 0,
                    name: 'DETECT_COOKIE_TYPE',
                    type_schema: {
                        hint: 'detect-cookie-type-hint',
                        placeholder: 'detect-cookie-type-placeholder',
                        title: 'detect-cookie-type-title',
                        type: 'select',
                        values: {
                            'detect-cookie-type-children-placeholder': 1,
                            'detect-cookie-type-current-placeholder': 0,
                            'detect-cookie-type-list-placeholder': 2
                        }
                    }
                }
            },
            {
                key: {
                    default: [],
                    name: 'DETECT_HTML',
                    type_schema: {
                        children: {
                            placeholder: 'detect-html-placeholder',
                            type: 'detect_html'
                        },
                        hint: 'detect-html-hint',
                        title: 'detect-html-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: [],
                    name: 'DETECT_LINKS',
                    type_schema: {
                        children: {
                            placeholder: 'link-placeholder',
                            type: 'link'
                        },
                        hint: 'detect-links-hint',
                        title: 'detect-links-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: [0],
                    name: 'ENCRYPTION_STEPS',
                    required: true,
                    type_schema: {
                        hint: 'encryption-steps-hint',
                        placeholder: 'encryption-steps-placeholder',
                        title: 'encryption-steps-title',
                        type: 'multi_select',
                        values: {
                            'encryption-steps-advertising-crypt-placeholder': 1,
                            'encryption-steps-partner-content-class-crypt-placeholder': 3,
                            'encryption-steps-partner-content-url-crypt-placeholder': 2,
                            'encryption-steps-pcode-replace-placeholder': 0,
                            'encryption-steps-tags-crypt-placeholder': 4
                        }
                    }
                }
            },
            {
                key: {
                    default: ['bltsr'],
                    name: 'EXCLUDE_COOKIE_FORWARD',
                    type_schema: {
                        children: {
                            placeholder: 'exclude-cookie-forward-placeholder',
                            type: 'string'
                        },
                        hint: 'exclude-cookie-forward-hint',
                        title: 'exclude-cookie-forward-title',
                        type: 'tags'
                    }
                }
            },
            {
                key: {
                    default: ['addruid'],
                    name: 'EXTUID_COOKIE_NAMES',
                    type_schema: {
                        children: {
                            placeholder: 'extuid-cookie-names-placeholder',
                            type: 'string'
                        },
                        hint: 'extuid-cookie-names-hint',
                        title: 'extuid-cookie-names-title',
                        type: 'tags'
                    }
                }
            },
            {
                key: {
                    default: null,
                    name: 'EXTUID_TAG',
                    required: true,
                    type_schema: {
                        hint: 'extuid-tag-hint',
                        placeholder: 'extuid-tag-placeholder',
                        title: 'extuid-tag-title',
                        type: 'string'
                    }
                }
            },
            {
                key: {
                    default: [],
                    name: 'FOLLOW_REDIRECT_URL_RE',
                    type_schema: {
                        children: {
                            placeholder: 'regexp-placeholder',
                            type: 'regexp'
                        },
                        hint: 'follow-redirect-url-re-hint',
                        title: 'follow-redirect-url-re-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: {},
                    name: 'HOSTNAME_MAPPING',
                    type_schema: {
                        hint: 'hostname-mapping-hint',
                        key: 'string',
                        placeholder: {
                            key_placeholder: 'hostname-mapping-key-placeholder',
                            value_placeholder: 'hostname-mapping-value-placeholder'
                        },
                        title: 'hostname-mapping-title',
                        type: 'object',
                        value: 'string'
                    }
                }
            },
            {
                key: {
                    default: false,
                    name: 'INTERNAL',
                    type_schema: {
                        hint: 'internal-hint',
                        placeholder: {
                            placeholder_off: 'internal-off-placeholder',
                            placeholder_on: 'internal-on-placeholder'
                        },
                        title: 'internal-title',
                        type: 'bool'
                    }
                }
            },
            {
                key: {
                    default: [],
                    name: 'PARTNER_TOKENS',
                    required: true,
                    type_schema: {
                        children: {
                            placeholder: 'partner-tokens-placeholder',
                            type: 'string'
                        },
                        hint: 'partner-tokens-hint',
                        title: 'partner-tokens-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: [],
                    name: 'PROXY_URL_RE',
                    required: true,
                    type_schema: {
                        children: {
                            placeholder: 'regexp-placeholder',
                            type: 'regexp'
                        },
                        hint: 'proxy-url-re-hint',
                        title: 'proxy-url-re-title',
                        type: 'array'
                    }
                }
            },
            {
                key: {
                    default: null,
                    name: 'PUBLISHER_SECRET_KEY',
                    required: true,
                    type_schema: {
                        hint: 'publisher-secret-key-hint',
                        placeholder: 'publisher-secret-key-placeholder',
                        title: 'publisher-secret-key-title',
                        type: 'string'
                    }
                }
            },
            {
                key: {
                    default: null,
                    name: 'TEST_DATA',
                    type_schema: {
                        hint: {
                            invalid_hint: 'test-data-hint',
                            valid_hint: 'test-data-hint'
                        },
                        placeholder: {
                            invalid_placeholder: 'test-data-placeholder',
                            valid_placeholder: 'test-data-placeholder'
                        },
                        title: {
                            invalid_title: 'test-data-invalid-title',
                            valid_title: 'test-data-valid-title'
                        },
                        type: 'test_data'
                    }
                }
            }
        ]
    }
];
