# AntiAdblock Argus

На данный момент умеет:
- Снимать скриншоты с разными блокировщиками по списку сайтов
  - Браузеры: Yandex Browser, Chrome, Firefox
  - Блокировщики: Adguard, Adblock, Adblock+, Ublock Origin, без расширения
- загружать все артефакты проверки в s3 (используемый бакет - argus)
- на выходе выдавать result.json с полным профилем проверки(ссылки на скриншоты/расширения/листы)

Если запускается не в sandbox, то использует квоту [selenium](https://selenium.yandex-team.ru/#quota/selenium)

Для запуска внучную необходимо запустить `argus.py` с нужными аргументами

Ключи при запуске:
- `--help` - выдает полный список команд с возможными вариантами значений
- `--local_run` - локальный запуск, не будет загружать результаты в s3 бакет `argus`
- `--profile` - строка json со списком урлов для снятия скриншотов. Пример: ["https://yandex.ru"]

Пример: `argus.py --local_run --profile "[\"https://yandex.ru\",\"https://auto.ru\"]"` - сделает скриншоты сайтов yandex.ru и auto.ru под всеми возможными блокировщиками/браузерами

Так же часть ключей передаются через переменные среды:
- `S3_KEY_ID` - ключ для s3
- `S3_SECRET_KEY` - секретныцй ключ для доступа в s3
- `PROFILE` - аналог параметра `profile` из коммандной строки

Таска в [SandBox](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/antiadblock/aab_argus_screenshoter/__init__.py)


### Автоматическая сборка ARGUS 3.0

В папке `argus/bin/tools` выполняем команду:

`ya make && ./builder`

> Результат работы ./builder достаточно быстро протухает и ссылки на расширения становятся невалидными (404 ошибка)

В этой папке появятся конфигурационные файлы:
- `extensions.json` Ссылки для загрузки блокировщиков. Также пути до плагинов `modheader`
- `profile.json` Профиль для запуска Аргуса. Можно редактировать и настраивать.
- `browsers.json` Конфиг селеноида на котором будет запущен Аргус
- `settings.json` Настройки для Аргуса: `ARGUS_ENV=DEBUG` запускает сам браузер на компьютере, `VIDEO=ENABLE`
устанавливает timeout на соединение 5 min, включает `VNC` и записывает видео. Посмотреть можно через `selenoid-ui`

Затем создаём свой `.env`, используя `.env.example`. Можно ничего не менять.

И теперь заходим в `argus/bin` и запускаем Аргус:
```bash
ya make && ./argus
```
