### Authentification
Система прав представляет собой иерархическую систему
Сейчас есть всего два вида иерархических узлов:
- Корневой (ROOT) - уникальный узел, представлен в единственном экземпляре. Права с него распространяются на все сервисы
- Сервис - узел, представляющий сервис. Является дочерним для корневого. Права с него распространяются на определенный сервис

К узлам системы прав привязываются роли. Роль - это набор прав для определенного пользователя. Сейчас есть следующие роли:
- `admin` - все права
- `internal_user` - права создавать конфиги и катить на тест. Раздаем внутренним пользователям (в будущем через idm)
- `external_user` - права создавать конфиги и катить на тест. Раздаем внешним пользователям, подтвержденным через WM

Роли базовых узлов наследуются в дочерних.
Примеры:
1. Может ли пользователь Х выкатывать конфиги севриса auto_ru? При проверке прав нужны три сущности: пользователь, нода и проверяемое право. Сервисная нода для auto_ru выглядит как *#services#auto_ru. Мы выгружаем из базы все права пользователя для этой и родительских нод. Иными словами, надо проверить, есть ли право "config_active" в роли пользователя на какой-нибудь из нод  "*", "*#services", "*#services#auto_ru"
2. Из-за иерархичности нод, если пользователь глобальный админ (то есть у него к ноде "*" привязана роль "admin"), то  он сможет актививровать конфиг в любом сервисе. И нам не надо будет следить за тем, что если где-то добавился сервис, то нужно на него еще и разрешающие права выдать.

Если у пользователя есть проверенные домены в вебмастере, ему выдаются дополнительные права `external_user` на ноду *#services#{service_id_with_same_domain}

Все права сейчас выдаются на внешний аккаунт

В нашем api есть еще и обратная задача - по набору прав определить, какие сервисы показывать пользователю. Решаем так: 
- Если у пользователя на ноде *#services (родительской для всех сервисов) есть право service_see, то выгружаем все сервисы из базы и отдаем
- Если нет, то выгружаем все привязки ролей к нодам, оставляем только ноды вида *#services#{} и проверяем для них право service_see


Есть ручка получения глобальных прав GET /v1/auth/permissions/global, возвращающая в том числе текущий id пользователя (залогиненого на yandex.ru)
