var Ya = Ya || {}; Ya.i18n = function(lang){ return this[lang]};Ya.i18n.prototype = {"en":{"browser.amigo":"Amigo","browser.camino":"Camino","browser.chrome":"Google Chrome","browser.chromium":"Chromium","browser.flock":"Flock","browser.fx":"Firefox","browser.ie":"Internet Explorer","browser.iron":"Iron","browser.maxthon":"Maxthon","browser.opera":"Opera","browser.palemoon":"Pale Moon","browser.safari":"Safari","browser.seamonkey":"SeaMonkey","browser.yabrowser":"Yandex Browser","button.download":"Download another browser","button.update":"Update","button.whattodo":"What do I do?","desc":"Your browser has not been updated in several years. During this time, many sites have started to use new technologies that this browser does not support, and as such cannot correctly display this page. To fix this, please install a new browser.","desc.ie":"Microsoft is about to stop supporting or has already stopped supporting your browser, and will not update it anymore. Using this browser could result in errors when viewing websites and poor functionality. We recommend finding a replacement.","subtitle":"Please update it or install %%.","subtitle.ie":"We recommend installing Internet Explorer 11 or %%.","subtitle.ie.link.txt":"select a different application for browsing the internet","subtitle.link.href":"https://yandex.ru/soft/browsers/","subtitle.link.txt":"a new one","title":"Your browser %% is out of date and does not provide you with a complete site experience, or keep you safe while browsing","title.general":"Your browser is out of date","title.general.ie":"Your browser is obsolete and will not be updated any more","title.unknown":"It's possible your browser is out of date and will not provide you with a full site experience, or keep you safe while browsing","ver":"1.3.2"},"ru":{"browser.amigo":"Amigo","browser.camino":"Camino","browser.chrome":"Google Chrome","browser.chromium":"Chromium","browser.flock":"Flock","browser.fx":"Firefox","browser.ie":"Internet Explorer","browser.iron":"Iron","browser.maxthon":"Maxthon","browser.opera":"Opera","browser.palemoon":"Pale Moon","browser.safari":"Safari","browser.seamonkey":"SeaMonkey","browser.yabrowser":"Yandex Browser","button.download":"Скачать другой браузер","button.update":"Обновить","button.whattodo":"Что делать?","desc":"Ваш браузер не обновлялся уже несколько лет. За это время некоторые сайты стали использовать новые технологии, которые  он не поддерживает и не может корректно отобразить страницу. Чтобы это исправить, попробуйте установить новый браузер.","desc.ie":"Браузер, которым вы пользуетесь, уже не поддерживается или скоро лишится поддержки Microsoft, поэтому больше не будет обновляться. Это значит, что открытые в нём сайты могут отображаться с ошибками. Рекомендуем вам найти замену.","subtitle":"Пожалуйста, обновите его или установите %%.","subtitle.ie":"Рекомендуем вам установить Internet Explorer 11 или %%.","subtitle.ie.link.txt":"выбрать другую программу для просмотра страниц в интернете","subtitle.link.href":"https://yandex.ru/soft/browsers/","subtitle.link.txt":"новый","title":"Ваш браузер %% устарел и не обеспечивает полноценную и безопасную работу с сайтом","title.general":"Ваш браузер устарел","title.general.ie":"Ваш браузер устарел и больше не будет обновляться","title.unknown":"Возможно, ваш браузер устарел и не обеспечивает полноценную и безопасную работу с сайтом","ver":"1.3.2"},"tr":{"browser.amigo":"Amigo","browser.camino":"Camino","browser.chrome":"Google Chrome","browser.chromium":"Chromium","browser.flock":"Flock","browser.fx":"Firefox","browser.ie":"Internet Explorer","browser.iron":"Iron","browser.maxthon":"Maxthon","browser.opera":"Opera","browser.palemoon":"Pale Moon","browser.safari":"Safari","browser.seamonkey":"SeaMonkey","browser.yabrowser":"Yandex Browser","button.download":"Başka bir tarayıcı indir","button.update":"Güncelle","button.whattodo":"Ne yapayım?","desc":"Tarayıcınız en son güncellendiğinden beri birkaç yıl geçti. Bu süre içinde bazı sitelerde tarayıcınızın artık desteklemediği yeni teknolojiler uygulanıyor. Tarayıcınız böyle siteleri doğru görüntülemeyebilir. Bu hatayı düzeltmek için yeni tarayıcıyı yükleyip kurun.","desc.ie":"Kullandığınız tarayıcı Microsoft tarafından artık desteklenmemekte veya bunun desteği önümüzdeki günlerde sonlandırılarak bir daha güncellenmeyecektir. Dolayısıyla web siteleri bu tarayıcıyla hatalı görüntülenebilir. Lütfen başka bir tarayıcı kullanın.","subtitle":"Lütfen tarayıcınızı güncelleyin veya %% yükleyin.","subtitle.ie":"Internet Explorer 11 veya %% kurmanızı öneririz.","subtitle.ie.link.txt":"Web sayfalarının görüntülenmesi için başka bir program seç","subtitle.link.href":"","subtitle.link.txt":"yeni","title":"Kullandığınız tarayıcı (%%) güncel değil. Bu tarayıcıyı kullanarak bu siteyle güvenli ve hatasız çalışamayabilirsiniz","title.general":"Tarayıcınız çok eski","title.general.ie":"Kullandığınız tarayıcı çok eski ve artık güncellenmez","title.unknown":"Tarayıcınız çok eski olabilir. Bu durumda siteyle güvenli ve hatasız çalışmanız mümkün olmayabilir.","ver":"1.3.2"},"uk":{"browser.amigo":"Amigo","browser.camino":"Camino","browser.chrome":"Google Chrome","browser.chromium":"Chromium","browser.flock":"Flock","browser.fx":"Firefox","browser.ie":"Internet Explorer","browser.iron":"Iron","browser.maxthon":"Maxthon","browser.opera":"Opera","browser.palemoon":"Pale Moon","browser.safari":"Safari","browser.seamonkey":"SeaMonkey","browser.yabrowser":"Yandex Browser","button.download":"Завантажити інший браузер","button.update":"Оновити","button.whattodo":"Що робити?","desc":"Ваш браузер не оновлювався вже кілька років. За цей час деякі сайти почали використовувати нові технології, які він не підтримує і не може коректно відобразити сторінку. Щоб це виправити, спробуйте встановити новий браузер.","desc.ie":"Браузер, яким ви користуєтесь, уже не підтримується або скоро позбудеться підтримки Microsoft, тому більше не оновлюватиметься. Це означає, що відкриті в ньому сайти можуть відображатися з помилками. Рекомендуємо вам знайти заміну.","subtitle":"Будь ласка, оновіть його або встановіть %%.","subtitle.ie":"Рекомендуємо вам встановити Internet Explorer 11 або %%.","subtitle.ie.link.txt":"вибрати іншу програму для перегляду сторінок в інтернеті","subtitle.link.href":"https://yandex.ua/soft/browsers/","subtitle.link.txt":"новий","title":"Ваш браузер %% застарів і не забезпечує повноцінну та безпечну роботу із сайтом","title.general":"Ваш браузер застарів","title.general.ie":"Ваш браузер застарів і більше не оновлюватиметься","title.unknown":"Можливо, ваш браузер застарів і не забезпечує повноцінну та безпечну роботу із сайтом","ver":"1.3.2"}};var Ya = window.Ya || {};

Ya.stripe = function(){};

Ya.stripe.prototype = {};if (!window.JSON) {
    window.JSON = {
        parse: function(sJSON) { return eval('(' + sJSON + ')'); },
        stringify: (function () {
            var toString = Object.prototype.toString;
            var isArray = Array.isArray || function (a) { return toString.call(a) === '[object Array]'; };
            var escMap = {'"': '\\"', '\\': '\\\\', '\b': '\\b', '\f': '\\f', '\n': '\\n', '\r': '\\r', '\t': '\\t'};
            var escFunc = function (m) { return escMap[m] || '\\u' + (m.charCodeAt(0) + 0x10000).toString(16).substr(1); };
            var escRE = /[\\"\u0000-\u001F\u2028\u2029]/g;
            return function stringify(value) {
                if (value == null) {
                    return 'null';
                } else if (typeof value === 'number') {
                    return isFinite(value) ? value.toString() : 'null';
                } else if (typeof value === 'boolean') {
                    return value.toString();
                } else if (typeof value === 'object') {
                    if (typeof value.toJSON === 'function') {
                        return stringify(value.toJSON());
                    } else if (isArray(value)) {
                        var res = '[';
                        for (var i = 0; i < value.length; i++)
                            res += (i ? ', ' : '') + stringify(value[i]);
                        return res + ']';
                    } else if (toString.call(value) === '[object Object]') {
                        var tmp = [];
                        for (var k in value) {
                            if (value.hasOwnProperty(k))
                                tmp.push(stringify(k) + ': ' + stringify(value[k]));
                        }
                        return '{' + tmp.join(', ') + '}';
                    }
                }
                return '"' + value.toString().replace(escRE, escFunc) + '"';
            };
        })()
    };
};

if (!Function.prototype.bind) {
    Function.prototype.bind = function(oThis) {
        if (typeof this !== 'function') {
            // closest thing possible to the ECMAScript 5
            // internal IsCallable function
            throw new TypeError('Function.prototype.bind - what is trying to be bound is not callable');
        }

        var aArgs   = Array.prototype.slice.call(arguments, 1),
            fToBind = this,
            fNOP    = function() {},
            fBound  = function() {
                return fToBind.apply(this instanceof fNOP
                        ? this
                        : oThis,
                    aArgs.concat(Array.prototype.slice.call(arguments)));
            };

        fNOP.prototype = this.prototype;
        fBound.prototype = new fNOP();

        return fBound;
    };
}Ya.stripe.utils = function(){};

Ya.stripe.utils.prototype = {};Ya.stripe.utils.prototype.extend = function(source) {
    var i = 1;
    for (; i < arguments.length; i++) {
        var attributes = arguments[ i ];
        for (var key in attributes) {
            if (attributes.hasOwnProperty(key)) {
                source[key] = attributes[key];
            }
        }
    }
    return source;
};

Ya.stripe.utils.prototype.isFunction = function(fn) {
    var getType = {};
    return fn && getType.toString.call(fn) === '[object Function]';
};

Ya.stripe.utils.prototype.isString = function(str) {
    return (typeof str === 'string' || str instanceof String);
};

Ya.stripe.utils.prototype.validateCallback = function(callback) {
    if (this.isFunction(callback)) {
        return callback;
    } else if (this.isString(callback) && this.isFunction(window[callback])) {
        return window[callback];
    }
    return false;
};// forked form https://github.com/js-cookie/js-cookie/src/js.cookie.js
Ya.stripe.utils.prototype.cookieApi = function() {
    var self = this;

    function api (key, value, attributes) {
        var result;

        // Write

        if (arguments.length > 1) {
            attributes = self.extend({
                path: '/'
            }, api.defaults, attributes);

            if (typeof attributes.expires === 'number') {
                var expires = new Date();
                expires.setMilliseconds(expires.getMilliseconds() + attributes.expires * 864e+5);
                attributes.expires = expires;
            }

            try {
                result = JSON.stringify(value);
                if (/^[\{\[]/.test(result)) {
                    value = result;
                }
            } catch (e) {}

            value = encodeURIComponent(String(value));
            value = value.replace(/%(23|24|26|2B|3A|3C|3E|3D|2F|3F|40|5B|5D|5E|60|7B|7D|7C)/g, decodeURIComponent);

            key = encodeURIComponent(String(key));
            key = key.replace(/%(23|24|26|2B|5E|60|7C)/g, decodeURIComponent);
            key = key.replace(/[\(\)]/g, escape);

            return (document.cookie = [
                key, '=', value,
                attributes.expires && '; expires=' + attributes.expires.toUTCString(), // use expires attribute, max-age is not supported by IE
                attributes.path    && '; path=' + attributes.path,
                attributes.domain  && '; domain=' + attributes.domain,
                attributes.secure ? '; secure' : ''
            ].join(''));
        }

        // Read

        if (!key) {
            result = {};
        }

        // To prevent the for loop in the first place assign an empty array
        // in case there are no cookies at all. Also prevents odd result when
        // calling "get()"
        var cookies = document.cookie ? document.cookie.split('; ') : [];
        var rdecode = /(%[0-9A-Z]{2})+/g;
        var i = 0;

        for (; i < cookies.length; i++) {
            var parts = cookies[i].split('=');
            var name = parts[0].replace(rdecode, decodeURIComponent);
            var cookie = parts.slice(1).join('=');

            if (cookie.charAt(0) === '"') {
                cookie = cookie.slice(1, -1);
            }

            try {
                cookie = cookie.replace(rdecode, decodeURIComponent);

                if (this.json) {
                    try {
                        cookie = JSON.parse(cookie);
                    } catch (e) {}
                }

                if (key === name) {
                    result = cookie;
                    break;
                }

                if (!key) {
                    result[name] = cookie;
                }
            } catch (e) {}
        }

        return result;
    }

    api.get = api.set = api;
    api.getJSON = function () {
        return api.apply({
            json: true
        }, [].slice.call(arguments));
    };
    api.defaults = {};

    api.remove = function (key, attributes) {
        api(key, '', self.extend(attributes, {
            expires: -1
        }));
    };


    return api;
};

Ya.stripe.utils.prototype.cookie = Ya.stripe.utils.prototype.cookieApi();/**** DOMContentLoaded (start) ******/
/**
 * @see http://yastatic.net/jquery/1.4.2/jquery.js
 */

/**
 * Вешает обработчик на загрузку DOM.
 * @param {Function} fn
 */
Ya.stripe.utils.prototype.onDOMContentLoaded = (function (win, doc) {
    var isReady = false,

    // Has the ready events already been bound?
        readyBound = false,

    // The functions to execute on DOM ready
        readyList = [],

    // The ready event handler
        DOMContentLoaded;

    function ready() {
        // Make sure that the DOM is not already loaded
        if (!isReady) {
            // Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
            if (!doc.body) {
                return setTimeout(ready, 13);
            }

            // Remember that the DOM is ready
            isReady = true;

            // If there are functions bound, to execute
            if (readyList) {
                // Execute all of them
                var fn, i = 0;
                while ((fn = readyList[i++])) {
                    fn.call(null);
                }

                // Reset the list of functions
                readyList = null;
            }
        }
    }

    function bindReady() {
        if (readyBound) {
            return;
        }

        readyBound = true;

        // Catch cases where $(document).ready() is called after the
        // browser event has already occurred.
        if (doc.readyState === "complete") {
            return ready();
        }

        // Mozilla, Opera and webkit nightlies currently support this event
        if (doc.addEventListener) {
            // Use the handy event callback
            doc.addEventListener("DOMContentLoaded", DOMContentLoaded, false);

            // A fallback to window.onload, that will always work
            win.addEventListener("load", ready, false);

            // If IE event model is used
        } else if (doc.attachEvent) {
            // ensure firing before onload,
            // maybe late but safe also for iframes
            doc.attachEvent("onreadystatechange", DOMContentLoaded);

            // A fallback to window.onload, that will always work
            win.attachEvent("onload", ready);

            // If IE and not a frame
            // continually check to see if the document is ready
            var toplevel = false;

            try {
                toplevel = win['frameElement'] == null;
            } catch (e) {
            }

            if (docElem && docElem.doScroll && toplevel) {
                doScrollCheck();
            }
        }
    }

    // Cleanup functions for the document ready method
    if (doc.addEventListener) {
        DOMContentLoaded = function () {
            doc.removeEventListener("DOMContentLoaded", DOMContentLoaded, false);
            ready();
        };

    } else if (doc.attachEvent) {
        DOMContentLoaded = function () {
            // Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
            if (doc.readyState === "complete") {
                doc.detachEvent("onreadystatechange", DOMContentLoaded);
                ready();
            }
        };
    }

    // The DOM ready check for Internet Explorer
    function doScrollCheck() {
        if (isReady) {
            return;
        }

        try {
            // If IE is used, use the trick by Diego Perini
            // http://javascript.nwbox.com/IEContentLoaded/
            docElem.doScroll("left");
        } catch (error) {
            setTimeout(doScrollCheck, 1);
            return;
        }

        // and execute any waiting functions
        ready();
    }

    return function (fn) {
        // Attach the listeners
        bindReady();

        // If the DOM is already ready
        if (isReady) {
            // Execute the function immediately
            fn.call(null);

            // Otherwise, remember the function for later
        } else {
            // Add the function to the wait list
            readyList.push(fn);
        }
    }
})(window, document);

/**** DOMContentLoaded (end) ******/Ya.stripe.utils.prototype.DomElem = function (tag, options) {
    options = options || {};
    var elem = document.createElement(tag),
        css = options.css,
        attrs = options.attrs;

    attrs && Ya.stripe.utils.prototype.extend(elem, attrs);

    this.domElem = elem;

    if (css) {
        this.domElem.className = css.className;
        this.css = this._buildCss(css);
    }
};

Ya.stripe.utils.prototype.DomElem.prototype = {

    _buildCss: function(css) {
        var className = css.className,
            props = css.props,
            propsStr = '';
        for (var propName in props) {
            if (props.hasOwnProperty(propName)) {
                propsStr += propName + ': ' + props[propName] + ';';
            }
        }
        return '.' + className +'{' + propsStr + '}'
    },

    _removeEvent: function() {
        return document.removeEventListener
            ? function (element, type, listener) {
            element.removeEventListener(type, listener, false);
        }
            : function (element, type, listener) {
            element.detachEvent('on' + type, listener);
        };
    },

    _addEvent: function() {
        return document.addEventListener
            ? function (element, type, listener) {
            element.addEventListener(type, listener, false);
        }
            : function (element, type, listener) {
            element.attachEvent('on' + type, listener);
        }
    },

    getStyle: function(domElem, cssRule) {
        var strValue = '';

        if (document.defaultView && document.defaultView.getComputedStyle) {
            strValue = document.defaultView.getComputedStyle(domElem, '').getPropertyValue(cssRule);
        } else if (domElem.currentStyle) {
            cssRule = cssRule.replace(/\-(\w)/g, function (strMatch, p1){
                return p1.toUpperCase();
            });
            strValue = domElem.currentStyle[cssRule];
        }
        return strValue;
    },

    on: function (event, handler) {
        var self = this;
        this._addEvent()(self.domElem, event, handler);
        return this;
    },

    append: function (anotherElem) {
        this.domElem.appendChild(anotherElem.domElem);
        return this;
    }
};Ya.stripe.utils.prototype.jsonp = function(url, params, callback) {
    var name = 'jsonp65397e1a32a9406289f95f602d15882c',
        mycallback = function (response) {
            delete window[name];
            document.body.removeChild(ua);

            callback(response);
        };

    window[name] = mycallback;

    params['jsonp'] = name;

    url = url + '?';

    for (var paramName in params) {
        if (params.hasOwnProperty(paramName)) {
            url = url + paramName + '=' + params[paramName] + '&';
        }
    }

    var ua = document.createElement('script');
    ua.src = url;
    document.body.appendChild(ua);
};Ya.stripe.init = function(options){
    this.init(options);
};

Ya.stripe.init.prototype = {
    options: {
        theme: 'yellow',
        lang: 'ru',
        browsers: {
            'chromium': 34,
            'iron': 34,
            'flock': 'Infinity',
            'palemoon': 24,
            'camino': 'Infinity',
            'safari': 5.1,
            'yandexinternet': 'Infinity',
            'fx': 30,
            'ie': 8,
            'yabrowser': 14.12,
            'opera': 15,
            'chrome': 34,
            'maxthon': 4.3,
            'seamonkey': 2.3
        },
        remember: true,
        rememberFor: 30,
        cookiePrefix: 'yaBrowserUpdater',
        classNamePrefix: 'ya-browser-updater',
        jsonpCallback: 'yaBrowserUpdaterJSONPCallback',
        onStripeShow: null,
        onStripeHide: null,

        exclusive: false, // 'эксклюзивный' браузер

        // для 'generic' плашки
        generic: false,
        useLink: true,
        hybrid: false,

        // 'секретные' опции
        metrikaId: null,
        colors: {},
        linkParams: null,

        domain: null
    },

    themes: {
        stripe: {
            yellow: {
                bg: '#ffdc3a',
                txt: '#000',
                button: '#f1ce2e',
                close: '#efce36'
            },
            red: {
                bg: '#f00',
                txt: '#fff',
                button: '#e10202',
                close: '#e63232'
            },
            blue: {
                bg: '#7dcef9',
                txt: '#fff',
                button: '#67b5e0',
                close: '#5bb9ef'
            },
            green: {
                bg: '#84cd78',
                txt: '#fff',
                button: '#7dbe72',
                close: '#81c176'
            },
            white: {
                bg: '#fff',
                txt: '#000',
                button: '#f0f0f0',
                close: '#f9f7f7'
            },
            black: {
                bg: '#000',
                txt: '#fff',
                button: '#333',
                close: '#404040'
            },
            grey: {
                bg: '#cbcbcb',
                txt: '#000',
                button: '#cbcbcb',
                close: '#bfbbbb'
            }
        },
        generic: {
            bg: '#333',
            link: '#0398d7',
            txt: '#a6a4a4',
            title: '#fff',
            subtitle: '#fff',
            close: '#666'
        }
    },

    colors: {},

    bundleUrl: 'https://yastatic.net/browser-updater/stripe/',
    popups: {
        choice: 'https://yastatic.net/browser-updater/choice/',
        exclusive: 'https://yastatic.net/browser-updater/exclusive/'
    },
    uaHost: 'https://yandex.ru/browser-updater/',

    i18n: null,
    utils: new Ya.stripe.utils(),

    type: null,
    subtype: 'default',
    browser: null,
    browserVersion: null,

    isCheckUa: true,
    isPopupShown: false,

    domElems: {},
    style: '',
    bodyPadding: '',

    metrikaIds: {
        stripe: '32024286',
        generic: '32039916',
        exclusive: '32024286'
    },

    init: function(options) {
        options = options || {};
        this.utils.extend(this.options, options);

        this.cookieHideCheck()
            .checkUA();
        return this;
    },

    cookieHideCheck: function() {
        if (this.options.remember) {
            var cookie = this.utils.cookie(this.options.cookiePrefix + 'Hide');
            this.isCheckUa = cookie !== 'true';
        }
        return this;
    },

    cookieHideSet: function() {
        if (this.options.remember) {
            this.utils.cookie(this.options.cookiePrefix + 'Hide', 'true', { expires: this.options.rememberFor, domain: this.options.domain, path: '/' });
        }
    },

    checkUA: function() {
        if (!this.isCheckUa) {
            return this;
        }

        var self = this,
            script = document.createElement('script'),
            url = self.uaHost + '?browserUpdate=' + encodeURIComponent(JSON.stringify(self.options.browsers))
                  + '&jsonp=' + this.options.jsonpCallback;

        window[self.options.jsonpCallback] = self.process.bind(self);

        script.src = url;
        document.body.appendChild(script);
        return this;
    },

    getColors: function() {
        var baseColors = this.type === 'generic' ? this.themes.generic : this.themes.stripe[this.options.theme];
        this.colors = typeof this.options.colors === 'object'
            ? this.utils.extend(baseColors, this.options.colors)
            : baseColors;
        return this;
    },

    getLinkParams: function() {
        var linkParams =  typeof this.options.linkParams === 'object' && this.options.linkParams !== null ? this.options.linkParams : false;
        return linkParams ? 'linkParams=' + encodeURIComponent(JSON.stringify(linkParams)) : '';
    },

    process: function(response) {
        window[this.options.jsonpCallback] = undefined;

        this.browser = response.browser;
        this.browserVersion = response.version;
        this.exclusiveBrowser = this.options.exclusive && (
                (typeof this.options.browsers === 'string' && this.options.browsers) ||
                (typeof this.options.browsers === 'object' && Object.keys(this.options.browsers)[0])
        );
        this.needUpdate = response.needUpdate || (this.options.exclusive && this.browser != this.exclusiveBrowser);

        if (!this.needUpdate || (this.browser && this.browser.toLowerCase() === 'amigo')) {
            return false;
        }

        if (this.options.exclusive) {
            this.type = 'exclusive';
        } else if (this.options.generic) {
            this.type = 'generic';
            this.subtype = this.browser === 'ie' ? 'ie' : this.subtype;
        } else {
            this.type = 'stripe';
            switch (this.browser) {
                case 'chromium':
                case 'iron':
                    this.subtype = 'chromium';
                    break;
                case'flock':
                case'palemoon':
                case'camino':
                case'safari':
                    this.subtype = 'old';
                    break;
                case 'yabrowser':
                case 'fx':
                case 'ie':
                case 'opera':
                case 'chrome':
                case 'maxthon':
                case 'seamonkey':
                    this.subtype = 'outdated';
                    break;
                default:
                    this.subtype = 'unknown';
                    break;
            }
        }

        this.i18n = new Ya.i18n(this.options.lang);
        this.getColors()
            .build();
    },

    buildElem: function() {
        var self = this,
            genCssClassName = function() {
                var base = self.options.classNamePrefix,
                    parts = Array.prototype.slice.call(arguments);
                parts.unshift(base);
                return parts.join('__');
            };

        var elemBuilders = {
            stripe: {
                close: function() {
                    var elem = new self.utils.DomElem('div', {
                            css: {
                                className: genCssClassName('stripe', 'close'),
                                props: {
                                    cursor: 'pointer',
                                    float: 'right',
                                    height: '30px',
                                    width: '16px',
                                    'vertical-align': 'middle',
                                    position: 'absolute',
                                    top: '0',
                                    right: '52px',
                                    'font-size': '30px',
                                    'line-height': '32px',
                                    'color': self.colors.close
                                }
                            },
                            attrs: {
                                innerHTML: '&times;'
                            }
                        }).on('click', function() {
                            self.removestripe.bind(self)();
                            self.cookieHideSet.bind(self)();
                            self.reachGoal.bind(self, 'clck_stripe_close')();
                        });

                    self.style += elem.css;
                    return elem;
                },

                txt: function() {
                    var elem = new self.utils.DomElem('span', {
                            attrs: {
                                innerHTML:
                                    self.subtype === 'unknown'
                                        ? self.i18n['title.unknown']
                                        : self.i18n['title'].replace('%%', self.i18n['browser.' + self.browser] + ' ' + self.browserVersion)
                            },
                            css: {
                                className: genCssClassName('stripe', 'txt'),
                                props: {
                                    color: self.colors.txt,
                                    'white-space': 'nowrap'
                                }
                            }
                        });

                    self.style += elem.css;
                    return elem;
                },

                button: function() {
                    var textAndGoal = {
                            chromium: { txt: self.i18n['button.download'], goal: 'clck_stripe_dnld' },
                            old: { txt: self.i18n['button.download'], goal: 'clck_stripe_dnld' },
                            outdated: { txt: self.i18n['button.update'], goal: 'clck_stripe_upd' },
                            unknown: { txt: self.i18n['button.download'], goal: 'clck_stripe_dnld' }
                        }[self.subtype],
                        elem = new self.utils.DomElem('div', {
                            css: {
                                className: genCssClassName('stripe', 'button'),
                                props: {
                                    display: 'inline-block',
                                    padding: '0 15px',
                                    margin: '0 78px 0 0',
                                    cursor: 'pointer',
                                    background: self.colors.button,
                                    color: self.colors.txt
                                }
                            },
                            attrs: {
                                innerHTML: textAndGoal.txt
                            }
                        }).on('click', function() {
                            self.popupShow.bind(self)();
                            self.reachGoal.bind(self, textAndGoal.goal)();
                        });

                    self.style += elem.css;
                    return elem;
                },

                buttonWrap: function() {
                    var elem = new self.utils.DomElem('div', {
                            css: {
                                className: genCssClassName('stripe', 'button-wrap'),
                                props: {
                                    position: 'absolute',
                                    top: 0,
                                    right: 0,
                                    background: self.colors.bg
                                }
                            }
                        });

                    elem.append(this.button()).append(this.close());
                    self.style += elem.css;
                    return elem;
                }
            },
            generic: {
                close: function() {
                    var elem = new self.utils.DomElem('div', {
                            css: {
                                className: genCssClassName('stripe', 'close'),
                                props: {
                                    cursor: 'pointer',
                                    float: 'right',
                                    height: '30px',
                                    width: '16px',
                                    'vertical-align': 'middle',
                                    'font-size': '30px',
                                    'line-height': '32px',
                                    position: 'absolute',
                                    top: '5px',
                                    right: '10px',
                                    'color': self.colors.close
                                }
                            },
                            attrs: {
                                innerHTML: '&times;'
                            }
                        }).on('click', function() {
                            self.removestripe.bind(self)();
                            self.cookieHideSet.bind(self)();
                            self.reachGoal.bind(self, 'clck_stripe_close')();
                        });

                    self.style += elem.css;
                    return elem;
                },

                title: function() {
                    var elem = new self.utils.DomElem('h1', {
                            attrs: {
                                innerHTML:
                                    self.i18n['title.general.' + self.subtype] || self.i18n['title.general']
                            },
                            css: {
                                className: genCssClassName('stripe', 'title'),
                                props: {
                                    'margin': 0,
                                    'padding': 0,
                                    'font-size': '33px',
                                    'font-weight': 'normal',
                                    'color': self.colors.title
                                }
                            }
                        });

                    self.style += elem.css;
                    return elem;
                },

                subtitle: function() {
                    var textArray = (self.i18n['subtitle.' + self.subtype] || self.i18n['subtitle']).split('%%'),
                        elem = new self.utils.DomElem('h2', {
                            css: {
                                className: genCssClassName('stripe', 'subtitle'),
                                props: {
                                    'margin': '18px 0 0px',
                                    'padding': 0,
                                    'font-size': '20px',
                                    'font-weight': 'normal',
                                    'color': self.colors.subtitle
                                }
                            }
                        });
                    elem.domElem.appendChild(document.createTextNode(textArray[0]));
                    self.options.useLink && (self.i18n['subtitle.' + self.subtype + '.link.href'] || self.i18n['subtitle.link.href'])
                        ? elem.append(this.link())
                        : elem.domElem.appendChild(document.createTextNode(self.i18n['subtitle.' + self.subtype + '.link.txt'] || self.i18n['subtitle.link.txt']));
                    elem.domElem.appendChild(document.createTextNode(textArray[1]));

                    self.style += elem.css;
                    return elem;
                },

                link: function() {
                    var elem = new self.utils.DomElem('a', {
                            attrs: {
                                href: self.i18n['subtitle.' + self.subtype + '.link.href'] || self.i18n['subtitle.link.href'],
                                target: '_blank',
                                innerHTML: self.i18n['subtitle.' + self.subtype + '.link.txt'] || self.i18n['subtitle.link.txt']
                            },
                            css: {
                                className: genCssClassName('stripe', 'subtitle', 'link'),
                                props: {
                                    'color': self.colors.link,
                                    'text-decoration': 'none'
                                }
                            }
                        }).on('click', function(e) {
                            self.reachGoal.bind(self, 'clck_new')();
                            if (self.options.hybrid) {
                                e.preventDefault();
                                self.popupShow.bind(self)();
                                return false;
                            }
                        });
                    self.style += elem.css;
                    return elem;
                },

                desc: function() {
                    var elem = new self.utils.DomElem('div', {
                            attrs: {
                                innerHTML: self.i18n['desc.' + self.subtype] || self.i18n['desc']
                            },
                            css: {
                                className: genCssClassName('stripe', 'desc'),
                                props: {
                                    'margin': '15px 0 0',
                                    'padding': 0,
                                    'font-size': '13px',
                                    'line-height': '22px',
                                    'color': self.colors.txt
                                }
                            }
                        });
                    self.style += elem.css;
                    return elem;
                }
            },

            popup: {
                paranja: function() {
                    var elem = new self.utils.DomElem('div', {
                            css: {
                                className: genCssClassName('popup', 'paranja'),
                                props: {
                                    'position': 'fixed',
                                    'z-index': 32000,
                                    'top': 0,
                                    'left': 0,

                                    'width': '100%',
                                    'height': '100%',
                                    'padding': 0,

                                    '-webkit-user-select': 'none',
                                    '-moz-user-select': 'none',
                                    '-ms-user-select': 'none',
                                    'user-select': 'none',

                                    'opacity': '.3',
                                    'border': '0',
                                    'background': '#000',
                                    '-ms-filter': 'progid:DXImageTransform.Microsoft.Alpha(Opacity=33)',
                                    'filter': 'alpha(opacity=33)'
                                }
                            }
                        }).on('click', function() {
                            self.popupRemove.bind(self)();
                            self.reachGoal.bind(self, 'clck_popup_close')();
                        });

                    self.style += elem.css;
                    return elem;
                },
                close: function() {
                    var elem = new self.utils.DomElem('div', {
                            css: {
                                className: genCssClassName('popup', 'close'),
                                props: {
                                    'position': 'absolute',
                                    'top': '5px',
                                    'right': '5px',
                                    'width': '16px',
                                    'height': '30px',
                                    'padding': '0 10px 0 0',
                                    'cursor': 'pointer',
                                    'background': 'url(' + self.bundleUrl + 'img/popup__close.png) 0 100% no-repeat'
                                }
                            }
                        }).on('click', function() {
                            self.popupRemove.bind(self)();
                            self.reachGoal.bind(self, 'clck_popup_close')();
                        });

                    self.style += elem.css;
                    return elem;
                },
                iframe: function() {
                    var heights = {
                            ru: {
                                chromium: '370px',
                                old: '370px',
                                outdated: '330px',
                                unknown: '300px'
                            },
                            tr: {
                                chromium: '370px',
                                outdated: self.browser === 'ie' ? '330px' : '300px',
                                old: '340px',
                                unknown: '300px'
                            },
                            uk: {
                                chromium: '330px',
                                outdated: self.browser === 'ie' ? '350px' : '330px',
                                old: '370px',
                                unknown: '300px'
                            },
                            en: {
                                chromium: '370px',
                                outdated: self.browser === 'ie' ? '330px' : '300px',
                                old: '340px',
                                unknown: '300px'
                            }
                        };
                    var metrikaId = self.options.metrikaId || (self.options.hybrid ? self.metrikaIds.generic : self.metrikaIds.stripe),
                        subtype = self.options.hybrid ? 'outdated' : self.subtype,
                        theme = self.options.hybrid ? 'generic' : self.options.theme,
                        linkParams = self.getLinkParams(),
                        src = self.popups.choice + subtype + '.' + self.options.lang + '.html?metrikaId=' + metrikaId
                              + '&theme=' + theme
                              + '&_ver=' + self.i18n['ver']
                              + (linkParams && '&' + linkParams),
                        elem = new self.utils.DomElem('iframe', {
                            attrs: {
                                name: genCssClassName('popup', 'iframe'),
                                src: src,
                                scrolling: 'no'
                            },
                            css: {
                                className: genCssClassName('popup', 'iframe'),
                                props: {
                                    width: '100%',
                                    border: 0,
                                    overflow: 'hidden',
                                    height: heights[self.options.lang][subtype]
                                }
                            }
                        });

                    elem.domElem.setAttribute('frameBorder', '0'); // ie

                    self.style += elem.css;
                    return elem;
                },
                wrap: function() {
                    var elem = new self.utils.DomElem('div', {
                            css: {
                                className: genCssClassName('popup', 'wrap'),
                                props: {
                                    'position': 'fixed',
                                    'z-index': '32700',
                                    'top': '50%',
                                    'left': '50%',
                                    'width': '670px',
                                    'margin-top': '-240px',
                                    'margin-left': '-400px',
                                    'padding': '40px 65px',
                                    'text-align': 'center',
                                    'color': '#333',
                                    'background': '#fff',
                                    '-webkit-box-shadow': 'inset 0 0 0 1px rgba(0,0,0,.15),0 8px 30px -5px rgba(0,0,0,.5)',
                                    '-moz-box-shadow': 'inset 1px 1px 10px #aaa',
                                    'box-shadow': 'inset 0 0 0 1px rgba(0,0,0,.15),0 8px 30px -5px rgba(0,0,0,.5)'
                                }
                            }
                        });

                    elem.append(this.close()).append(this.iframe());
                    self.style += elem.css;
                    return elem;
                }
            },
            exclusive: {
                iframe: function() {
                    var metrikaId = self.options.metrikaId || self.metrikaIds.exclusive,
                        linkParams = self.getLinkParams(),
                        src = self.popups.exclusive + self.exclusiveBrowser + '.' + self.options.lang + '.html?metrikaId=' + metrikaId
                            + (linkParams && '&' + linkParams),
                        elem = new self.utils.DomElem('iframe', {
                            attrs: {
                                name: genCssClassName('popup', 'iframe'),
                                src: src,
                                scrolling: 'no'
                            },
                            css: {
                                className: genCssClassName('popup', 'iframe'),
                                props: {
                                    width: '100%',
                                    height: '100%',
                                    border: 0
                                }
                            }
                        });

                    elem.domElem.setAttribute('frameBorder', '0'); // ie

                    self.style += elem.css;
                    return elem;
                }
            }
        };

        return {
            stripe: function() {
                var elem = new self.utils.DomElem('div', {
                        css:{
                            className: genCssClassName('stripe'),
                            props: {
                                'position': 'fixed',
                                'z-index': '90000',
                                'left': '0',
                                'top': '0',
                                'width': '100%',
                                'font': '13px Arial, Helvetica, sans-serif',
                                'line-height': '30px',
                                'padding-left': '42px',
                                'background': self.colors.bg,
                                'overflow': 'hidden'
                            }
                        }
                    });
                self.style += elem.css;
                elem.append(elemBuilders.stripe.txt())
                    .append(elemBuilders.stripe.buttonWrap());

                self.domElems.stripe = elem;
                return elem;
            },

            generic: function() {
                var elem = new self.utils.DomElem('div', {
                        css:{
                            className: genCssClassName('stripe'),
                            props: {
                                'position': 'relative',
                                'padding': '40px 5%',
                                'width': '90%',
                                'overflow': 'hidden',
                                'font': '13px Arial, Helvetica, sans-serif',
                                'line-height': '30px',
                                'background': self.colors.bg
                            }
                        }
                    });
                self.style += elem.css;
                elem.append(elemBuilders.generic.close())
                    .append(elemBuilders.generic.title())
                    .append(elemBuilders.generic.subtitle())
                    .append(elemBuilders.generic.desc());

                self.domElems.stripe = elem;
                return elem;
            },

            popup: function() {
                var elem = new self.utils.DomElem('div', {
                        css:{
                            className: genCssClassName('popup'),
                            props: {
                                display: 'none'
                            }
                        }
                    });
                self.style += elem.css;
                elem.append(elemBuilders.popup.paranja())
                    .append(elemBuilders.popup.wrap());

                self.domElems.popup = elem;

                return elem;
            },

            exclusive: function() {
                var elem = new self.utils.DomElem('div', {
                        css:{
                            className: genCssClassName('popup'),
                            props: {
                                display: 'block',
                                position: 'fixed',
                                top: '0',
                                left: '0',
                                width: '100%',
                                height: '100%',
                                background: '#fff',
                                padding: '0'
                            }
                        }
                    });
                self.style += elem.css;
                elem.append(elemBuilders.exclusive.iframe());

                self.domElems.popup = elem;

                return elem;
            },

            style: function() {
                var css = self.style;
                var elem =  new self.utils.DomElem('style', {
                    type:'text/css'
                });

                try {
                    elem.domElem.appendChild(document.createTextNode(css));
                } catch (e) {
                    elem.domElem.setAttribute('type', 'text/css');
                    elem.domElem.styleSheet.cssText = css;
                }

                return elem;
            },

            metrika: function() {
                var elem = new self.utils.DomElem('script', {
                        attrs: {
                            src: 'https://mc.yandex.ru/metrika/watch.js',
                            type: 'text/javascript'
                        }
                    });

                self.domElems.metrika = elem;

                return elem;
            }
        }
    },

    metrikaInit: function() {
        var self = this,
            cb = 'yandex_metrika_callbacks',
            metrikaId = self.options.metrikaId || self.metrikaIds[self.type],
            metrikaParams = self.type === 'stripe' ? { theme: self.options.theme } : {};
        self.counter = 'yaCounter'+metrikaId;

        (window[cb] = window[cb] || []).push(function() {
            try {
                window[self.counter] = new Ya.Metrika({
                    id: metrikaId,
                    clickmap: true,
                    trackLinks: true,
                    accurateTrackBounce: true,
                    webvisor: true,
                    trackHash: true,
                    params: metrikaParams
                });
            } catch(e) { }
        });
    },

    reachGoal: function(goal) {
        var self = this;

        window[self.counter].reachGoal(goal)
    },

    build: function() {
        var self = this;

        self.buildElem = this.buildElem();

        self.utils.onDOMContentLoaded(function() {
            var $stripe,
                $popup;

            if (self.type === 'exclusive') {
                var $exclusive = self.buildElem.exclusive();
                document.body.appendChild($exclusive.domElem);
                document.body.style.overflow = 'hidden';
            } else if (self.type === 'generic') {
                $stripe = self.buildElem.generic();
                document.body.insertBefore($stripe.domElem, document.body.firstChild);
                if (self.options.hybrid) {
                    $popup = self.buildElem.popup();
                    document.body.appendChild($popup.domElem);
                }
                self.onStripeShowCallback();
            } else {
                $stripe = self.buildElem.stripe();
                $popup = self.buildElem.popup();
                self.bodyPaddingAdjust(30);
                document.body.insertBefore($stripe.domElem, document.body.firstChild);
                document.body.appendChild($popup.domElem);
                self.onStripeShowCallback();
            }

            var $metrika = self.buildElem.metrika();
            document.body.appendChild($metrika.domElem);
            self.metrikaInit();

            var $style = self.buildElem.style(),
                $head = document.head || document.getElementsByTagName('head')[0];
            $head.appendChild($style.domElem);
        });
    },

    bodyPaddingAdjust: function(padding) {
        var bodyPadding = this.utils.DomElem.prototype.getStyle(document.body, 'padding-top');
        this.bodyPadding = parseInt(bodyPadding, 10);
        document.body.style.paddingTop = this.bodyPadding + padding + 'px';
    },

    popupShow: function() {
        if (this.isPopupShown) {
            return;
        }
        this.domElems.popup.domElem.style.display = 'block';
        this.isPopupShown = true;
        this.removestripe();
    },

    popupRemove: function() {
        document.body.removeChild(this.domElems.popup.domElem);
    },

    removestripe: function() {
        document.body.removeChild(this.domElems.stripe.domElem);
        document.body.style.paddingTop = this.bodyPadding + 'px';

        this.onStripeHideCallback();
    },

    onStripeShowCallback: function() {
        var callback = this.utils.validateCallback(this.options.onStripeShow);
        if (callback !== false) {
            callback();
        }
    },

    onStripeHideCallback: function() {
        var callback = this.utils.validateCallback(this.options.onStripeHide);
        if (callback !== false) {
            callback();
        }
    }

};

Ya.strip = Ya.stripe;

var ya = window.ya || {};
ya.browserUpdater = Ya.stripe;