# Советы и рекомендации

Здесь собраны советы и рекомендации, накопленные Яндексом при использовании сервиса Антиблок. Подходы, описанные ниже, существенно облегчают борьбу с блокировщиками рекламы.

## Скрипт определения блокировщика

* Не исправляйте код скрипта определения блокировщика и не оставляйте комментарии, поясняющие его работу. Если есть какие-то замечания или вопросы к работе скрипта, обратитесь к дежурной поддержке для пояснений и исправлений.
* Не используйте в качестве имен переменных, функций и cookie слова: `adblock`, `antiadblock`, `adb`, `ads`, `adv` и т.д.
* Если вы используете функциональность `callback` из скрипта определения блокировщика для реализации своей логики на сайте, например, для перезагрузки страницы, то не следует писать комментарии, содержащие пояснения. Также избегайте имен переменных, которые явным образом дают представление зачем они используются (`isAdblock`, `isBlocked` и т.д). По таким словам очень просто найти на сайте нужную логику по обходу блокировок рекламы и придумать правила по ее удалению.
* Не переопределяйте стандартные свойства и функции браузера. Если на сайте умышленно или в виде `legacy` переопределяются стандартные браузерные свойства и функции, например, свойства `window`, то следует сообщить об этом в поддержку. Такие изменения могут ломать логику работы скрипта определения блокировщика, рекламных скриптов, cookie matching и т.д.
* Не используйте минификаторы на скрипте определения блокировщика. Скрипт уже минифицирован и при повторной минификации логика работы может быть нарушена. Вставьте скрипт в код, который уже прошел минификацию, либо добавьте скрипт в исключения.

## Верстка

* При выборе значений `id` и `class` у блоков c рекламой, не используйте короткие или общеупотребимые слова, которые могут встретиться в полезном контенте (`right/left/banner/ad/adv/wrap/ring`), поскольку это затрудняет маскирование таких `id` и `class`.
* Не используйте в верстке inline-стили. Inline-стили являются атрибутами элементов в DOM-дереве и на них можно завязать правила с css-селекторами. Желательно все стили вынести в отдельные css-файлы и связать с элементами с помощью классов.
* Часто блокировщики рекламы запрещают на сайте использование элементов `iframe`, исходя из того, что некоторая часть рекламы рисуется внутри `iframe`.
* Если на странице есть динамически подгружаемый контент(например, лента новостей или объявлений при скроллинге), то самый простой способ правильно шифровать контент при длительном нахождении пользователя на сайте это сделать отдельную ручку подгрузки контента, например, `https://partner.com/ajax/` и зашифровать ее. Важно учесть, что XHR-запрос за контентом должен выполняться с помощью метода GET, так как прокси не обрабатывает POST запросы.

>##### &#8505; Совет.<br>
>1) Если на вашем сайте не используется `iframe`, то следует обернуть какой-либо важный контент (например, навигацию, блок снизу или сбоку) в `iframe`. Это позволит избежать правил, запрещающих использование `iframe`.
>2) Если на вашем сайте есть система комментариев или блог, позволяющий оставлять ссылки на `youtube` и другие видеохостинги, то при обнаружении блокировки обратитесь с жалобой в службу поддержки блокировщика (см. Другое).
* В `HTML5` некоторые элементы предоставляют поддержку `CORS` через атрибут `crossorigin`. Если на странице какие-либо теги, например `script`, `img` или `link` указаны с атрибутом `crossorigin="anonymous"` или `crossorigin` без значения (тогда используется значение `"anonymous"` по умолчанию), то при работе сервиса Антиблок возникнут проблемы с загрузкой этих ресурсов в браузере `Safari`. `Safari` использует атрибут `crossorigin` и не отправляет `cookies` даже при некроссдоменных запросах. Чтоб избежать поломки сайта за блокировщиком, уберите атрибут `crossorigin` или задайте ему значение `"use-credentials"`.

## Server side

* При подключении к сервису Антиблок на сайт будет идти большой поток запросов с IP-адресов Яндекс. Если используются системы защиты от `DDOS`, то такие запросы попадут в список подозрительных. Следует заранее внести адреса Яндекс в белый список. Список необходимых адресов можно получить у вашего менеджера при подключении.
* Не используйте в nginx локации (директива `location` в терминах nginx) с перехватом файлов по расширению (`js/css/jpg`). Некоторые рекламные скрипты и библиотеки склеивают ссылки на лету и на выходе получаются ссылки, содержащие указанные расширения, например: `https://partner.com/6dgd6/dfjhsd74hyfdh/sdjkds489sfjk.jpeg`. Такие ссылки при неправильно настроенной локации не будут попадать в сервис Антиблок и вернут ошибку, так как не могут быть расшифрованы на стороне партнера.

## Реклама

Cервис Антиблок работает только с актуальной версией рекламных блоков RTB. Подробную информацию об актуальных версиях можно найти по [ссылке](https://yandex.ru/support/partner2/web/products-rtb/partner-code.html). Работоспособность старых блоков не гарантируется. Если обновление в каких-то случаях невозможно или затруднено стоит сообщить в дежурную поддержку.

### AdFox

* Для корректной работы AdFox с сервисом Антиблок используте актуальный код вставки рекламы из [документации AdFox](https://sites.help.adfox.ru/page/45/).
* Реклама РСЯ через AdFox за блокировщиками показывается по умолчанию, никаких дополнительных настроек делать не нужно.

>##### &#8505; Совет.<br>
>Если вы хотите показывать баннеры напрямую через AdFox, используйте специальный шаблон "Картинка" в интерфейсе AdFox. Для подключения этого шаблона, обратитесь в службу поддержки AdFox.

## Другое

Иногда блокировщики рекламы своими изменениями в листах могут сломать у сайта верстку или логику работы скриптов. В таких случаях стоит сообщить на форуме, что сайт был сломан и попросить исправить ситуацию.
* Заранее заведите себе учетную запись на форуме [ruadlist](https://forums.lanik.us/viewforum.php?f=102) и [adguard](https://forum.adguard.com/index.php#russian-forums-russkie-forumy.3) для написания жалоб.
* Создайте легенду обычного пользователя или администратора небольшой сети с несколькими сообщениями в сторонних темах.
* Не стоит представляться владельцем или разработчиком сайта, так как администраторы форума часто негативно относятся к таким просьбам и отказываются вносить изменения.
