# Настройка обнаружения блокировщика рекламы у пользователя
При заходе пользователя на страницу, партнеру (площадке) необходимо определить наличие или отсутствие AdBlock-приложения у пользователя. Рекомендуется сделать это с помощью готового решения (скрипта) от Яндекса.

Скрипт — автономный детектор блокировщика рекламы с минимальной функциональностью. При запуске он загружает расширенную версию библиотеки. Библиотека обнаруживает множество блокировщиков с помощью разных методов.

# Плюсы использования готового решения от Яндекса
* Наличие загружаемой и автоматически обновляемой библиотеки — больше не надо самостоятельно периодически менять код обнаружения блокировщика на страницах вашей площадки.
* Более гибкая настройка обнаружения для каждого домена (на основе написанных для него правил).
* Если ссылка с расширенной версией библиотеки будет заблокирована, скрипт-загрузчик все равно поймет, что у пользователя установлен блокировщик рекламы, и проставит cookie наличия AdBlock-приложения.
* Скрипт-загрузчик может самостоятельно проставлять cookie наличия AdBlock-приложения, TTL и имя cookie.
* В случае обнаружения факта отключения AdBlock-приложения, cookie автоматически удаляется при следующих действиях: закрытие браузера, переход на другую страницу, закрытие вкладки.

# Встраивание скрипта в код партнера
Скрипт необходимо встраивать в код одним из способов:
* методом inline в теле страницы: спрятать код среди кода другого важного скрипта, вставленного таким же образом;
* методом inline в один из своих скриптов, загружаемых по ссылке.
>##### &#9888; Внимание.<br>
>Скрипт, который маскирует скрипт-загрузчик, должен обладать важной логикой, тогда AdBlock-приложению будет сложно заблокировать такой скрипт без ущерба для сайта. В качестве скрипта для маскировки не подходят скрипты Яндекс.Метрики или Google Analytics.

```javascript
!function(){var r,f=["weHsigz1BMn0Aw9UCYb3zxjLihjLyxnZAwDUzwq=","zgv0zwn0x0LoteLorq==","we1mshr0CfjLCxvLC3q=","yMvLCMTH","vu5ltK9xtG==","zgf0yq==","C3rLChm=","y2fSBgjHy2S=","Aw5MCMfTzq==","rw1WDhKGy29UzMLNlNnYyW==","ChvZAa==","BgvUz3rO","oYbWyxrOps87igrVBwfPBJ0U","C3bSAxq=","r0vu","weHsihjLCxvLC3qGzxjYB3i=","C3jJ","vfjvu1rfrcbysfiGqu5tv0vs","yMXVy2TLza==","weHsiefou1DfuG==","vgLTzw91Da==","yMXVy2TLCG==","DMfSDwu=","C3bIlNj1","u3rHDhvZoIa=","y2HHCKnVzgvbDa==","DgfNCW==","CNq/CM5Kpte=","y29TlMfT","Dhj1C3rLza==","zNjVBunOyxjdB2rL","rNvUy3rPB24=","w29IAMvJDcbbCNjHEv0=","weHsignVBNn0CNvJDg9YigvYCM9Y","Aw5PDa==","CMvTB3zLrxzLBNrmAxn0zw5LCG==","weHsifjfuvvfu1q=","y29VA2LL","CgLK","rxjYB3iGD2HPBguGC3vIC2nYAwjPBMCGre9nq29UDgvUDeXVywrLza==","zg9ty3jVBgW=","mI4XlJa=","C2vUzejLywnVBG==","C2vSzG==","yMX0C3i=","yNjVD3nLCG==","zwXLBwvUDa==","B25LCNjVCG==","zxzLBNq=","vw5RBM93BG==","zxHWAxjLCW==","AgfZt3DUuhjVCgvYDhK=","Ag9ZDg5HBwu=","Dg9gAxHLza==","ywfIx2rLDgvJDa==","D2L0AenYzwrLBNrPywXZ","C3rHDhvZvgv4Da==","B3bLBG==","u3rYAw5N","sLnptG==","zxzLBNroyw1L","zgv4lM5LDc9HzhzL","zg9JDw1LBNrfBgvTzw50","oYbtyw1Lu2L0zt1oB25LoYbZzwn1CMu=","Ahr0Chm6lY9ZDgf0","AwmTBw9UlNLHBG==","rgf0zq==","y29TlNrY","zgv2AwnL","veLnru9vva==","sgvHzgvYigXLBMD0AcbKB2vZBID0ig1HDgnO","AhjLzG==","y29TCgXLDgu=","ChjVDg90ExbL","Bg9HzgLUzW==","su5msu5f","CMvHzhLtDgf0zq==","u1rbuLq=","yKHwA1KYrt0=","werVBwfPBLjLCxvLC3q=","yMLUza==","C2v0vgLTzw91Da==","y29UDgv4Da==","yNrVyq==","Dg9vventDhjPBMC=","Bg9JywXtDg9YywDL","y28UAwW=","y29TlMDL","DMvYC2LVBG==","Aw4UDwe=","zg9JDw1LBNrnB2rL","ywrKAxrPB25HBa==","Bg9JyxrPB24=","BMfTzq==","ywrKrxzLBNrmAxn0zw5LCG==","CMvZCg9UC2vuzxH0","oYbLEhbPCMvZpq==","ic0G","Dg9W","zxzLBNrFzgv0zwn0x0LoteLorq==","BMf2AwDHDg9Y","y29UDgvUDc1Szw5NAhq=","C2XPy2u=","C2vYDMLJzq==","DgLTzxn0yw1W","yMvMB3jLDw5SB2fK","y3LJywrH","y2fSBa==","ue9tva==","C2vUza==","BxnRlNj1","Aw5KzxHpzG==","BgfIzwXZ","y2XLyxjuAw1LB3v0","DgLTzw91Da==","B25SB2fK","zxzLBNruExbL","BwvZC2fNzq==","Dg9tDhjPBMC=","z2v0q29TChv0zwrtDhLSzq==","weHsievsuKjbq0S=","re9nq29UDgvUDeXVywrLza==","tNvTyMvY","re9nieXpqurfra==","re9difjfqurz","tK9ux0jmt0nlruq=","AM9PBG==","C3rHy2S=","BhvKy2e=","C2v0sxrLBq==","C3rYAw5NAwz5","DgLTzq==","zNvUy3rPB24=","zg9TywLU","z2v0uMvZCg9UC2vizwfKzxi=","CgfNzwHPzgu="];r=f,function(x){for(;--x;)r.push(r.shift())}(272);var X=function(x,r){var n=f[x=+x];void 0===X.rxwhFs&&(X.SPtpzv=function(x){for(var r=function(x){for(var r,n,v=String(x).replace(/=+$/,""),f="",t=0,a=0;n=v.charAt(a++);~n&&(r=t%4?64*r+n:n,t++%4)&&(f+=String.fromCharCode(255&r>>(-2*t&6))))n="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=".indexOf(n);return f}(x),n=[],v=0,f=r.length;v<f;v++)n+="%"+("00"+(function(a,b){return" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".indexOf(a[b])+32})(r,v).toString(16)).slice(-2);return decodeURIComponent(n)},X.hbLtoG={},X.rxwhFs=!0);var v=X.hbLtoG[x];return void 0===v?(n=X.SPtpzv(n),X.hbLtoG[x]=n):n=v,n};!function(C,g,x){var r,y=X,B={};for(r in x)x[y("0x34")](r)&&(B[r]=x[r]);var D=[y("0x44"),y("0x58"),y("0x1d"),y("0x57"),y("0x6f"),y("0x18"),y("0x5a")],h=C[y("0x50")]||C[y("0x3")],n=y("0x11"),v=y("0x1e"),M=y("0x26"),b=y("0x84"),a=y("0x53"),f=y("0x8"),A=y("0x6b"),t=y("0x4"),j=y("0x81"),e=y("0x4f"),q=[y("0x41"),y("0x42"),y("0x3e"),y("0x1c")][y("0x7f")]("");B[M]=B[M]||y("0x2d");try{({})[y("0x77")][y("0x6c")](B[M])!==y("0x21")&&(B[M]=[B[M]])}catch(x){}B[b]=B[b]||336,B[a]=B[a]||{};var L=B[f];if(B[f]=K,B[n]){var w=B[n],z=B[v],N=[],u=s();try{if(!l(C[y("0x5f")])||!l(C[y("0x78")])||!l(C[y("0x20")][y("0x4a")][y("0x51")])||g[y("0x5b")]&&g[y("0x5b")]<=10){var c={};return c[y("0x13")]=!1,c[y("0x16")]=y("0x7e"),K(c)}}catch(x){}var o,i,d,H,G,U=null;B[y("0x73")]&&(o=function(){var x=y;Y(x("0x46")),V(x("0x15"))},i=2e4,d=s(),H=null,G=!1,function x(){var r=X;G||(s()-d>=i?o():H=C[r("0x52")](function(){x()},100))}(),U=function(){G=!0,C[X("0x72")](H)}),function(n){var v=y;if(Y(v("0x4e")),g[v("0x4d")]===v("0x49")||g[v("0x4d")]!==v("0x4b")&&!g[v("0x3f")][v("0x29")])Y(v("0x7d")),n();else try{g[v("0x5f")]&&g[v("0x5f")](v("0x7a"),function x(){var r=v;Y(r("0x7c")),g[r("0x24")](r("0x7a"),x),n()})}catch(x){Y(v("0x28")),V(x&&x[v("0x80")])}}(function(){var f=y;try{var t=s();Y(f("0x25")),S(w,function(x){var r=f;try{U&&U(),Y(r("0x14"));var n=C[r("0x7b")](x[r("0x87")](r("0x66"))),v=x[r("0x60")][r("0xc")];if(!n||n<32e3||n!==v)return V(r("0x47"),n+r("0x62")+v),0;new C[r("0x20")](x[r("0x60")])[r("0x6c")](B[a]),B[a][r("0x23")](C,g,B)}catch(x){V(x&&x[r("0x76")])}},function(x,r){var n,v=f;try{U&&U(),Y(v("0x79")),s()-t<2e3?z?S(z,function(){Y(v("0x12")),V(x,r)},function(){var x=v,r={};r[x("0x13")]=!1,r[x("0x16")]=x("0x7e"),K(r)}):V(x,r):((n={})[v("0x13")]=!1,n[v("0x16")]=v("0x7e"),K(n))}catch(x){V(x&&x[v("0x76")])}})}catch(x){V(x&&x[f("0x80")])}})}else V(y("0xa"));function Y(x){var r=y,n={};n.d=x,n.t=s()-u,N[r("0xb")](n)}function l(x){return typeof x===y("0x85")}function s(){var x=y;return C[x("0x7b")](new C[x("0x43")])}function T(x,r,n){var v,f,t=y;try{C[t("0x56")]&&(n&&(f=y,v=(24e5*(s()/24e5)[f("0x36")]())[f("0x77")](36)[f("0x67")](0,10),r=C[t("0x54")](v)+e+C[t("0x54")](function(x,r){for(var n=y,v=[],f=0;f<x[n("0xc")];f++){var t=x[n("0x1a")](f)^r[n("0x1a")](f%r[n("0xc")]);v[n("0xb")](C[n("0x3b")][n("0x1f")](t))}return v[n("0x7f")]("")}(r,v))),C[t("0x56")][t("0x82")](x,r))}catch(x){}}function K(x){var r=y("0x2a");L&&L(x,r),T(t,r)}function P(x,r){var n=y;return r?x[n("0xe")](".")[n("0x67")](-r)[n("0x7f")]("."):x}function V(x,r){var v=y,n=s(),f=new C[v("0x43")](n+36e5*B[b])[v("0x55")](),t=[],a=P(C[v("0x5d")][v("0x35")],2);function e(){for(var x=v,r=0;r<t[x("0xc")];r++){var n=t[r];g[x("0x26")]=n[x("0x5e")]+"="+n[x("0x17")]+x("0x61")+n[x("0x33")]+x("0xd")+n[x("0x86")]+x("0x40")}}-1!==D[v("0x70")](a)&&(a=P(C[v("0x5d")][v("0x35")],3));for(var L=B[M],w=0;w<L[v("0xc")];w++){var z={};z[v("0x5e")]=L[w],z[v("0x17")]=1,z[v("0x33")]=f,z[v("0x86")]=a,t[v("0xb")](z)}var u,c,o=function(x){for(var r=y,n=g[r("0x26")][r("0xe")]("; "),v=0;v<n[r("0xc")];v++){var f=n[v][r("0xe")]("=");if(f[0]===x)return f[r("0x67")](1)[r("0x7f")]("=")}return null}(A);o&&(g[v("0x26")]=A+"="+o+v("0xd")+a+v("0x40"),(u={})[v("0x5e")]=A,u[v("0x17")]=o,u[v("0x33")]=new C[v("0x43")](0)[v("0x55")](),u[v("0x86")]=a,t[v("0xb")](u));try{C[v("0x5f")](v("0x6a"),e),C[v("0x5f")](v("0x0"),e)}catch(x){e()}try{(function(x,r){var n=y,v={};v[n("0x59")]=n("0x2a"),v[n("0x2f")]=x,v[n("0x5c")]=r,v[n("0x9")]=C[n("0x63")]!==C[n("0x2c")],v[n("0x7")]=N;var f={};f[n("0x2e")]=n("0x32"),f[n("0x45")]=n("0x32"),f[n("0x16")]=n("0x4c"),f[n("0x27")]=n("0x32"),f[n("0x2f")]="i0",f[n("0x59")]="1";var t={};t[n("0x64")]=1;var a={};a[n("0x6")]=v,a[n("0x71")]=f,a[n("0x1b")]=t,a[n("0x5d")]=C[n("0x5d")][n("0x48")],a[n("0x69")]=s(),a[n("0x68")]=n("0x37"),a[n("0x3d")]=n("0x2"),a[n("0x75")]=n("0x31"),a[n("0x17")]=1,a[n("0x59")]="1";var e=a,L=C[n("0x3c")][n("0x83")](e);{var w;l(C[n("0x65")][n("0x2b")])?C[n("0x65")][n("0x2b")](q,L):((w=new h)[n("0x3a")](n("0x6d"),q,!0),w[n("0x6e")](L))}})(x,r=r||""),T(j,[(new C[v("0x43")])[v("0x55")](),v("0x5"),x,r,C[(c=y)("0x5d")]?typeof C[c("0x5d")][c("0x77")]===c("0x85")?C[c("0x5d")][c("0x77")]():C[c("0x5d")][c("0x48")]||"":""][v("0x7f")]("\n"),!0)}catch(x){}var i={};i[v("0x13")]=!0,i[v("0x16")]=v("0x5"),K(i)}function S(x,r,n){var v=y,f=new h;if(0!==f[v("0x4d")])throw new Error(v("0x22"));if(f[v("0x3a")](v("0xf"),x,!0),1!==f[v("0x4d")]||f[v("0x6e")]!==h[v("0x4a")][v("0x6e")])throw new Error(v("0x1"));f[v("0x38")]=!0,f[v("0x74")]=function(){r(f)},f[v("0x30")]=function(){var x=v;n(x("0x10"),x("0x19")+f[x("0x39")])},f[v("0x6e")]()}}(window,document,{
    src: "https://static-mon.yandex.net/static/main.js?pid=<PARTNER-ID>",
    cookie: "somecookie",
    callback: aab
})}();

function aab(result) {
    if (result.blocked === true) {
        // Есть блокировщик
    } else {
        // Нет блокировщика
    }
};
```

Параметры скрипта

Параметр | Обязательность | Описание
-------- | -------------- | --------
`src` | Да | Ссылка на расширенную версию библиотеки, которую необходимо загрузить. Ссылка всегда остается неизменной, меняется только значение query-параметра `pid`.
`<PARTNER-ID>` | Да | Уникальный идентификатор партнера. Выдается в процессе подключения.
`cookie` | Нет | Имя или массив имен cookie, которая устанавливается при наличии AdBlock-приложения. Значение по умолчанию: имя — `bltsr`, `TTL` — 14 дней.
`script` | Нет | boolean-флаг. Устанавливается, если нужно защитить `static-mon` шифрованием от замен в теле ответа. В этом случае загрузчик запросит основную часть через `jsonp`. Значение по умолчанию: `false`.
`callback` | Нет | Callback-функция, которая вызывается после определения наличия или отсутствия блокировщика рекламы. В функцию передается результат работы скрипта — объект result в формате<br>```{blocked: true/false, blocker: 'ADBLOCK_EXTENSION_ID'}```<br><br>&#8505; Примечание.<br>Время обнаружения блокировщика рекламы может быть длительным (процесс обнаружения не блокирует основной поток работы браузера), потому что часть блокировщиков начинают работу не сразу или блокируют только определенные ресурсы.


# Использование совместно с Content Security Policy (CSP)
Если вы используете какие-либо ограничения, заданные с помощью CSP, то запрос расширенной версии библиотеки может блокироваться CSP-политиками (например, директивой `connect-src`). В таком случае добавьте домен `static-mon.yandex.net` в список доверенных.
