# Настройка веб-сервера партнера

Одна из основных задач, которую решает партнер — корректная настройка веб-сервера для проксирования трафика в сервис AntiAdBlock.

>##### &#9888; Внимание.<br>
>Перед настройкой веб-сервера ознакомьтесь с [особенностями работы сервиса AntiAdblock](ABOUT.md).

В качестве сервера для проксирования рекомендуется использовать **Nginx**.

## Аутентификация на стороне сервиса
Для аутентификации партнеру выдается уникальный токен, который необходимо передавать при каждом http-запросе в заголовке `X-AAB-PartnerToken`.

Ниже описаны примеры конфигурации с использованием **Nginx**.

## Примеры конфигурации Nginx

Ссылки шифруются таким образом, что невозможно придумать правило (```location``` в терминах **Nginx**), по которому можно определить зашифрована ссылка или нет. Поэтому большинство конфигураций работает по методу «сначала искать контент у себя, а если контент не найден, то запрашивать его у прокси».

* [Использование Nginx mapping](#Использование-Nginx-mapping) <br>
* [Использование try_files](#Использование-try_files) <br>
* [Использование if](#Использование-if) <br>

### Использование Nginx mapping

Если на сайте партнера шифруются все ссылки на css, js, картинки, то можно использовать простой и удобный вариант конфигурации на базе mapping. В таком варианте практически весь трафик пользователей с AdBlock-приложением будет направлен на сервис.

```
map $cookie_bltsr:$http_x_aab_proxy:$http_x_aab_http_check:$request_method $px_backend {
  default http://local;
  ~(.+::.*:GET|POST) https://partner_antiadblock-upstream;
  ~(.*:1:.*:.*) http://local;
  ~(.*:.*:\d+:POST) https://partner_antiadblock-upstream;
}

upstream partner_antiadblock-upstream {
  server cryprox-test.yandex.net:443 max_fails=0  fail_timeout=0;
  # backup server if cryprox request failed (optional)
  server 127.0.0.1:81 backup;
  keepalive 128;
}

upstream local {
  server 127.0.0.1:81 max_fails=0  fail_timeout=0;
}

location / {
    proxy_intercept_errors on;
    proxy_cache off;
    proxy_ignore_client_abort off;
    proxy_set_header Host $host;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto  $scheme;
    proxy_set_header X-AAB-PartnerToken "PARTNER-TOKEN";
    # settings for keepalived
    proxy_http_version 1.1;
    proxy_set_header Connection "";
    
    proxy_pass_request_body on;
    proxy_pass $px_backend;
    proxy_next_upstream http_500 http_502 http_503 http_504;
    error_page 502 504 = @local;
    break;
  }

location @local {
    proxy_pass http://local;
}
```

В шапке конфигурации собирается ```mapping-key```
```$cookie_bltsr:$http_x_aab_proxy:$http_x_aab_http_check:$request_method```<br>
, где:
- ```cookie_bltsr``` — cookie, которой помечаются пользователи с AdBlock-приложением;
- ```http_x_aab_proxy``` — заголовок, который проставляет сервис, когда идет к партнеру с запросом. Используется для предотвращения перезапросов/зацикливания.
- ```http_x_aab_http_check``` — заголовок, которым подписываются служебные POST-запросы. Запросы с таким заголовком сервис умеет обрабатывать. При обработке остальных POST-запросов возвращается ошибка 405.
- ```request_method``` — сам http-метод (GET, POST). Остальные методы не поддерживаются.

На основе получившегося ключа описан сценарий проксирования — в какой upstream направлять запрос.

### Использование try_files

Если на сайте партнера шифруются не все ссылки, то необходимо выбирать, что направлять в сервис, а что нет. Для этого можно использовать метод [try_files](#Использование-try_files) из **Nginx**.

Сценарий использования:

1. Первый запрос необходимо направлять на свой сервер (backend). Если получен успешный ответ, он передается пользователю и обработка завершается.
2. Если на предыдущем шаге был получен http-код ответа 404, то необходимо направить запрос в сервис AntiAdBlock. Обработка ответа аналогична: если получен успешный ответ, он передается пользователю и обработка завершается.
3. Если сервис AntiAdBlock тоже ответил 404, следует вернуть пользователю либо http-код ответа 404, либо специальную статусную страницу партнера (логику обработки ошибки 404 партнер выбирает самостоятельно).

```
upstream partner_antiadblock-upstream {
  server cryprox-test.yandex.net:443 max_fails=0  fail_timeout=0;
  # backup server if cryprox request failed (optional)
  server 127.0.0.1:81 backup;
  keepalive 128;
}

location / {
    try_files $uri @cryprox;
}

location @cryprox {
    proxy_set_header Host $host;
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto $scheme;
    proxy_set_header X-AAB-PartnerToken "PARTNER-TOKEN";
    proxy_next_upstream http_500 http_502 http_503 http_504;
    proxy_redirect off;
    # settings for keepalived
    proxy_http_version 1.1;
    proxy_set_header Connection "";

    proxy_pass https://partner_antiadblock-upstream;
}
```

### Использование if

Если у партнера сложная конфигурация **Nginx** и перечисленные выше методы нельзя применить, то можно воспользоваться стандартными условиями.  
Стоит учесть, что [if в nginx реализован достаточно неочевидно](https://www.nginx.com/resources/wiki/start/topics/depth/ifisevil/).

>##### &#9888; Внимание.<br>
>Все ```if```, которые определяют переменную ```to_proxy```, должны находиться вне секций ```location```.

```
upstream partner_antiadblock-upstream {
  server cryprox-test.yandex.net:443 max_fails=0  fail_timeout=0;
  # backup server if cryprox request failed (optional)
  server 127.0.0.1:81 backup;
  keepalive 128;
}

set $to_proxy 0;

if ($cookie_bltsr) {
    set $to_proxy 1;
}

if ($request_method != GET) {
    set $to_proxy 0;
}

if ($http_x_aab_http_check) {
    set $to_proxy 1;
}

if ($http_x_aab_proxy) {
    set $to_proxy 0;
}

location / {
    error_page 467 = @aab;
    if ($to_proxy = 1) {
        return 467;
    }

    # some configuration

}

location @aab {
    internal;
    proxy_cache                 off;
    proxy_ignore_client_abort   off;
    proxy_set_header    Host                $host;
    proxy_set_header    X-Real-IP           $remote_addr;
    proxy_set_header    X-Forwarded-For     $proxy_add_x_forwarded_for;
    proxy_set_header    X-Forwarded-Proto   $scheme;
    proxy_set_header    X-AAB-PartnerToken "PARTNER-TOKEN";
    # settings for keepalived
    proxy_http_version 1.1;
    proxy_set_header Connection "";
    proxy_pass https://partner_antiadblock-upstream;
}
```

