# Разметка рекламных блоков параметром statId

* [Разметка statId для РСЯ](#Разметка statId для РСЯ)
* [Разметка statId для AdFox](#Разметка statId для AdFox)

## Разметка statId для РСЯ
Разметка рекламных блоков — это механизм разметки трафика (денег).
Он позволяет разметить рекламный контент, который был показан пользователям с AdBlock-приложением.
Благодаря данному механизму можно посчитать, сколько денег принес сервис AntiAdBlock для партнера.

Для пользователей с AdBlock-приложением необходимо разметить все рекламные блоки параметром statId. Подробнее про данный параметр можно почитать в документации [Рекламная сеть Яндекса](https://yandex.ru/support/partner2/web/products-rtb/partner-code.html#partner-code__statId).

Если у пользователя есть cookie, которая отвечает за наличие AdBlock-приложения, то необходимо добавлять параметр statId в рекламные блоки. Значением параметра может быть любое целое положительное число в пределах [1; 1000000000].
Пример настройки разметки:

```
<script type="text/javascript">
var blockSettings = {blockId:"R-A-12345-18",renderTo:"yandex_flat",async:!0};
if(document.cookie.indexOf("bltsr=") >= 0){
blockSettings = {blockId:"R-A-12345-18",renderTo:"yandex_flat",statId:7035018,async:!0};
}
!function(a,b,c,d,e){a[c]=a[c]||[],a[c].push(function(){Ya.Context.AdvManager.render(blockSetting s)}),e=b.getElementsByTagName("script")[0],d=b.createElement("script"),d.type="text/javascript", d.src="//an.yandex.ru/system/context.js",d.async=!0,e.parentNode.insertBefore(d,e)}(this,this.docu ment,"yandexContextAsyncCallbacks");
</script>
```
Ограничение.
1. Для всех блоков нужно использовать одинаковое значение параметра statId.
2. Если генерация кода вставки происходит в backend, а не в js-скрипте, то следует учесть: когда сервис делает запрос к партнеру, вырезается cookie, которая отвечает за наличие AdBlock-приложения.
Это делается, чтобы запрос от сервиса не был снова направлен в сервис.
Поэтому (при использовании генерации кода на backend) рекламные блоки не будут размечены параметром statId, так как в запросе нет нужной cookie.</br>
В этом случае для идентификации адблочных запросов можно использовать заголовок `x-aab-proxy`, которым помечаются такие запросы.

## Разметка statId для AdFox
Разметка statId для AdFox описана в [документации AdFox](https://sites.help.adfox.ru/page/45/#statId)