# Подключение партнеров

## Основные шаги подключения

**0. Выдача партнеру документации**

[Документацию](https://tech.yandex.ru/antiadblock/doc/concepts/adblock-detect-docpage/) надо выдать заранее, чтобы партнер успел ознакомиться с ней и задать нужные вопросы.

**1. Сбор данных по площадке**

`RPS`: кол-во запросов в секунду, оценивается как кол-во хитов (просмотров сайта в секунду), умноженное на кол-во шифруемых ресурсов.
Обычно легко оценивается через подсчет ресурсов в Network консоли браузера. Хиты можно взять из Я.Метрики.

`Ожидаемый доход от рекламы за адблоком (руб/день)`: из ПИ получаем средний доход от рекламы за день, из метрики получаем процент заадблочной аудитории
(сами или через менеджера), умножаем одно на другое и получаем минимально ожидаемые деньги за адблоком.

`Домены`: нужно получить от партнера все возможные домены прода и тестинга

`Рекламные системы`: какие рекламные системы используются (речь о Яндексовых, конечно) - Директ, Адфокс. Есть ли какие-то нюансы?

**2. Создание тикета**

Создание тикета на базе собранных данных. Пример: https://st.yandex-team.ru/ANTIADB-527

**3. Создание конфига**

Создаем конфиг в [админке](https://antiblock.yandex.ru/) <br>
Настраиваем в соответствии с полученными данными

**4. Выдача данных для подключения партнеру**

Партнеру выдается токен, сгенерированный в конфиге, и `PID` для скрипта детекта. `PID` - поле `id` в разделе `Информация`.<br>
Ждем, пока партнер настроит проксирование. 

**5. Тестирование**

Тестирование на тестинге партнера. Проверка всех фич. Далее приемка тестинга (ниже об этом раздел).

**6. Выкатка в прод**

Выкатываемся в прод.

## Приемка тестинга перед запуском в прод

Перед тем, как запускать Антиадблок на продакшене партнера, нужно на тестинге провести ряд проверок, чтобы 
убедиться, что в первые же часы подключения не будут написаны правила, которые будет трудно обойти не жертвуя 
какой-то фукциональностью Антиадблока.

Итак, что нужно сделать перед запуском в прод?

#### Включить общие фичи

**Шифрование html-тегов** - включить шифрование тегов, чтобы пошифровать все `div`-ы и усложнить написание простейших правил.
**Шифрование скриптов** - как загружаемых, так и inline, нужно включить обе фичи. Это защитит подмену содержимого скриптов Адгардом,
и усложнит анализ рекламных ссылок другим блокировщикам.
**Зафиксировать длину ссылок** - для этого нужно включить две фичи -  `Передавать часть параметров на рекламный аукцион через заголовок`,
что позволит сократить длинные запросы на розыгрыш до нужной длины + проставить `Минимальная длина шифрованных ссылок` в значение 500-1000.
Таким образом все ссылки на странице партнера будут иметь не только одинаковый вид, но и одинаковую длину.

#### Далее нужно обязательно

**Проверить как вставлен скрипт детекта**

Он обязательно должен быть вставлен так, как описано в [документации](https://tech.yandex.ru/antiadblock/doc/concepts/adblock-detect-docpage/),
 - в тело другого важного инлайн скрипта, либо внутри другого важного загружаемого скрипта. Не отдельным инлайном 
 или отдельным загружаемым скриптом.

**Защитить скрипты**

Inline и загружаемые. Почему это важно: вставка рекламы происходит с помощью инлайн-скриптов. Если у партнера нет своих 
инлайн скриптов, то запросы за рекламой легко блокируются правилами на CSP - запрет на исполнение инлайн-скриптов. 
С загружаемыми скриптами аналогично - большинство библиотек показывающего кода загружаются по ссылкам. 
Если у партнера нет своих скриптов, то можно легко запретить загрузку всех скриптов на сайте, не сломав его.

**Защитить XHR-запросы**

Запросы на розыгрыш рекламы и события о разблоке (`bamboozled`) отправляются по-умолчанию с помощью `XHR` ([XMLHttpRequest](https://ru.wikipedia.org/wiki/XMLHttpRequest)).
Чтобы предотвратить их блокировку необходимо сделать так, чтобы при блокировании XHR сайт ломался, либо терял часть важной функциональности.
Для этого достаточно найти на странице партнера XHR, посмотреть, можно ли их пошифровать, и что сломается, если их заблокировать.
Для защиты не подходят XHR-запросы, которые склеиваются в JS на стороне клиента, так как они будут явно отличаться от рекламных.
Например, запрос `http://domain.com/jdhd76sdh/sdj7dhKhjssoidKJSheruieh?page=1&category=cats` можно легко найти по квери-аргам,
и написать правило, блокирующее все XHR, кроме тех, что содержат кварги `page` и/или `cats`.
Если таких запросов нет, шифровать нечего совсем, то у нас есть фичи, которые делают XHR-запросы из тегов script и css: 
[ANTIADB-1369 (CSS)](https://st.yandex-team.ru/ANTIADB-1369) и [ANTIADB-1255 (SCRIPT)](https://st.yandex-team.ru/ANTIADB-1255).
То есть нужно найти скрипты, которые можно загрузить через XHR, если не удалось - CSS.

**Защитить IFRAME**

В Iframe отрисовывается почти вся медийная реклама - самая доходная реклама РСЯ. Как правило, у партнера нет своих iframe,
src которых можно пошифровать, что позволяет блокировщикам заблокировать просто все iframe на сайте, лишив его медийной рекламы,
при этом ничего не сломав для пользователей.
Если у партнера на сайте нет iframe-ов совсем, то мы их можем сделать сами из картинок с помощью фичи замены тегов `<img />` на 
`<iframe />`. Фича описана тут: [ANTIADB-1250](https://st.yandex-team.ru/ANTIADB-1250).

В админке выглядит так:

![](https://jing.yandex-team.ru/files/lawyard/Antiblock_2018-11-29_18-11-29.png)

Если у партнера есть свои iframe с видео-плеерами, то нужно пошифровать на них src и сразу настроить редирект на эти урлы, чтобы
прокси не пыталась ходить по ним и выкачивать видео, а отдавала пользователю редирект на расшифрованную ссылку. Пример настройки:

![](https://jing.yandex-team.ru/files/lawyard/Antiblock_2018-11-29_16-51-58.png)

#### Финальная проверка

После всех проверок выше нужно пробежаться глазами по верстке и посмотреть на блоки, куда вставлена реклама, - они не должны
выделяться среди остальных блоков, то есть, например, не должны содержать всяких классов и id вида `direct`, `ads`, `banner` и тп.
Если содержат, то их надо пошифровать, либо попросить партнера их на что-то заменить, если их шифрование невозможно.

Также убедиться, что блоки, куда будет вставлена реклама, не содержат атрибута `style`, так как за него легко зацепиться правилом.
Стили из атрибута надо перенести в класс.

### Итог

Минимальный перечень того, что надо проверить (своего рода чеклист):

* Включить шифрование html-тегов
* Включить шифрование скриптов
* Зафиксировать длину ссылок + включить передачу параметров на розыгрыш через заголовок
* Проверить вставку скрипта детекта
* Проверить защиту скриптов
* Проверить защиту XHR (сделать их, если нет)
* Проверить защиту Iframe (сделать их, если нет)
* Проверить верстку на банальные уязвимости: названия классов, айди и наличие стилей.

### Правила для проверки

Для проверки работы включенных фич и шифрования имеет смысл попробовать применить типовые правила, 
которыми пользуется AdblockPlus. Правила добавляются в настройках блокировщика в разделе `Расширенные > Мой список фильтров`

Типовые правила для проверки защиты рекламы с помощью фич:

```javascript
# Запрет всех inline-скриптов:
||test.ru^$csp=script-src 'self' * data:

# разрешение inline и запрет eval (правило на fb и syl 04.12.2018):
||test.ru^$csp=script-src 'self' * 'unsafe-inline' data:

# запрет ShadowDom:
test.ru#$#hide-if-shadow-contains *

# запрет всех загружаемых скриптов, ссылки на которые длиннее 300 символов:
/^https?://test\.ru/[^\s]{300,}/$script,domain=test.ru

# запрет всех XHR, ссылки на которые длиннее 300 символов:
/^https?://test\.ru/[^\s]{300,}/$xmlhttprequest,domain=test.ru

# запрет всех subdocument (iframe), ссылки на которые длиннее 300 символов:
/^https?://test\.ru/[^\s]{300,}/$subdocument,domain=test.ru

# запрет только внутренних ссылок (правило на yandex_pogoda 04.12.2018):
/^https?://test\.ru/[^\s]{300,}/$subdocument,~third-party,xmlhttprequest

# скрытие по слову "Реклама" (правило на drive2 04.12.2018):
test.ru#?#*:-abp-has(> *:-abp-contains(/^реклама$/i))

# запрет всех iframe на уровне верстки:
test.ru##iframe[src*="//test.ru"]
test.ru#?#body *:-abp-has(> iframe[src*="//test.ru/"])

# запрет ссылок c target:
test.ru##a[href*="//test.ru"][target]
test.ru#?#body *:-abp-has(> a[href*="//test.ru"][target])

# последние правила могут дублироваться для обхода `div-shield`:
test.ru##iframe[src*="test.ru"]
test.ru##a[href*="//test.ru"][target]
test.ru#?#body *:-abp-has(> * > * > * > * > iframe[src*="test.ru"])
test.ru#?#body *:-abp-has(> * > * > * > a[href*="//test.ru"][target])
test.ru#?#body *:-abp-has(> * > * > * > div[id^="sf-"])
test.ru#?#body *:-abp-has(> * > * > * > iframe[src*="test.ru"])
test.ru#?#body *:-abp-has(> * > * > a[href*="//test.ru"][target])
test.ru#?#body *:-abp-has(> * > * > div[id^="sf-"])
test.ru#?#body *:-abp-has(> * > * > iframe[src*="test.ru"])
test.ru#?#body *:-abp-has(> * > a[href*="//test.ru"][target])
test.ru#?#body *:-abp-has(> * > div[id^="sf-"])
test.ru#?#body *:-abp-has(> * > iframe[src*="test.ru"])
test.ru#?#body *:-abp-has(> a[href*="//test.ru"][target])
test.ru#?#body *:-abp-has(> div[id^="sf-"])
test.ru#?#body *:-abp-has(> iframe[src*="test.ru"])

# если правила скрывают часть полезного контента на сайте, то можно их сузить:
test.ru#?#body :-abp-has(> * > * > * > a[href="//test.ru"][target] * *)
test.ru#?#body :-abp-has(> * > * > * > a[href="//test.ru"][target] img)
```

Ожидаемый результат применения правил - поломка сайта, либо какой-то его функциональности.

### Прочее

Настоятельно рекомендуется ознакомиться с разделом [FAQ](KB/FAQ.md), так как в нем изложены частые проблемные кейсы.
