#pragma once

#include "classificator.h"
#include "cookie_names.h"
#include "json_config.h"
#include "request_params.h"

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/hash.h>

#include <antirobot/idl/antirobot.ev.pb.h>

/**
 * Notes:
 * У каждой фичи есть имя
 * Формула, обученная на каки-то фичах, хранит в себе этот список в виде строк
 * При загрузке формулы в память, имена конвертируются в индексы
 */

namespace NAntiRobot {

    enum class ECacherFactors {
        NumDocs             /* "NumDocs" */,
        PageNum             /* "PageNum" */,
        HeadersCount        /* "HeadersCount" */,
        IsProxy             /* "IsProxy" */,
        IsTor               /* "IsTor" */,
        IsVpn               /* "IsVpn" */,
        IsHosting           /* "IsHosting" */,
        RefererFromYandex   /* "RefererFromYandex" */,
        IsBadProtocol       /* "IsBadProtocol" */,
        IsBadUserAgent      /* "IsBadUserAgent" */,
        IsBadUserAgentNew   /* "IsBadUserAgentNew" */,
        IsConnectionKeepAlive   /* "IsConnectionKeepAlive" */,
        HaveUnknownHeaders      /* "HaveUnknownHeaders" */,

        IpSubnetMatch       /* "IpSubnetMatch" */,
        SpravkaLifetime     /* "SpravkaLifetime" */,
        FraudJa3            /* "FraudJa3" */,
        FraudSubnet         /* "FraudSubnet" */,
        FraudSubnetNew      /* "FraudSubnetNew" */,

        SecFetchDest                    /* "SecFetchDest" */,
        AcceptLanguage                  /* "AcceptLanguage" */,
        Cookie                          /* "Cookie" */,
        UpgradeInsecureRequests         /* "UpgradeInsecureRequests" */,
        AcceptEncoding                  /* "AcceptEncoding" */,
        Dnt                             /* "Dnt" */,
        Origin                          /* "Origin" */,
        UserAgent                       /* "UserAgent" */,
        Host                            /* "Host" */,
        Referer                         /* "Referer" */,
        Authority                       /* "Authority" */,
        CacheControl                    /* "CacheControl" */,
        XForwardedProto                 /* "XForwardedProto" */,
        KeepAlive                       /* "KeepAlive" */,
        Pragma                          /* "Pragma" */,
        ProxyConnection                 /* "ProxyConnection" */,
        Rtt                             /* "Rtt" */,
        ChromeHodor                     /* "ChromeHodor" */,

        CgiParamText        /* "CgiParamText" */,
        CgiParamLr          /* "CgiParamLr" */,
        CgiParamClid        /* "CgiParamClid" */,
        CgiParamTld         /* "CgiParamTld" */,
        CgiParamUrl         /* "CgiParamUrl" */,
        CgiParamSite        /* "CgiParamSite" */,
        CgiParamLang        /* "CgiParamLang" */,

        CookieL             /* "CookieL" */,
        CookieMy            /* "CookieMy" */,
        CookieSessionId     /* "CookieSessionId" */,
        CookieYabsFrequency /* "CookieYabsFrequency" */,
        CookieYandexLogin   /* "CookieYandexLogin" */,
        CookieYandexuid     /* "CookieYandexuid" */,
        CookieYs            /* "CookieYs" */,
        CookieFuid01        /* "CookieFuid01" */,

        HeaderAcceptEncoding    /* "HeaderAcceptEncoding" */,
        HeaderAcceptLanguage    /* "HeaderAcceptLanguage" */,
        HeaderAuthorization     /* "HeaderAuthorization" */,
        HeaderCacheControl      /* "HeaderCacheControl" */,
        HeaderCookie            /* "HeaderCookie" */,
        HeaderConnection        /* "HeaderConnection" */,
        HeaderContentLength     /* "HeaderContentLength" */,
        HeaderContentType       /* "HeaderContentType" */,
        HeaderReferer           /* "HeaderReferer" */,
        HeaderUserAgent         /* "HeaderUserAgent" */,
        HeaderXForwardedFor     /* "HeaderXForwardedFor" */,

        InRobotSet              /* "InRobotSet" */,
        HasValidSpravka         /* "HasValidSpravka" */,

        IsRobot                  /* "IsRobot" */,
        IsMobile                 /* "IsMobile" */,
        IsBrowser                /* "IsBrowser" */,
        HistorySupport           /* "HistorySupport" */,
        IsEmulator               /* "IsEmulator" */,
        IsBrowserEngine          /* "IsBrowserEngine" */,
        IsBrowserEngineVersion   /* "IsBrowserEngineVersion" */,
        IsBrowserVersion         /* "IsBrowserVersion" */,
        IsOSName                 /* "IsOSName" */,
        IsOSVersion              /* "IsOSVersion" */,
        IsOSFamily               /* "IsOSFamily" */,
        IsOSFamilyAndroid        /* "IsOSFamilyAndroid" */,
        IsOSFamilyWindows        /* "IsOSFamilyWindows" */,
        IsOSFamilyiOS            /* "IsOSFamilyiOS" */,
        IsOSFamilyMacOS          /* "IsOSFamilyMacOS" */,
        IsOSFamilyLinux          /* "IsOSFamilyLinux" */,
        ITP                      /* "ITP" */,
        ITPFakeCookie            /* "ITPFakeCookie" */,
        localStorageSupport      /* "localStorageSupport" */,

        P0fOlen                     /* "P0fOlen" */,
        P0fVersion                  /* "P0fVersion" */,
        P0fObservedTTL              /* "P0fObservedTTL" */,

        P0fEOL                      /* "P0fEOL" */,
        P0fITTLDistance             /* "P0fITTLDistance" */,
        P0fUnknownOptionID          /* "P0fUnknownOptionID" */,

        P0fMSS                      /* "P0fMSS" */,
        P0fWSize                    /* "P0fWSize" */,
        P0fScale                    /* "P0fScale" */,

        P0fLayoutNOP                /* "P0fLayoutNOP" */,
        P0fLayoutMSS                /* "P0fLayoutMSS" */,
        P0fLayoutWS                 /* "P0fLayoutWS" */,
        P0fLayoutSOK                /* "P0fLayoutSOK" */,
        P0fLayoutSACK               /* "P0fLayoutSACK" */,
        P0fLayoutTS                 /* "P0fLayoutTS" */,

        P0fQuirksDF                 /* "P0fQuirksDF" */,
        P0fQuirksIDp                /* "P0fQuirksIDp" */,
        P0fQuirksIDn                /* "P0fQuirksIDn" */,
        P0fQuirksECN                /* "P0fQuirksECN" */,
        P0fQuirks0p                 /* "P0fQuirks0p" */,
        P0fQuirksFlow               /* "P0fQuirksFlow" */,
        P0fQuirksSEQn               /* "P0fQuirksSEQn" */,
        P0fQuirksACKp               /* "P0fQuirksACKp" */,
        P0fQuirksACKn               /* "P0fQuirksACKn" */,
        P0fQuirksUPTRp              /* "P0fQuirksUPTRp" */,
        P0fQuirksURGFp              /* "P0fQuirksURGFp" */,
        P0fQuirksPUSHFp             /* "P0fQuirksPUSHFp" */,
        P0fQuirksTS1n               /* "P0fQuirksTS1n" */,
        P0fQuirksTS2p               /* "P0fQuirksTS2p" */,
        P0fQuirksOPTp               /* "P0fQuirksOPTp" */,
        P0fQuirksEXWS               /* "P0fQuirksEXWS" */,
        P0fQuirksBad                /* "P0fQuirksBad" */,

        P0fPClass                   /* "P0fPClass" */,

        Ja3TlsVersion   			 /* "Ja3TlsVersion" */,
        Ja3CiphersLen      			 /* "Ja3CiphersLen" */,
        Ja3ExtensionsLen			 /* "Ja3ExtensionsLen" */,
        Ja3C159         			 /* "Ja3C159" */,
        Ja3C57_61       			 /* "Ja3C57_61" */,
        Ja3C53          			 /* "Ja3C53" */,
        Ja3C60_49187    			 /* "Ja3C60_49187" */,
        Ja3C53_49187    			 /* "Ja3C53_49187" */,
        Ja3C52393_103   			 /* "Ja3C52393_103" */,
        Ja3C49162         			 /* "Ja3C49162" */,
        Ja3C50          			 /* "Ja3C50" */,
        Ja3C51          			 /* "Ja3C51" */,
        Ja3C255         			 /* "Ja3C255" */,
        Ja3C52392       			 /* "Ja3C52392" */,
        Ja3C10          			 /* "Ja3C10" */,
        Ja3C157_49200   			 /* "Ja3C157_49200" */,
        Ja3C49171_103   			 /* "Ja3C49171_103" */,
        Ja3C49200          			 /* "Ja3C49200" */,
        Ja3C49191_52394 			 /* "Ja3C49191_52394" */,
        Ja3C49192_52394 			 /* "Ja3C49192_52394" */,
        Ja3C65_52394    			 /* "Ja3C65_52394" */,
        Ja3C157         			 /* "Ja3C157" */,
        Ja3C52393_49200 			 /* "Ja3C52393_49200" */,
        Ja3C49159       			 /* "Ja3C49159" */,
        Ja3C4865        			 /* "Ja3C4865" */,
        Ja3C158_61      			 /* "Ja3C158_61" */,
        Ja3C49196_47    			 /* "Ja3C49196_47" */,
        Ja3C103          			 /* "Ja3C103" */,
        Ja3C103_49196   			 /* "Ja3C103_49196" */,
        Ja3C52393_49188 			 /* "Ja3C52393_49188" */,
        Ja3C60_65          			 /* "Ja3C60_65" */,
        Ja3C49195_69    			 /* "Ja3C49195_69" */,
        Ja3C154         			 /* "Ja3C154" */,
        Ja3C49187_49188 			 /* "Ja3C49187_49188" */,
        Ja3C49199_60    			 /* "Ja3C49199_60" */,
        Ja3C49195_51    			 /* "Ja3C49195_51" */,
        Ja3C49235       			 /* "Ja3C49235" */,
        Ja3C47          			 /* "Ja3C47" */,
        Ja3C49169       			 /* "Ja3C49169" */,
        Ja3C49249       			 /* "Ja3C49249" */,
        Ja3C49171_60       			 /* "Ja3C49171_60" */,
        Ja3C49188_49196 			 /* "Ja3C49188_49196" */,
        Ja3C61          			 /* "Ja3C61" */,
        Ja3C156_255     			 /* "Ja3C156_255" */,
        Ja3C47_57       			 /* "Ja3C47_57" */,
        Ja3C186         			 /* "Ja3C186" */,
        Ja3C49245       			 /* "Ja3C49245" */,
        Ja3C156_52394   			 /* "Ja3C156_52394" */,
        Ja3C20          			 /* "Ja3C20" */,
        Ja3C49188_49195 			 /* "Ja3C49188_49195" */,
        Ja3C52394_52392 			 /* "Ja3C52394_52392" */,
        Ja3C53_49162    			 /* "Ja3C53_49162" */,
        Ja3C49191       			 /* "Ja3C49191" */,
        Ja3C49245_49249 			 /* "Ja3C49245_49249" */,
        Ja3C49171       			 /* "Ja3C49171" */,
        Ja3C53_52393    			 /* "Ja3C53_52393" */,
        Ja3C51_49199    			 /* "Ja3C51_49199" */,
        Ja3C49234         			 /* "Ja3C49234" */,
        Ja3C49315         			 /* "Ja3C49315" */,
        Ja3C158         			 /* "Ja3C158" */,
        Ja3C49187_49161 			 /* "Ja3C49187_49161" */,
        Ja3C107         			 /* "Ja3C107" */,
        Ja3C52394       			 /* "Ja3C52394" */,
        Ja3C49162_61    			 /* "Ja3C49162_61" */,
        Ja3C153         			 /* "Ja3C153" */,
        Ja3C49170       			 /* "Ja3C49170" */,
        Ja3C156         			 /* "Ja3C156" */,
        Ja3C52393_60    			 /* "Ja3C52393_60" */,
        Ja3C49195_49192 			 /* "Ja3C49195_49192" */,
        Ja3C7           			 /* "Ja3C7" */,
        Ja3C49187_103   			 /* "Ja3C49187_103" */,
        Ja3C61_49172    			 /* "Ja3C61_49172" */,
        Ja3C159_49188   			 /* "Ja3C159_49188" */,
        Ja3C49171_49187 			 /* "Ja3C49171_49187" */,
        Ja3C49196_49188 			 /* "Ja3C49196_49188" */,
        Ja3C158_49161   			 /* "Ja3C158_49161" */,
        Ja3C49193       			 /* "Ja3C49193" */,

        AcceptUniqueKeysNumber              /* "AcceptUniqueKeysNumber" */,
        AcceptEncodingUniqueKeysNumber      /* "AcceptEncodingUniqueKeysNumber" */,
        AcceptCharsetUniqueKeysNumber       /* "AcceptCharsetUniqueKeysNumber" */,
        AcceptLanguageUniqueKeysNumber      /* "AcceptLanguageUniqueKeysNumber" */,
        AcceptAnySpace                      /* "AcceptAnySpace" */,
        AcceptEncodingAnySpace              /* "AcceptEncodingAnySpace" */,
        AcceptCharsetAnySpace               /* "AcceptCharsetAnySpace" */,
        AcceptLanguageAnySpace              /* "AcceptLanguageAnySpace" */,
        AcceptLanguageHasRussian            /* "AcceptLanguageHasRussian" */,

        MarketJwsStateIsDefaultExpiredRatio       /* "MarketJwsStateIsDefaultExpiredRatio" */,
        MarketJwsStateIsDefaultRatio              /* "MarketJwsStateIsDefaultRatio" */,
        MarketJwsStateIsInvalidRatio              /* "MarketJwsStateIsInvalidRatio" */,
        MarketJwsStateIsSuspExpiredRatio          /* "MarketJwsStateIsSuspExpiredRatio" */,
        MarketJwsStateIsSuspRatio                 /* "MarketJwsStateIsSuspRatio" */,
        MarketJwsStateIsValidExpiredRatio         /* "MarketJwsStateIsValidExpiredRatio" */,
        MarketJwsStateIsValidRatio                /* "MarketJwsStateIsValidRatio" */,

        MarketJa3BlockedCntRatio                /* "MarketJa3BlockedCntRatio" */,
        MarketJa3CatalogReqsCntRatio            /* "MarketJa3CatalogReqsCntRatio" */,
        MarketJa3EnemyCntRatio                  /* "MarketJa3EnemyCntRatio" */,
        MarketJa3EnemyRedirectsCntRatio         /* "MarketJa3EnemyRedirectsCntRatio" */,
        MarketJa3FuidCntRatio                   /* "MarketJa3FuidCntRatio" */,
        MarketJa3HostingCntRatio                /* "MarketJa3HostingCntRatio" */,
        MarketJa3IcookieCntRatio                /* "MarketJa3IcookieCntRatio" */,
        MarketJa3Ipv4CntRatio                   /* "MarketJa3Ipv4CntRatio" */,
        MarketJa3Ipv6CntRatio                   /* "MarketJa3Ipv6CntRatio" */,
        MarketJa3LoginCntRatio                  /* "MarketJa3LoginCntRatio" */,
        MarketJa3MobileCntRatio                 /* "MarketJa3MobileCntRatio" */,
        MarketJa3OtherHandlesReqsCntRatio       /* "MarketJa3OtherHandlesReqsCntRatio" */,
        MarketJa3ProductReqsCntRatio            /* "MarketJa3ProductReqsCntRatio" */,
        MarketJa3ProxyCntRatio                  /* "MarketJa3ProxyCntRatio" */,
        MarketJa3RefererIsEmptyCntRatio         /* "MarketJa3RefererIsEmptyCntRatio" */,
        MarketJa3RefererIsNotYandexCntRatio     /* "MarketJa3RefererIsNotYandexCntRatio" */,
        MarketJa3RefererIsYandexCntRatio        /* "MarketJa3RefererIsYandexCntRatio" */,
        MarketJa3RobotsCntRatio                 /* "MarketJa3RobotsCntRatio" */,
        MarketJa3SearchReqsCntRatio             /* "MarketJa3SearchReqsCntRatio" */,
        MarketJa3SpravkaCntRatio                /* "MarketJa3SpravkaCntRatio" */,
        MarketJa3TorCntRatio                    /* "MarketJa3TorCntRatio" */,
        MarketJa3VpnCntRatio                    /* "MarketJa3VpnCntRatio" */,
        MarketJa3YndxIpCntRatio                 /* "MarketJa3YndxIpCntRatio" */,

        MarketSubnetBlockedCntRatio                /* "MarketSubnetBlockedCntRatio" */,
        MarketSubnetCatalogReqsCntRatio            /* "MarketSubnetCatalogReqsCntRatio" */,
        MarketSubnetEnemyCntRatio                  /* "MarketSubnetEnemyCntRatio" */,
        MarketSubnetEnemyRedirectsCntRatio         /* "MarketSubnetEnemyRedirectsCntRatio" */,
        MarketSubnetFuidCntRatio                   /* "MarketSubnetFuidCntRatio" */,
        MarketSubnetHostingCntRatio                /* "MarketSubnetHostingCntRatio" */,
        MarketSubnetIcookieCntRatio                /* "MarketSubnetIcookieCntRatio" */,
        MarketSubnetIpv4CntRatio                   /* "MarketSubnetIpv4CntRatio" */,
        MarketSubnetIpv6CntRatio                   /* "MarketSubnetIpv6CntRatio" */,
        MarketSubnetLoginCntRatio                  /* "MarketSubnetLoginCntRatio" */,
        MarketSubnetMobileCntRatio                 /* "MarketSubnetMobileCntRatio" */,
        MarketSubnetOtherHandlesReqsCntRatio       /* "MarketSubnetOtherHandlesReqsCntRatio" */,
        MarketSubnetProductReqsCntRatio            /* "MarketSubnetProductReqsCntRatio" */,
        MarketSubnetProxyCntRatio                  /* "MarketSubnetProxyCntRatio" */,
        MarketSubnetRefererIsEmptyCntRatio         /* "MarketSubnetRefererIsEmptyCntRatio" */,
        MarketSubnetRefererIsNotYandexCntRatio     /* "MarketSubnetRefererIsNotYandexCntRatio" */,
        MarketSubnetRefererIsYandexCntRatio        /* "MarketSubnetRefererIsYandexCntRatio" */,
        MarketSubnetRobotsCntRatio                 /* "MarketSubnetRobotsCntRatio" */,
        MarketSubnetSearchReqsCntRatio             /* "MarketSubnetSearchReqsCntRatio" */,
        MarketSubnetSpravkaCntRatio                /* "MarketSubnetSpravkaCntRatio" */,
        MarketSubnetTorCntRatio                    /* "MarketSubnetTorCntRatio" */,
        MarketSubnetVpnCntRatio                    /* "MarketSubnetVpnCntRatio" */,
        MarketSubnetYndxIpCntRatio                 /* "MarketSubnetYndxIpCntRatio" */,

        MarketUABlockedCntRatio                /* "MarketUABlockedCntRatio" */,
        MarketUACatalogReqsCntRatio            /* "MarketUACatalogReqsCntRatio" */,
        MarketUAEnemyCntRatio                  /* "MarketUAEnemyCntRatio" */,
        MarketUAEnemyRedirectsCntRatio         /* "MarketUAEnemyRedirectsCntRatio" */,
        MarketUAFuidCntRatio                   /* "MarketUAFuidCntRatio" */,
        MarketUAHostingCntRatio                /* "MarketUAHostingCntRatio" */,
        MarketUAIcookieCntRatio                /* "MarketUAIcookieCntRatio" */,
        MarketUAIpv4CntRatio                   /* "MarketUAIpv4CntRatio" */,
        MarketUAIpv6CntRatio                   /* "MarketUAIpv6CntRatio" */,
        MarketUALoginCntRatio                  /* "MarketUALoginCntRatio" */,
        MarketUAMobileCntRatio                 /* "MarketUAMobileCntRatio" */,
        MarketUAOtherHandlesReqsCntRatio       /* "MarketUAOtherHandlesReqsCntRatio" */,
        MarketUAProductReqsCntRatio            /* "MarketUAProductReqsCntRatio" */,
        MarketUAProxyCntRatio                  /* "MarketUAProxyCntRatio" */,
        MarketUARefererIsEmptyCntRatio         /* "MarketUARefererIsEmptyCntRatio" */,
        MarketUARefererIsNotYandexCntRatio     /* "MarketUARefererIsNotYandexCntRatio" */,
        MarketUARefererIsYandexCntRatio        /* "MarketUARefererIsYandexCntRatio" */,
        MarketUARobotsCntRatio                 /* "MarketUARobotsCntRatio" */,
        MarketUASearchReqsCntRatio             /* "MarketUASearchReqsCntRatio" */,
        MarketUASpravkaCntRatio                /* "MarketUASpravkaCntRatio" */,
        MarketUATorCntRatio                    /* "MarketUATorCntRatio" */,
        MarketUAVpnCntRatio                    /* "MarketUAVpnCntRatio" */,
        MarketUAYndxIpCntRatio                 /* "MarketUAYndxIpCntRatio" */,

        AutoruJa3               /* "AutoruJa3" */,
        AutoruSubnet            /* "AutoruSubnet" */,
        AutoruUA                /* "AutoruUA" */,

        HasCookieAmcuid                /* "HasCookieAmcuid" */,
        HasCookieCurrentRegionId       /* "HasCookieCurrentRegionId" */,
        HasCookieCycada                /* "HasCookieCycada" */,
        HasCookieLocalOffersFirst      /* "HasCookieLocalOffersFirst" */,
        HasCookieLr                    /* "HasCookieLr" */, 
        HasCookieMarketYs              /* "HasCookieMarketYs" */, 
        HasCookieOnstock               /* "HasCookieOnstock" */, 
        HasCookieYandexHelp            /* "HasCookieYandexHelp" */,
        HasCookieCmpMerge              /* "HasCookieCmpMerge" */, 
        HasCookieComputer              /* "HasCookieComputer" */, 
        HasCookieHeadBaner             /* "HasCookieHeadBaner" */,
        HasCookieUtmSource             /* "HasCookieUtmSource" */,

        CookieYoungerThanMinute            /* "CookieYoungerThanMinute" */,
        CookieYoungerThanHour              /* "CookieYoungerThanHour" */,
        CookieYoungerThanDay               /* "CookieYoungerThanDay" */,
        CookieYoungerThanWeek              /* "CookieYoungerThanWeek" */,
        CookieYoungerThanMonth             /* "CookieYoungerThanMonth" */,
        CookieYoungerThanThreeMonthes      /* "CookieYoungerThanThreeMonthes" */,
        CookieOlderThanMonth               /* "CookieOlderThanMonth" */,
        CookieOlderThanThreeMonthes        /* "CookieOlderThanThreeMonthes" */,

        NumStaticFactors,
    };

    struct TCacherRequestFeatures;

    struct TRawCacherFactors {
		TRawCacherFactors()
			: Factors(NumFactors())
        {}

		TCacherLinearizedFactors Factors;

        static size_t NumFactors() {
            return
                static_cast<size_t>(ECacherFactors::NumStaticFactors) +
                ANTIROBOT_DAEMON_CONFIG.GlobalJsonConfig.LastVisitsRules.size();
        }

        static size_t GetIndexByName(const TString& name);

        void FillCacherRequestFeatures(const TCacherRequestFeatures& cacherFeatures);
    };

    void FillCacherFactors(NAntirobotEvClass::TCacherFactors& cf, const TCacherRequestFeatures& features, float result, float threshold);

} // namespace NAntiRobot
