# Антиробот для AJAX-запросов

Вы можете подключить к Антироботу сервис, поддерживающий AJAX-запросы, если сервис может выполнять редирект на стандартную страницу капчи или формировать такую страницу самостоятельно.

Антиробот анализирует поступивший AJAX-запрос и определяет, кто его задал: 
- человек — запрос передается в бэкенд сервиса (см. раздел [Прохождение запроса при использовании Антиробота](scheme.md) пункт [Схема <q>Человек</q>](scheme.md#human));
- робот — Антиробот возвращает сервису [ответ](#answer) в формате `json` (см. раздел [Прохождение запроса при использовании Антиробота](scheme.md) пункт [Схема <q>Капча для AJAX-запросов</q>](scheme.md#ajax)).

Способ предоставления капчи пользователю ([редирект](#redirect) или [кастомная верстка](#custom)) вы выбираете самостоятельно исходя из ваших предпочтений и возможностей сервиса.

## Формат ответа Антиробота {#answer}

Антиробот возвращает сервису ответ в формате `json`. Формат ответа одинаков для обоих вариантов предоставления капчи:

```json
{
      "type": captcha,
      "captcha": {
          "img-url": "$IMG_URL",
          "key": "$KEY",
          "status": "$STATUS",
          "captcha-page": "$CAPTCHA_PAGE"
      }
}
```
**Название параметра:** `img-url`

**Описание:** 
URL картинки для формирования страницы капчи.


**Название параметра:** `key`

**Описание:** 
Ключ картинки для проверки введенной капчи.


**Название параметра:** `status`

**Описание:** 
Статус капчи. Возможные значения:
- <пустая строка> — в рамках запроса капча возвращается впервые;
- failed — капча возвращается в ответ на неправильно введенную капчу.


**Название параметра:** `captcha-page`

**Описание:** 
URL для редиректа на страницу капчи.


Если в исходном запросе присутствует заголовок `Origin: <some domain>`, в ответе Антиробота вернется заголовок `Access-Control-Allow-Origin: *`.

## Настройка редиректа на страницу капчи {#redirect}

Обеспечьте выполнение редиректа на стандартную страницу капчи. URL страницы возвращается в [теле ответа](#answer) Антиробота в параметре **captcha-page**.

Если после ввода капчи нужно перенаправить пользователя на URL, отличный от исходного, настройте передачу нового URL в заголовке `X-Retpath-Y` исходного запроса.

После правильного ввода капчи Антиробот выдает пользователю справку, с которой будет выполнен обратный редирект, но уже не на JSON-, а на HTML-страницу (из **retpath** Антиробот удаляет CGI-параметры **callback** и **ajax**).

Подробную схему прохождения AJAX-запроса см. в разделе [Прохождение запроса при использовании Антиробота](scheme.md#ajax-rdr).

> # Пример cрабатывания редиректа
> 
> Редирект на страницу капчи был выполнен по запросу:
> 
> ```
> GET /search?text=123&callback=jQuery123&ajax=1 HTTP/1.1
> Host: yandex.ru
> ```
> 
> После успешного ввода капчи будет выполнен обратный редирект на [https://yandex.ru/search?text=123](https://yandex.ru/search?text=123).
> 
> Редирект на страницу капчи был выполнен по запросу:
> 
> ```
> GET /search?text=123&callback=jQuery123&ajax=1 HTTP/1.1
> Host: yandex.ru
> X-Retpath-Y: https://auto.ru
> ```
> 
> После успешного ввода капчи будет выполнен редирект на [https://auto.ru](https://auto.ru).

Справка (spravka) — уникальная кука, которую Антиробот выставляет пользователю при прохождении капчи. Справка считается отдельным идентификатором, а пользователь с ней — отдельным пользователем. Справка дает пользователю несколько гарантированных запросов, за которые он не будет забанен, даже если Антиробот признает пользователя роботом.

## Настройка кастомной верстки капчи {#custom}

Порядок действий:

1. Обеспечьте формирование собственной страницы с капчей и просьбой ввести текст, изображенный на картинке. URL картинки и ключ для проверки введенной капчи возвращается в [теле ответа](#answer) Антиробота в параметрах **img-url** и **key**.
    
1. Настройте скрипт, который после ввода капчи пользователем будет отправлять Антироботу запрос вида:
    
    ```
    https://$DOMAIN/checkcaptchajson?key=$KEY&rep=$REP
    ```
    
    Параметры:
    `$DOMAIN` — домен сервиса на который пришел пользователь (включая поддомены). Например, для России это `afisha.yandex.ru`, а для Украины `afisha.yandex.ua`
    `$KEY` — ключ для проверки капчи (**key**), [полученный от Антиробота](#answer).
    `$REP` — символы, введенные пользователем.
    
1. Установите счетчик метрики 10630330 на страницу с капчей.
    
После правильного ввода капчи Антиробот возвращает сервису ответ в формате `json`:
```
{
   "type": captcha,
   "captcha": {
      "status": "success"
   },
   "spravka": <значение справки>
}
```

Сервис формирует новый AJAX-запрос и выставляет значение справки в качестве куки `spravka`.

Подробную схему прохождения AJAX-запроса см. в разделе [Прохождение запроса при использовании Антиробота](scheme.md#ajax-without-rdr).

