# Настройка конфигурации

{% note warning %}

Сейчас изменения в конфигурацию Антиробота могут вносить только сотрудники из команды Антиробота. В дальнейшем планируется каждому сервису выдать доступ на редактирование относящейся к нему части конфигурации.

{% endnote %}


Конфигурация сервиса является частью общей конфигурации Антиробота. Предназначена для индивидуальной настройки работы Антиробота с каждым сервисом.

Формат конфигурации на примере сервиса Каталог.

```json
{
   "service": "yaca",
   "enabled": true,
   "bans_enabled": true,
   "blocks_enabled": false,
   "random_bans_enabled": false,
   "random_bans_fraction": 0.0001,
   "formula": "matrixnet.info",
   "threshold": 2,
   "cbb_ban_re_flag": 90,
   "cbb_monitoring_flag": 190,
   "re_requests": [
       {"path": "/yaca", "req_type": "main"},
       {"path": "/yaca/cy/ch/.*", "req_type": "ys"},
       {"path": "/yaca/yandsearch", "query": ".*ajax=1.*", "req_type": "api"},
       {"path": "/static/.*", "req_type": "static"}
    ],
    "zone": {
       "tr": {
           "formula": "matrixnetTr.info"
       }
    }
}
```

Название параметра | Описание | Обязательность
----- | ----- | -----
`service` | Идентификатор сервиса. | Да
`enabled` | Признак включения Антиробота на данном сервисе. | Да
`bans_enabled` | Признак включения забанивания. | Да
`blocks_enabled` | Признак включения блокировок. | Да
`random_bans_enabled` | Признак включения случайных банов (для сбора разметки). | Да
`random_bans_fraction` | Доля запросов со случайными банами. | Да
`formula` | Классификатор роботности. | Да
`threshold` | Порог забанивания. | Да
`cbb_ban_re_flag` | Номер флага в ЕББ для банов по регулярному выражению. | Да
`cbb_monitoring_flag` | Номер флага в ЕББ для мониторинга потенциальных банов по регулярному выражению. | Да
`re_requests` | [Разметка запросов по типам](markup.md). Определяет ресурсы, на запрос которых Антиробот может вернуть капчу пользователю. В конфигурации строки с разметкой размещаются в порядке убывания приоритета. При обработке запроса Антиробот последовательно проверяет его на соответствие типу, начиная с первой строки. | Да
`zone` | Переопределение параметров для отдельных доменных зон первого уровня. | Нет


