# hypocrisy_prepare

## Basic Usage

```sh
npm i
node index.js \
    --greed path/to/greed_debug_build.js \
    --descriptor-key path/to/base64_encoded_key \
    --output-script path/to/output.js \
    --contrib-obfuscate
```

This will inject fingerprint encryption code into the input script and pass it through
[javascript-obfuscator](https://github.com/javascript-obfuscator/javascript-obfuscator). The
```--contrib-obfuscate``` parameter is necessary to enable obfuscation. The descriptor key file is a
file that contains a base64-encoded encryption key which should be shared with Antirobot for
fingerprint decryption.

## Making Output Smaller

The ```--contrib-obfuscate-override``` parameter allows to specify options to be passed to
javascript-obfuscator.

Example:

```sh
node index.js \
    --greed path/to/greed_debug_build.js \
    --descriptor-key path/to/base64_encoded_key \
    --output-script path/to/output.js \
    --contrib-obfuscate \
    --contrib-obfuscate-override '{"controlFlowFlatteningThreshold": 0.25, "deadCodeInjectionThreshold": 0.25}'
```

List of useful options:

* ```controlFlowFlattening: boolean = true``` – enables control flattening which is an obfuscation technique that hinders program comprehension but slows down execution by up to 1.5x.
* ```controlFlowFlatteningThreshold: float = 0.5``` – controls the probability of
  control flow flattening if enabled.
* ```deadCodeInjection: boolean = true``` – enables dead code injection which significantly
  increases the size of output code.
* ```deadCodeInjectionThreshold: float = 0.3``` – controls the probability of dead code injection.
* ```debugProtection: boolean = false``` – enables debug protection which makes it difficult to use the built-in debugging tools.
* ```debugProtectionInterval: integer = 0``` – controls the interval of forcing debug mode on the Console tab, works if debugProtection is enabled.
* ```disableConsoleOutput: boolean = false``` – disables console output.

Full list of options can be found [here](https://github.com/javascript-obfuscator/javascript-obfuscator).

TODO: More aggressive defaults?

## Building a Static Binary

```sh
pkg . -t node16-linuxstatic-x64
```

## How Does It Work?

Greed source contains calls of dummy functions with special names. These calls allow
hypocrisy_prepare to find out how to inject code that encrypts the fingerprint.

The code is generated by emitting statements that loosely follow the ChaCha20 algorithm with some
randomized parameters. These parameters are encoded and encrypted with the descriptor key to form
what's called the descriptor. The descriptor is embedded inside the fingerprint to let Antirobot
decrypt the fingerprint without knowing the randomized parameters beforehand. Keep in mind that the
obfuscated script contains only the encrypted descriptor since it is encrypted on the host that runs
the obfuscation script.

The descriptor key is static and is located [here](https://yav.yandex-team.ru/secret/sec-01ff7ze3peagm7zffbxbevq6xm/explore/versions).

## Deployment

The [COLLECT_ANTIROBOT_DATA Sandbox task](https://a.yandex-team.ru/arcadia/sandbox/projects/CollectAntirobotData/__init__.py?rev=r9760194#L77)
downloads a Sandbox resource that contains files hypocrisy_prepare, hypocrisy_make_bundle and greed.js,
then uses hypocrisy_make_bundle (which runs hypocrisy_prepare as a subprocess) to make a bundle of
multiple obfuscated greed.js instances. The descriptor key is fetched from yav.yandex-team.ru.

## How to Decrypt Files in YQL?

Add the descriptor key in the YQL web interface under Settings -> Auth -> Add token (System: custom; 
Name: hypocrisy_key; Token: *paste descriptor key here*). Then use
```Hypocrisy::DecryptFingerprintWithParam(fingerprint, SecureParam("token:hypocrisy_key"))``` to decrypt the
fingerprint.

Alternatively, you can use ```Hypocrisy::DecryptFingerprint(fingerprint, descriptor_key)``` but this is not
recommended as you risk leaking the key by accidentally sharing your YQL code.
