#!/usr/bin/env perl

# Generates Region => time offset map
#
# Usage:
#   1. fetch http://geobase.yandex.ru/geobase.pm
#   2. ./geo_gen.pl > geo_timeoffset.inc
#   3. cp geo_timeoffs.inc antirobot/daemon_lib/
#   4. svn commit antirobot/daemon_lib/geo_timeoffset.inc
#
use utf8;
use strict;
use Encode;
use geobase;

binmode(STDOUT,':utf8');

print "/*\
    This file is automatically generated by antirobot/scripts/geo/geo_gen.pl.\
    Do not edit it.\
*/\
\
";


print <<EOF;
static struct {
    long long regionid;
    int offset;
} TIMEOFFSET_DATA[] = {
EOF

while (my ($k, $v) = each %Region) {
    my $offset = 0;
    $offset += $v->{offset} if exists $v->{offset};
    printf ("{ LL(%lld), %d },\n", $k, $offset);
}

print "};\n";
print "const size_t TIMEOFFSET_DATA_SIZE = sizeof(TIMEOFFSET_DATA) / sizeof(TIMEOFFSET_DATA[0]);\n";
