CRCTAB64 = [
    0x0000000000000000, 0xE543279765927881, 0x2FC568B9AEB68983, 0xCA864F2ECB24F102,
    0x5F8AD1735D6D1306, 0xBAC9F6E438FF6B87, 0x704FB9CAF3DB9A85, 0x950C9E5D9649E204,
    0xBF15A2E6BADA260C, 0x5A568571DF485E8D, 0x90D0CA5F146CAF8F, 0x7593EDC871FED70E,
    0xE09F7395E7B7350A, 0x05DC540282254D8B, 0xCF5A1B2C4901BC89, 0x2A193CBB2C93C408,
    0x9B68625A10263499, 0x7E2B45CD75B44C18, 0xB4AD0AE3BE90BD1A, 0x51EE2D74DB02C59B,
    0xC4E2B3294D4B279F, 0x21A194BE28D95F1E, 0xEB27DB90E3FDAE1C, 0x0E64FC07866FD69D,
    0x247DC0BCAAFC1295, 0xC13EE72BCF6E6A14, 0x0BB8A805044A9B16, 0xEEFB8F9261D8E397,
    0x7BF711CFF7910193, 0x9EB4365892037912, 0x5432797659278810, 0xB1715EE13CB5F091,
    0xD393E32345DE11B3, 0x36D0C4B4204C6932, 0xFC568B9AEB689830, 0x1915AC0D8EFAE0B1,
    0x8C19325018B302B5, 0x695A15C77D217A34, 0xA3DC5AE9B6058B36, 0x469F7D7ED397F3B7,
    0x6C8641C5FF0437BF, 0x89C566529A964F3E, 0x4343297C51B2BE3C, 0xA6000EEB3420C6BD,
    0x330C90B6A26924B9, 0xD64FB721C7FB5C38, 0x1CC9F80F0CDFAD3A, 0xF98ADF98694DD5BB,
    0x48FB817955F8252A, 0xADB8A6EE306A5DAB, 0x673EE9C0FB4EACA9, 0x827DCE579EDCD428,
    0x1771500A0895362C, 0xF232779D6D074EAD, 0x38B438B3A623BFAF, 0xDDF71F24C3B1C72E,
    0xF7EE239FEF220326, 0x12AD04088AB07BA7, 0xD82B4B2641948AA5, 0x3D686CB12406F224,
    0xA864F2ECB24F1020, 0x4D27D57BD7DD68A1, 0x87A19A551CF999A3, 0x62E2BDC2796BE122,
    0x4264E1D1EE2E5BE7, 0xA727C6468BBC2366, 0x6DA189684098D264, 0x88E2AEFF250AAAE5,
    0x1DEE30A2B34348E1, 0xF8AD1735D6D13060, 0x322B581B1DF5C162, 0xD7687F8C7867B9E3,
    0xFD71433754F47DEB, 0x183264A03166056A, 0xD2B42B8EFA42F468, 0x37F70C199FD08CE9,
    0xA2FB924409996EED, 0x47B8B5D36C0B166C, 0x8D3EFAFDA72FE76E, 0x687DDD6AC2BD9FEF,
    0xD90C838BFE086F7E, 0x3C4FA41C9B9A17FF, 0xF6C9EB3250BEE6FD, 0x138ACCA5352C9E7C,
    0x868652F8A3657C78, 0x63C5756FC6F704F9, 0xA9433A410DD3F5FB, 0x4C001DD668418D7A,
    0x6619216D44D24972, 0x835A06FA214031F3, 0x49DC49D4EA64C0F1, 0xAC9F6E438FF6B870,
    0x3993F01E19BF5A74, 0xDCD0D7897C2D22F5, 0x165698A7B709D3F7, 0xF315BF30D29BAB76,
    0x91F702F2ABF04A54, 0x74B42565CE6232D5, 0xBE326A4B0546C3D7, 0x5B714DDC60D4BB56,
    0xCE7DD381F69D5952, 0x2B3EF416930F21D3, 0xE1B8BB38582BD0D1, 0x04FB9CAF3DB9A850,
    0x2EE2A014112A6C58, 0xCBA1878374B814D9, 0x0127C8ADBF9CE5DB, 0xE464EF3ADA0E9D5A,
    0x716871674C477F5E, 0x942B56F029D507DF, 0x5EAD19DEE2F1F6DD, 0xBBEE3E4987638E5C,
    0x0A9F60A8BBD67ECD, 0xEFDC473FDE44064C, 0x255A08111560F74E, 0xC0192F8670F28FCF,
    0x5515B1DBE6BB6DCB, 0xB056964C8329154A, 0x7AD0D962480DE448, 0x9F93FEF52D9F9CC9,
    0xB58AC24E010C58C1, 0x50C9E5D9649E2040, 0x9A4FAAF7AFBAD142, 0x7F0C8D60CA28A9C3,
    0xEA00133D5C614BC7, 0x0F4334AA39F33346, 0xC5C57B84F2D7C244, 0x20865C139745BAC5,
    0x84C9C3A3DC5CB7CE, 0x618AE434B9CECF4F, 0xAB0CAB1A72EA3E4D, 0x4E4F8C8D177846CC,
    0xDB4312D08131A4C8, 0x3E003547E4A3DC49, 0xF4867A692F872D4B, 0x11C55DFE4A1555CA,
    0x3BDC6145668691C2, 0xDE9F46D20314E943, 0x141909FCC8301841, 0xF15A2E6BADA260C0,
    0x6456B0363BEB82C4, 0x811597A15E79FA45, 0x4B93D88F955D0B47, 0xAED0FF18F0CF73C6,
    0x1FA1A1F9CC7A8357, 0xFAE2866EA9E8FBD6, 0x3064C94062CC0AD4, 0xD527EED7075E7255,
    0x402B708A91179051, 0xA568571DF485E8D0, 0x6FEE18333FA119D2, 0x8AAD3FA45A336153,
    0xA0B4031F76A0A55B, 0x45F724881332DDDA, 0x8F716BA6D8162CD8, 0x6A324C31BD845459,
    0xFF3ED26C2BCDB65D, 0x1A7DF5FB4E5FCEDC, 0xD0FBBAD5857B3FDE, 0x35B89D42E0E9475F,
    0x575A20809982A67D, 0xB2190717FC10DEFC, 0x789F483937342FFE, 0x9DDC6FAE52A6577F,
    0x08D0F1F3C4EFB57B, 0xED93D664A17DCDFA, 0x2715994A6A593CF8, 0xC256BEDD0FCB4479,
    0xE84F826623588071, 0x0D0CA5F146CAF8F0, 0xC78AEADF8DEE09F2, 0x22C9CD48E87C7173,
    0xB7C553157E359377, 0x528674821BA7EBF6, 0x98003BACD0831AF4, 0x7D431C3BB5116275,
    0xCC3242DA89A492E4, 0x2971654DEC36EA65, 0xE3F72A6327121B67, 0x06B40DF4428063E6,
    0x93B893A9D4C981E2, 0x76FBB43EB15BF963, 0xBC7DFB107A7F0861, 0x593EDC871FED70E0,
    0x7327E03C337EB4E8, 0x9664C7AB56ECCC69, 0x5CE288859DC83D6B, 0xB9A1AF12F85A45EA,
    0x2CAD314F6E13A7EE, 0xC9EE16D80B81DF6F, 0x036859F6C0A52E6D, 0xE62B7E61A53756EC,
    0xC6AD22723272EC29, 0x23EE05E557E094A8, 0xE9684ACB9CC465AA, 0x0C2B6D5CF9561D2B,
    0x9927F3016F1FFF2F, 0x7C64D4960A8D87AE, 0xB6E29BB8C1A976AC, 0x53A1BC2FA43B0E2D,
    0x79B8809488A8CA25, 0x9CFBA703ED3AB2A4, 0x567DE82D261E43A6, 0xB33ECFBA438C3B27,
    0x263251E7D5C5D923, 0xC3717670B057A1A2, 0x09F7395E7B7350A0, 0xECB41EC91EE12821,
    0x5DC540282254D8B0, 0xB88667BF47C6A031, 0x720028918CE25133, 0x97430F06E97029B2,
    0x024F915B7F39CBB6, 0xE70CB6CC1AABB337, 0x2D8AF9E2D18F4235, 0xC8C9DE75B41D3AB4,
    0xE2D0E2CE988EFEBC, 0x0793C559FD1C863D, 0xCD158A773638773F, 0x2856ADE053AA0FBE,
    0xBD5A33BDC5E3EDBA, 0x5819142AA071953B, 0x929F5B046B556439, 0x77DC7C930EC71CB8,
    0x153EC15177ACFD9A, 0xF07DE6C6123E851B, 0x3AFBA9E8D91A7419, 0xDFB88E7FBC880C98,
    0x4AB410222AC1EE9C, 0xAFF737B54F53961D, 0x6571789B8477671F, 0x80325F0CE1E51F9E,
    0xAA2B63B7CD76DB96, 0x4F684420A8E4A317, 0x85EE0B0E63C05215, 0x60AD2C9906522A94,
    0xF5A1B2C4901BC890, 0x10E29553F589B011, 0xDA64DA7D3EAD4113, 0x3F27FDEA5B3F3992,
    0x8E56A30B678AC903, 0x6B15849C0218B182, 0xA193CBB2C93C4080, 0x44D0EC25ACAE3801,
    0xD1DC72783AE7DA05, 0x349F55EF5F75A284, 0xFE191AC194515386, 0x1B5A3D56F1C32B07,
    0x314301EDDD50EF0F, 0xD400267AB8C2978E, 0x1E86695473E6668C, 0xFBC54EC316741E0D,
    0x6EC9D09E803DFC09, 0x8B8AF709E5AF8488, 0x410CB8272E8B758A, 0xA44F9FB04B190D0B]


#
# Copyright (C) Sewell Development Corporation, 1994 - 1998.
#
def crc64digest(data):
    MAX_64 = 0xFFFFFFFFFFFFFFFF
    crcinit = 0
    for c in data:
        # print ord(c), crcinit, crcinit >> 56, (crcinit >> 56) ^ ord(c), CRCTAB64[(crcinit >> 56) ^ ord(c)], (CRCTAB64[(crcinit >> 56) ^ ord(c)] ^ (crcinit << 8)) & MAX_64
        crcinit = (CRCTAB64[(crcinit >> 56) ^ ord(c)] ^ (crcinit << 8)) & MAX_64

    return crcinit
