#!/usr/bin/env python
# prints only requests that don't belong to Yandex network

import sys


def ip_to_num(ip):
    if len(ip) < 7:
        return 0

    parts = ip.split(".")
    if len(parts) != 4:
        return 0

    try:
        res = 0
        for pp in parts:
            res = res * 256 + int(pp)

        return res
    except:
        return 0


def CalcMask(numDigits):
    return ~((1 << (32 - numDigits)) - 1)


YANDEX_SUBNETS = [
    "5.45.192.0/22",
    "5.45.192.0/16",
    "5.45.192.0/26",
    "5.45.192.64/26",
    "5.45.192.128/25",
    "5.45.193.0/24",
    "5.45.194.0/24",
    "5.45.195.0/25",
    "5.45.195.128/25",
    "5.45.196.0/24",
    "5.45.197.0/24",
    "5.45.198.0/23",
    "5.45.200.0/22",
    "5.45.201.0/24",
    "5.45.202.0/24",
    "5.45.203.0/26",
    "5.45.203.64/26",
    "5.45.203.192/26",
    "5.45.204.0/24",
    "5.45.204.0/25",
    "5.45.205.0/24",
    "5.45.206.0/24",
    "5.45.206.0/28",
    "5.45.206.16/31",
    "5.45.206.18/31",
    "5.45.206.20/31",
    "5.45.206.22/31",
    "5.45.206.24/29",
    "5.45.206.32/28",
    "5.45.206.48/28",
    "5.45.206.64/29",
    "5.45.206.72/29",
    "5.45.206.80/29",
    "5.45.206.88/29",
    "5.45.206.96/27",
    "5.45.206.128/25",
    "5.45.207.0/24",
    "5.45.207.0/28",
    "5.45.207.16/28",
    "5.45.207.32/28",
    "5.45.207.48/28",
    "5.45.207.64/26",
    "5.45.207.128/25",
    "5.45.208.0/24",
    "5.45.208.0/26",
    "5.45.208.64/28",
    "5.45.208.80/29",
    "5.45.208.88/30",
    "5.45.209.0/24",
    "5.45.209.0/25",
    "5.45.209.128/25",
    "5.45.210.0/23",
    "5.45.210.0/24",
    "5.45.211.0/24",
    "5.45.212.0/24",
    "5.45.212.32/28",
    "5.45.212.48/28",
    "5.45.212.64/26",
    "5.45.212.128/27",
    "5.45.212.160/27",
    "5.45.213.0/24",
    "5.45.214.0/24",
    "5.45.214.0/29",
    "5.45.214.8/29",
    "5.45.214.16/28",
    "5.45.214.32/27",
    "5.45.214.64/30",
    "5.45.214.68/31",
    "5.45.214.70/31",
    "5.45.214.72/29",
    "5.45.214.80/29",
    "5.45.214.88/30",
    "5.45.214.92/31",
    "5.45.214.94/31",
    "5.45.214.96/27",
    "5.45.214.128/26",
    "5.45.214.192/26",
    "5.45.215.0/24",
    "5.45.215.0/25",
    "5.45.215.128/26",
    "5.45.215.192/26",
    "5.45.216.0/22",
    "5.45.216.0/24",
    "5.45.218.0/23",
    "5.45.220.0/22",
    "5.45.220.0/23",
    "5.45.222.0/28",
    "5.45.222.16/28",
    "5.45.222.32/27",
    "5.45.222.64/27",
    "5.45.222.96/29",
    "5.45.222.128/25",
    "5.45.223.0/24",
    "5.45.224.0/23",
    "5.45.226.0/23",
    "5.45.228.0/24",
    "5.45.228.0/25",
    "5.45.228.128/28",
    "5.45.228.144/28",
    "5.45.228.160/30",
    "5.45.229.0/24",
    "5.45.230.0/23",
    "5.45.232.0/24",
    "5.45.232.0/25",
    "5.45.232.128/28",
    "5.45.232.144/28",
    "5.45.232.160/30",
    "5.45.232.164/31",
    "5.45.232.166/31",
    "5.45.232.168/29",
    "5.45.232.176/29",
    "5.45.233.0/24",
    "5.45.233.0/25",
    "5.45.233.128/25",
    "5.45.234.0/23",
    "5.45.234.0/29",
    "5.45.234.8/29",
    "5.45.234.16/28",
    "5.45.234.32/29",
    "5.45.234.40/29",
    "5.45.234.48/28",
    "5.45.234.64/27",
    "5.45.234.96/27",
    "5.45.234.128/25",
    "5.45.235.0/25",
    "5.45.235.128/25",
    "5.45.236.0/22",
    "5.45.240.0/24",
    "5.45.240.0/25",
    "5.45.240.128/28",
    "5.45.240.144/28",
    "5.45.240.160/29",
    "5.45.240.168/30",
    "5.45.240.172/31",
    "5.45.240.174/31",
    "5.45.241.0/24",
    "5.45.242.0/24",
    "5.45.243.0/24",
    "5.45.243.0/28",
    "5.45.243.16/30",
    "5.45.243.64/26",
    "5.45.243.128/29",
    "5.45.243.136/29",
    "5.45.244.0/23",
    "5.45.244.0/27",
    "5.45.244.32/28",
    "5.45.244.48/28",
    "5.45.244.64/26",
    "5.45.244.128/25",
    "5.45.245.0/28",
    "5.45.245.16/28",
    "5.45.245.32/27",
    "5.45.245.64/26",
    "5.45.245.192/26",
    "5.45.246.0/24",
    "5.45.246.64/26",
    "5.45.246.192/29",
    "5.45.246.200/29",
    "5.45.246.208/28",
    "5.45.246.224/28",
    "5.45.247.0/24",
    "5.45.248.0/23",
    "5.45.248.0/27",
    "5.45.248.32/27",
    "5.45.248.64/26",
    "5.45.248.128/26",
    "5.45.248.192/28",
    "5.45.248.208/28",
    "5.45.248.224/27",
    "5.45.249.0/24",
    "5.45.249.0/25",
    "5.45.250.0/23",
    "5.45.252.0/23",
    "5.45.252.0/26",
    "5.45.252.64/26",
    "5.45.252.128/26",
    "5.45.252.192/27",
    "5.45.252.224/27",
    "5.45.253.0/24",
    "5.45.254.0/23",
    "5.45.254.0/25",
    "5.45.254.128/26",
    "5.45.254.192/27",
    "5.45.254.224/27",
    "5.45.255.64/26",
    "5.45.255.192/26",
    "5.255.192.0/24",
    "5.255.192.0/26",
    "5.255.192.64/30",
    "5.255.192.80/28",
    "5.255.193.0/24",
    "5.255.193.0/28",
    "5.255.193.16/28",
    "5.255.193.32/27",
    "5.255.193.64/26",
    "5.255.193.128/26",
    "5.255.193.192/28",
    "5.255.193.208/28",
    "5.255.193.224/27",
    "5.255.194.0/24",
    "5.255.194.0/29",
    "5.255.194.8/31",
    "5.255.194.10/31",
    "5.255.194.12/30",
    "5.255.194.16/28",
    "5.255.194.32/31",
    "5.255.194.34/31",
    "5.255.194.40/29",
    "5.255.194.48/28",
    "5.255.194.64/26",
    "5.255.195.0/24",
    "5.255.195.0/27",
    "5.255.195.64/26",
    "5.255.195.144/28",
    "5.255.195.160/28",
    "5.255.195.176/28",
    "5.255.195.224/27",
    "5.255.196.0/23",
    "5.255.198.0/23",
    "5.255.198.0/26",
    "5.255.198.64/26",
    "5.255.198.128/25",
    "5.255.199.0/29",
    "5.255.199.8/29",
    "5.255.199.16/29",
    "5.255.199.24/29",
    "5.255.199.32/27",
    "5.255.199.64/27",
    "5.255.199.96/28",
    "5.255.199.112/28",
    "5.255.199.128/25",
    "5.255.200.0/24",
    "5.255.200.0/25",
    "5.255.200.128/28",
    "5.255.200.144/29",
    "5.255.200.152/29",
    "5.255.200.160/30",
    "5.255.200.164/31",
    "5.255.200.166/31",
    "5.255.201.0/24",
    "5.255.201.0/30",
    "5.255.201.4/31",
    "5.255.201.6/31",
    "5.255.201.8/29",
    "5.255.201.16/28",
    "5.255.201.32/27",
    "5.255.201.64/29",
    "5.255.201.72/29",
    "5.255.201.80/29",
    "5.255.201.88/29",
    "5.255.201.96/27",
    "5.255.201.128/27",
    "5.255.201.160/29",
    "5.255.201.176/28",
    "5.255.201.192/28",
    "5.255.201.208/29",
    "5.255.201.220/31",
    "5.255.201.222/31",
    "5.255.201.224/28",
    "5.255.201.240/28",
    "5.255.202.0/23",
    "5.255.204.0/22",
    "5.255.204.0/24",
    "5.255.205.0/25",
    "5.255.205.0/29",
    "5.255.205.8/29",
    "5.255.205.16/29",
    "5.255.205.24/29",
    "5.255.205.32/29",
    "5.255.205.40/29",
    "5.255.205.48/28",
    "5.255.205.128/25",
    "5.255.206.0/25",
    "5.255.206.128/26",
    "5.255.206.192/26",
    "5.255.207.0/25",
    "5.255.207.128/25",
    "5.255.208.0/21",
    "5.255.208.0/23",
    "5.255.208.0/26",
    "5.255.208.64/26",
    "5.255.208.128/26",
    "5.255.208.192/26",
    "5.255.209.0/26",
    "5.255.209.64/26",
    "5.255.209.128/26",
    "5.255.209.192/26",
    "5.255.210.0/27",
    "5.255.210.32/27",
    "5.255.210.64/28",
    "5.255.210.80/29",
    "5.255.210.88/30",
    "5.255.210.96/28",
    "5.255.210.112/28",
    "5.255.210.128/26",
    "5.255.210.192/26",
    "5.255.212.0/24",
    "5.255.213.0/25",
    "5.255.213.128/25",
    "5.255.213.224/27",
    "5.255.214.0/26",
    "5.255.214.64/28",
    "5.255.214.80/28",
    "5.255.214.96/28",
    "5.255.214.112/28",
    "5.255.214.128/25",
    "5.255.215.0/24",
    "5.255.216.0/24",
    "5.255.217.0/24",
    "5.255.217.0/25",
    "5.255.217.128/25",
    "5.255.218.0/23",
    "5.255.218.0/25",
    "5.255.218.128/27",
    "5.255.218.160/27",
    "5.255.218.192/26",
    "5.255.219.0/25",
    "5.255.219.128/26",
    "5.255.219.192/26",
    "5.255.220.0/22",
    "5.255.220.0/23",
    "5.255.222.0/24",
    "5.255.223.0/24",
    "5.255.224.0/22",
    "5.255.224.0/27",
    "5.255.224.64/26",
    "5.255.224.128/27",
    "5.255.224.160/27",
    "5.255.224.192/27",
    "5.255.224.224/27",
    "5.255.225.0/24",
    "5.255.225.0/26",
    "5.255.226.0/25",
    "5.255.226.128/28",
    "5.255.226.144/29",
    "5.255.226.152/29",
    "5.255.226.160/28",
    "5.255.226.176/28",
    "5.255.227.0/24",
    "5.255.228.0/22",
    "5.255.228.0/28",
    "5.255.228.16/28",
    "5.255.228.32/27",
    "5.255.228.64/27",
    "5.255.228.128/25",
    "5.255.229.0/24",
    "5.255.229.0/25",
    "5.255.230.0/25",
    "5.255.230.128/29",
    "5.255.230.136/29",
    "5.255.230.144/28",
    "5.255.230.160/27",
    "5.255.230.192/26",
    "5.255.231.0/25",
    "5.255.231.128/25",
    "5.255.232.0/21",
    "5.255.232.0/22",
    "5.255.236.0/26",
    "5.255.236.64/26",
    "5.255.236.128/26",
    "5.255.236.192/26",
    "5.255.236.192/29",
    "5.255.237.0/24",
    "5.255.238.32/27",
    "5.255.238.64/27",
    "5.255.238.128/25",
    "5.255.239.0/24",
    "5.255.240.0/24",
    "5.255.241.0/24",
    "5.255.241.0/26",
    "5.255.241.64/27",
    "5.255.241.96/28",
    "5.255.241.112/28",
    "5.255.241.128/26",
    "5.255.241.192/29",
    "5.255.241.200/29",
    "5.255.241.208/28",
    "5.255.241.224/27",
    "5.255.242.0/23",
    "5.255.242.0/24",
    "5.255.243.0/24",
    "5.255.244.0/22",
    "5.255.248.0/22",
    "5.255.248.0/23",
    "5.255.250.0/23",
    "5.255.252.0/24",
    "5.255.252.0/25",
    "5.255.252.128/28",
    "5.255.252.144/28",
    "5.255.252.160/30",
    "5.255.252.164/31",
    "5.255.252.166/31",
    "5.255.252.168/29",
    "5.255.252.176/29",
    "5.255.253.0/24",
    "5.255.254.0/24",
    "5.255.254.0/25",
    "5.255.254.128/28",
    "5.255.254.160/29",
    "5.255.254.168/29",
    "5.255.254.176/28",
    "5.255.254.192/26",
    "37.9.64.0/24",
    "37.9.64.0/25",
    "37.9.65.0/24",
    "37.9.65.0/25",
    "37.9.65.128/26",
    "37.9.65.192/27",
    "37.9.65.224/27",
    "37.9.66.0/24",
    "37.9.66.0/27",
    "37.9.66.64/28",
    "37.9.66.80/28",
    "37.9.66.96/28",
    "37.9.66.112/29",
    "37.9.66.132/30",
    "37.9.66.144/29",
    "37.9.66.152/29",
    "37.9.66.192/31",
    "37.9.66.194/31",
    "37.9.66.196/31",
    "37.9.66.200/29",
    "37.9.66.208/28",
    "37.9.66.224/28",
    "37.9.67.0/24",
    "37.9.67.64/26",
    "37.9.67.132/30",
    "37.9.67.136/29",
    "37.9.67.144/29",
    "37.9.67.152/31",
    "37.9.67.154/31",
    "37.9.67.160/29",
    "37.9.67.168/29",
    "37.9.67.176/28",
    "37.9.68.0/22",
    "37.9.68.0/26",
    "37.9.68.64/27",
    "37.9.68.96/27",
    "37.9.68.192/26",
    "37.9.69.0/24",
    "37.9.70.0/24",
    "37.9.71.0/24",
    "37.9.72.0/24",
    "37.9.72.0/27",
    "37.9.72.32/28",
    "37.9.72.48/28",
    "37.9.72.64/26",
    "37.9.72.128/29",
    "37.9.72.136/29",
    "37.9.72.144/28",
    "37.9.72.160/28",
    "37.9.72.176/28",
    "37.9.72.192/26",
    "37.9.73.0/24",
    "37.9.73.0/28",
    "37.9.73.16/29",
    "37.9.73.24/29",
    "37.9.74.0/25",
    "37.9.74.32/27",
    "37.9.74.64/27",
    "37.9.74.128/25",
    "37.9.74.128/29",
    "37.9.74.136/29",
    "37.9.74.144/28",
    "37.9.74.160/28",
    "37.9.74.176/28",
    "37.9.75.0/24",
    "37.9.75.0/28",
    "37.9.75.16/28",
    "37.9.75.32/27",
    "37.9.75.64/28",
    "37.9.75.80/31",
    "37.9.75.82/31",
    "37.9.75.84/31",
    "37.9.75.86/31",
    "37.9.75.88/29",
    "37.9.75.96/27",
    "37.9.75.128/25",
    "37.9.76.0/22",
    "37.9.80.0/20",
    "37.9.80.0/22",
    "37.9.84.0/22",
    "37.9.88.64/26",
    "37.9.88.128/27",
    "37.9.88.160/28",
    "37.9.88.176/28",
    "37.9.88.192/26",
    "37.9.89.0/26",
    "37.9.89.64/27",
    "37.9.89.64/29",
    "37.9.89.96/29",
    "37.9.89.104/29",
    "37.9.89.112/28",
    "37.9.89.128/25",
    "37.9.89.128/29",
    "37.9.89.136/29",
    "37.9.89.144/29",
    "37.9.89.152/29",
    "37.9.89.160/29",
    "37.9.89.168/29",
    "37.9.90.0/24",
    "37.9.91.0/24",
    "37.9.92.0/22",
    "37.9.96.0/24",
    "37.9.96.0/29",
    "37.9.97.0/24",
    "37.9.97.0/26",
    "37.9.97.64/26",
    "37.9.98.0/24",
    "37.9.98.0/30",
    "37.9.98.4/31",
    "37.9.98.6/31",
    "37.9.98.8/31",
    "37.9.98.10/31",
    "37.9.98.12/30",
    "37.9.98.16/28",
    "37.9.98.32/27",
    "37.9.98.64/26",
    "37.9.98.128/28",
    "37.9.98.144/28",
    "37.9.98.160/29",
    "37.9.98.168/29",
    "37.9.98.176/29",
    "37.9.98.184/29",
    "37.9.98.192/27",
    "37.9.98.224/27",
    "37.9.99.0/24",
    "37.9.100.0/23",
    "37.9.102.0/23",
    "37.9.102.0/24",
    "37.9.103.0/24",
    "37.9.104.0/24",
    "37.9.105.0/24",
    "37.9.105.0/25",
    "37.9.105.128/26",
    "37.9.106.0/23",
    "37.9.106.128/25",
    "37.9.107.64/26",
    "37.9.107.192/26",
    "37.9.108.0/22",
    "37.9.108.0/24",
    "37.9.109.0/24",
    "37.9.110.0/23",
    "37.9.112.0/24",
    "37.9.113.0/24",
    "37.9.114.0/24",
    "37.9.114.0/25",
    "37.9.115.0/24",
    "37.9.115.0/26",
    "37.9.115.64/26",
    "37.9.115.128/28",
    "37.9.115.144/28",
    "37.9.115.160/27",
    "37.9.115.192/26",
    "37.9.116.0/22",
    "37.9.116.0/23",
    "37.9.118.0/29",
    "37.9.118.8/29",
    "37.9.118.16/28",
    "37.9.118.32/27",
    "37.9.118.64/26",
    "37.9.118.128/25",
    "37.9.119.0/25",
    "37.9.119.128/26",
    "37.9.119.192/27",
    "37.9.119.224/27",
    "37.9.120.0/22",
    "37.9.120.0/23",
    "37.9.122.0/24",
    "37.9.123.0/24",
    "37.9.124.0/22",
    "37.9.124.0/24",
    "37.9.125.0/24",
    "37.9.126.0/26",
    "37.9.126.64/27",
    "37.9.126.96/27",
    "37.9.126.128/26",
    "37.9.126.192/28",
    "37.9.126.208/28",
    "37.9.126.224/27",
    "37.9.127.0/24",
    "37.140.128.0/21",
    "37.140.128.0/23",
    "37.140.130.0/25",
    "37.140.130.128/29",
    "37.140.130.136/29",
    "37.140.130.144/28",
    "37.140.130.160/28",
    "37.140.130.176/28",
    "37.140.130.192/26",
    "37.140.131.0/26",
    "37.140.131.64/28",
    "37.140.131.80/28",
    "37.140.131.96/27",
    "37.140.131.128/26",
    "37.140.131.192/28",
    "37.140.131.208/30",
    "37.140.131.216/29",
    "37.140.131.224/28",
    "37.140.131.240/28",
    "37.140.132.0/25",
    "37.140.132.128/25",
    "37.140.133.0/24",
    "37.140.134.0/24",
    "37.140.134.0/25",
    "37.140.135.0/24",
    "37.140.136.0/24",
    "37.140.136.0/26",
    "37.140.136.64/28",
    "37.140.136.80/29",
    "37.140.136.88/29",
    "37.140.137.0/24",
    "37.140.137.0/26",
    "37.140.137.64/27",
    "37.140.138.0/23",
    "37.140.140.0/23",
    "37.140.140.0/27",
    "37.140.140.32/27",
    "37.140.140.64/26",
    "37.140.140.128/25",
    "37.140.141.0/26",
    "37.140.141.64/30",
    "37.140.141.68/30",
    "37.140.141.72/29",
    "37.140.141.80/28",
    "37.140.141.96/28",
    "37.140.141.112/28",
    "37.140.141.128/26",
    "37.140.141.192/28",
    "37.140.141.208/28",
    "37.140.141.224/28",
    "37.140.141.240/28",
    "37.140.142.0/24",
    "37.140.143.0/24",
    "37.140.143.64/26",
    "37.140.143.128/25",
    "37.140.144.0/20",
    "37.140.144.0/22",
    "37.140.148.0/26",
    "37.140.148.64/26",
    "37.140.148.128/26",
    "37.140.148.192/27",
    "37.140.148.224/29",
    "37.140.148.232/29",
    "37.140.148.240/28",
    "37.140.149.0/24",
    "37.140.150.0/24",
    "37.140.151.0/24",
    "37.140.152.0/21",
    "37.140.160.0/22",
    "37.140.160.0/24",
    "37.140.160.0/25",
    "37.140.161.0/24",
    "37.140.162.64/26",
    "37.140.162.128/25",
    "37.140.163.0/25",
    "37.140.164.0/22",
    "37.140.164.0/26",
    "37.140.164.64/28",
    "37.140.164.80/28",
    "37.140.164.96/27",
    "37.140.164.128/25",
    "37.140.165.0/26",
    "37.140.165.64/26",
    "37.140.165.128/26",
    "37.140.165.192/28",
    "37.140.165.208/28",
    "37.140.165.224/27",
    "37.140.166.0/26",
    "37.140.166.64/26",
    "37.140.166.128/26",
    "37.140.166.192/27",
    "37.140.166.224/27",
    "37.140.166.224/29",
    "37.140.167.0/24",
    "37.140.168.0/21",
    "37.140.168.0/25",
    "37.140.168.128/26",
    "37.140.168.192/28",
    "37.140.168.224/27",
    "37.140.170.0/23",
    "37.140.172.0/24",
    "37.140.173.0/27",
    "37.140.173.48/28",
    "37.140.173.64/28",
    "37.140.173.80/28",
    "37.140.173.96/29",
    "37.140.173.104/29",
    "37.140.173.112/30",
    "37.140.173.116/30",
    "37.140.173.120/29",
    "37.140.173.128/28",
    "37.140.173.144/29",
    "37.140.173.152/29",
    "37.140.173.160/27",
    "37.140.173.192/26",
    "37.140.174.0/24",
    "37.140.175.0/24",
    "37.140.176.0/21",
    "37.140.176.0/22",
    "37.140.180.0/24",
    "37.140.181.0/28",
    "37.140.181.16/28",
    "37.140.181.32/28",
    "37.140.181.48/28",
    "37.140.181.64/26",
    "37.140.181.128/26",
    "37.140.181.192/26",
    "37.140.182.0/23",
    "37.140.184.0/22",
    "37.140.188.0/22",
    "37.140.188.0/24",
    "37.140.189.0/27",
    "37.140.189.32/27",
    "37.140.189.64/26",
    "37.140.189.128/27",
    "37.140.189.160/28",
    "37.140.189.192/26",
    "37.140.190.0/23",
    "77.88.0.0/24",
    "77.88.1.0/24",
    "77.88.1.0/26",
    "77.88.1.64/27",
    "77.88.1.96/28",
    "77.88.1.112/29",
    "77.88.1.120/29",
    "77.88.1.128/25",
    "77.88.2.0/23",
    "77.88.4.0/24",
    "77.88.5.0/24",
    "77.88.5.0/30",
    "77.88.5.4/31",
    "77.88.5.8/29",
    "77.88.5.16/29",
    "77.88.5.24/29",
    "77.88.5.32/28",
    "77.88.5.48/28",
    "77.88.5.200/29",
    "77.88.5.216/29",
    "77.88.6.0/24",
    "77.88.6.0/27",
    "77.88.7.0/24",
    "77.88.8.0/24",
    "77.88.9.0/24",
    "77.88.10.0/23",
    "77.88.10.0/27",
    "77.88.10.32/28",
    "77.88.10.48/28",
    "77.88.10.64/28",
    "77.88.10.80/28",
    "77.88.10.96/27",
    "77.88.10.128/25",
    "77.88.11.0/27",
    "77.88.11.32/27",
    "77.88.11.64/26",
    "77.88.11.128/25",
    "77.88.12.0/22",
    "77.88.12.0/28",
    "77.88.12.32/27",
    "77.88.12.64/29",
    "77.88.12.80/28",
    "77.88.12.128/25",
    "77.88.13.0/25",
    "77.88.13.128/29",
    "77.88.13.136/29",
    "77.88.13.144/29",
    "77.88.13.152/30",
    "77.88.13.156/30",
    "77.88.13.160/27",
    "77.88.13.224/28",
    "77.88.13.240/29",
    "77.88.13.248/29",
    "77.88.14.0/23",
    "77.88.16.0/22",
    "77.88.20.96/27",
    "77.88.21.0/24",
    "77.88.22.0/24",
    "77.88.22.0/26",
    "77.88.22.128/25",
    "77.88.23.0/24",
    "77.88.23.0/27",
    "77.88.23.32/28",
    "77.88.23.48/29",
    "77.88.23.56/29",
    "77.88.23.64/27",
    "77.88.23.96/28",
    "77.88.23.112/29",
    "77.88.23.120/29",
    "77.88.23.128/25",
    "77.88.24.0/23",
    "77.88.24.0/24",
    "77.88.25.0/27",
    "77.88.25.32/28",
    "77.88.25.48/28",
    "77.88.26.0/23",
    "77.88.26.0/24",
    "77.88.27.0/26",
    "77.88.27.128/25",
    "77.88.28.0/22",
    "77.88.28.0/24",
    "77.88.29.0/24",
    "77.88.30.0/24",
    "77.88.31.0/25",
    "77.88.31.128/25",
    "77.88.32.0/24",
    "77.88.33.0/24",
    "77.88.33.0/30",
    "77.88.34.0/24",
    "77.88.34.0/25",
    "77.88.34.128/26",
    "77.88.35.0/24",
    "77.88.35.0/25",
    "77.88.35.128/28",
    "77.88.35.144/28",
    "77.88.35.160/29",
    "77.88.35.168/30",
    "77.88.36.0/23",
    "77.88.36.0/30",
    "77.88.36.4/31",
    "77.88.36.6/31",
    "77.88.36.8/31",
    "77.88.36.10/31",
    "77.88.36.12/31",
    "77.88.36.14/31",
    "77.88.36.16/28",
    "77.88.36.32/27",
    "77.88.36.64/27",
    "77.88.36.96/27",
    "77.88.36.128/27",
    "77.88.36.160/29",
    "77.88.36.168/29",
    "77.88.36.176/28",
    "77.88.36.192/26",
    "77.88.37.0/24",
    "77.88.40.0/24",
    "77.88.40.0/28",
    "77.88.40.16/28",
    "77.88.40.32/29",
    "77.88.40.48/28",
    "77.88.40.64/29",
    "77.88.40.72/29",
    "77.88.40.80/28",
    "77.88.40.96/28",
    "77.88.40.112/29",
    "77.88.40.120/29",
    "77.88.40.128/26",
    "77.88.41.0/24",
    "77.88.42.0/23",
    "77.88.42.0/25",
    "77.88.42.128/25",
    "77.88.43.0/25",
    "77.88.44.0/24",
    "77.88.45.0/24",
    "77.88.45.0/31",
    "77.88.45.2/31",
    "77.88.45.4/30",
    "77.88.45.8/31",
    "77.88.45.10/31",
    "77.88.45.32/27",
    "77.88.45.64/29",
    "77.88.45.72/29",
    "77.88.45.80/29",
    "77.88.45.88/29",
    "77.88.45.128/26",
    "77.88.45.192/28",
    "77.88.45.208/29",
    "77.88.45.216/29",
    "77.88.45.224/29",
    "77.88.45.232/29",
    "77.88.45.240/28",
    "77.88.46.0/23",
    "77.88.48.0/24",
    "77.88.48.0/26",
    "77.88.49.0/24",
    "77.88.49.0/28",
    "77.88.49.16/28",
    "77.88.49.32/28",
    "77.88.49.48/28",
    "77.88.49.64/29",
    "77.88.49.72/29",
    "77.88.49.80/28",
    "77.88.49.96/28",
    "77.88.49.112/28",
    "77.88.49.128/28",
    "77.88.49.144/28",
    "77.88.49.160/27",
    "77.88.49.192/28",
    "77.88.49.208/28",
    "77.88.49.224/27",
    "77.88.50.0/23",
    "77.88.52.0/23",
    "77.88.54.0/24",
    "77.88.54.0/25",
    "77.88.54.128/28",
    "77.88.54.144/28",
    "77.88.54.160/29",
    "77.88.54.168/30",
    "77.88.54.172/31",
    "77.88.54.174/31",
    "77.88.55.0/24",
    "77.88.56.0/21",
    "77.88.56.0/24",
    "77.88.56.0/26",
    "77.88.56.64/26",
    "77.88.56.192/26",
    "77.88.57.0/26",
    "77.88.57.64/27",
    "77.88.57.128/27",
    "77.88.57.160/28",
    "77.88.57.176/28",
    "77.88.57.192/26",
    "77.88.58.32/28",
    "77.88.58.48/28",
    "77.88.58.48/29",
    "77.88.58.56/29",
    "77.88.58.64/26",
    "77.88.58.128/26",
    "77.88.58.192/27",
    "77.88.58.224/28",
    "77.88.58.240/28",
    "77.88.59.0/24",
    "77.88.60.0/23",
    "77.88.60.0/25",
    "77.88.60.128/25",
    "77.88.61.0/25",
    "77.88.61.128/25",
    "77.88.62.0/25",
    "77.88.63.128/25",
    "77.88.63.160/27",
    "77.88.63.192/27",
    "77.88.63.224/27",
    "84.201.128.0/23",
    "84.201.128.0/24",
    "84.201.129.0/24",
    "84.201.129.4/30",
    "84.201.129.8/29",
    "84.201.129.16/29",
    "84.201.129.24/29",
    "84.201.129.32/29",
    "84.201.129.64/28",
    "84.201.129.80/28",
    "84.201.129.96/27",
    "84.201.129.128/29",
    "84.201.129.136/31",
    "84.201.129.138/31",
    "84.201.129.144/29",
    "84.201.129.152/29",
    "84.201.129.160/27",
    "84.201.130.0/23",
    "84.201.130.0/27",
    "84.201.130.32/27",
    "84.201.130.64/27",
    "84.201.130.96/28",
    "84.201.130.112/28",
    "84.201.130.128/25",
    "84.201.132.0/23",
    "84.201.134.0/23",
    "84.201.134.0/24",
    "84.201.135.0/24",
    "84.201.136.0/21",
    "84.201.142.0/27",
    "84.201.142.32/27",
    "84.201.142.64/26",
    "84.201.142.128/25",
    "84.201.143.0/26",
    "84.201.143.0/29",
    "84.201.143.8/29",
    "84.201.143.16/29",
    "84.201.143.24/29",
    "84.201.143.64/27",
    "84.201.143.96/29",
    "84.201.143.104/29",
    "84.201.143.112/28",
    "84.201.143.128/26",
    "84.201.143.192/26",
    "84.201.144.0/23",
    "84.201.144.0/24",
    "84.201.145.0/28",
    "84.201.145.16/29",
    "84.201.145.24/29",
    "84.201.145.32/29",
    "84.201.145.40/31",
    "84.201.145.48/28",
    "84.201.145.128/27",
    "84.201.145.160/31",
    "84.201.145.162/31",
    "84.201.145.164/30",
    "84.201.145.168/31",
    "84.201.145.170/31",
    "84.201.145.172/31",
    "84.201.145.174/31",
    "84.201.145.176/28",
    "84.201.145.192/28",
    "84.201.145.208/29",
    "84.201.145.216/29",
    "84.201.145.224/27",
    "84.201.146.0/24",
    "84.201.146.0/27",
    "84.201.146.32/27",
    "84.201.146.64/28",
    "84.201.146.80/28",
    "84.201.146.96/27",
    "84.201.146.128/29",
    "84.201.146.136/29",
    "84.201.146.144/28",
    "84.201.146.160/28",
    "84.201.146.176/29",
    "84.201.146.184/29",
    "84.201.146.192/28",
    "84.201.146.208/28",
    "84.201.146.224/28",
    "84.201.146.240/28",
    "84.201.147.0/24",
    "84.201.148.0/24",
    "84.201.148.0/28",
    "84.201.148.16/28",
    "84.201.148.32/29",
    "84.201.148.40/29",
    "84.201.148.48/28",
    "84.201.148.64/26",
    "84.201.148.128/27",
    "84.201.148.160/30",
    "84.201.148.164/30",
    "84.201.148.168/29",
    "84.201.148.176/29",
    "84.201.148.184/29",
    "84.201.148.192/26",
    "84.201.149.0/24",
    "84.201.149.0/29",
    "84.201.149.16/29",
    "84.201.149.24/29",
    "84.201.149.32/29",
    "84.201.149.40/30",
    "84.201.149.44/30",
    "84.201.149.48/28",
    "84.201.149.80/28",
    "84.201.149.96/28",
    "84.201.149.112/29",
    "84.201.149.120/29",
    "84.201.149.128/25",
    "84.201.150.0/23",
    "84.201.152.0/22",
    "84.201.156.0/24",
    "84.201.156.0/28",
    "84.201.156.16/29",
    "84.201.156.24/30",
    "84.201.156.32/28",
    "84.201.156.48/29",
    "84.201.156.56/29",
    "84.201.156.64/26",
    "84.201.156.128/26",
    "84.201.156.192/26",
    "84.201.157.0/24",
    "84.201.157.0/29",
    "84.201.157.8/29",
    "84.201.157.16/31",
    "84.201.157.18/31",
    "84.201.157.20/30",
    "84.201.157.24/31",
    "84.201.157.26/31",
    "84.201.157.28/30",
    "84.201.157.32/27",
    "84.201.157.64/28",
    "84.201.157.80/28",
    "84.201.157.96/29",
    "84.201.157.104/29",
    "84.201.157.112/31",
    "84.201.157.114/31",
    "84.201.157.120/29",
    "84.201.157.128/29",
    "84.201.157.136/31",
    "84.201.157.138/31",
    "84.201.157.140/30",
    "84.201.157.144/29",
    "84.201.157.152/29",
    "84.201.157.192/26",
    "84.201.158.0/24",
    "84.201.158.0/28",
    "84.201.158.0/30",
    "84.201.158.16/29",
    "84.201.158.24/29",
    "84.201.158.32/28",
    "84.201.158.48/28",
    "84.201.158.64/27",
    "84.201.158.96/30",
    "84.201.158.100/30",
    "84.201.158.104/29",
    "84.201.158.112/28",
    "84.201.158.128/25",
    "84.201.159.0/24",
    "84.201.159.0/26",
    "84.201.160.0/23",
    "84.201.162.0/23",
    "84.201.162.0/27",
    "84.201.162.32/27",
    "84.201.162.64/29",
    "84.201.162.72/29",
    "84.201.162.80/28",
    "84.201.162.96/27",
    "84.201.162.128/26",
    "84.201.162.192/26",
    "84.201.163.0/25",
    "84.201.163.128/27",
    "84.201.163.160/29",
    "84.201.163.168/29",
    "84.201.163.176/29",
    "84.201.163.184/29",
    "84.201.163.192/26",
    "84.201.164.0/23",
    "84.201.166.0/23",
    "84.201.168.0/21",
    "84.201.168.0/23",
    "84.201.172.0/24",
    "84.201.172.0/25",
    "84.201.172.128/26",
    "84.201.172.192/26",
    "84.201.173.0/24",
    "84.201.174.64/26",
    "84.201.174.128/29",
    "84.201.174.160/27",
    "84.201.174.192/26",
    "84.201.176.0/20",
    "84.201.176.0/21",
    "84.201.176.0/22",
    "84.201.182.0/23",
    "84.201.184.0/26",
    "84.201.184.64/28",
    "84.201.184.80/28",
    "84.201.184.96/27",
    "84.201.184.128/26",
    "84.201.184.192/27",
    "84.201.184.224/27",
    "84.201.185.0/25",
    "84.201.185.128/26",
    "84.201.185.192/26",
    "84.201.186.0/23",
    "84.201.188.0/24",
    "84.201.189.0/24",
    "84.201.190.0/25",
    "84.201.190.128/26",
    "84.201.190.192/26",
    "84.201.191.0/24",
    "87.250.224.0/23",
    "87.250.224.0/24",
    "87.250.225.0/24",
    "87.250.225.0/29",
    "87.250.225.8/29",
    "87.250.225.16/28",
    "87.250.225.32/29",
    "87.250.225.40/29",
    "87.250.225.48/29",
    "87.250.225.56/29",
    "87.250.225.64/29",
    "87.250.225.80/29",
    "87.250.225.88/29",
    "87.250.225.96/29",
    "87.250.225.104/29",
    "87.250.226.0/24",
    "87.250.226.0/25",
    "87.250.226.192/26",
    "87.250.227.0/24",
    "87.250.227.0/27",
    "87.250.227.32/27",
    "87.250.227.128/30",
    "87.250.227.144/28",
    "87.250.227.160/28",
    "87.250.227.176/28",
    "87.250.227.192/28",
    "87.250.227.208/28",
    "87.250.228.0/24",
    "87.250.228.0/27",
    "87.250.228.32/29",
    "87.250.228.64/26",
    "87.250.228.128/26",
    "87.250.228.192/26",
    "87.250.229.0/27",
    "87.250.230.0/23",
    "87.250.230.0/24",
    "87.250.231.0/24",
    "87.250.232.0/24",
    "87.250.232.0/26",
    "87.250.232.64/27",
    "87.250.232.96/28",
    "87.250.232.112/28",
    "87.250.232.128/25",
    "87.250.233.0/24",
    "87.250.233.64/28",
    "87.250.233.80/28",
    "87.250.233.96/28",
    "87.250.233.128/25",
    "87.250.234.0/24",
    "87.250.235.0/24",
    "87.250.235.0/27",
    "87.250.235.32/27",
    "87.250.235.64/27",
    "87.250.235.96/28",
    "87.250.235.112/28",
    "87.250.235.128/26",
    "87.250.235.192/27",
    "87.250.235.224/28",
    "87.250.235.240/28",
    "87.250.236.0/24",
    "87.250.236.0/29",
    "87.250.236.8/29",
    "87.250.236.16/29",
    "87.250.236.24/29",
    "87.250.236.32/28",
    "87.250.236.64/26",
    "87.250.236.128/25",
    "87.250.237.0/24",
    "87.250.237.0/26",
    "87.250.237.64/26",
    "87.250.237.128/26",
    "87.250.237.192/26",
    "87.250.238.0/24",
    "87.250.238.0/25",
    "87.250.238.96/27",
    "87.250.238.128/26",
    "87.250.238.192/27",
    "87.250.238.224/27",
    "87.250.239.0/24",
    "87.250.239.0/31",
    "87.250.239.2/31",
    "87.250.239.4/31",
    "87.250.239.6/31",
    "87.250.239.8/31",
    "87.250.239.10/31",
    "87.250.239.12/31",
    "87.250.239.14/31",
    "87.250.239.16/31",
    "87.250.239.18/31",
    "87.250.239.24/31",
    "87.250.239.40/31",
    "87.250.239.42/31",
    "87.250.239.44/31",
    "87.250.239.46/31",
    "87.250.239.48/31",
    "87.250.239.54/31",
    "87.250.239.56/31",
    "87.250.239.58/31",
    "87.250.239.60/31",
    "87.250.239.62/31",
    "87.250.239.64/31",
    "87.250.239.68/31",
    "87.250.239.70/31",
    "87.250.239.72/31",
    "87.250.239.74/31",
    "87.250.239.78/31",
    "87.250.239.82/31",
    "87.250.239.88/31",
    "87.250.239.90/31",
    "87.250.239.96/31",
    "87.250.239.98/31",
    "87.250.239.100/30",
    "87.250.239.104/31",
    "87.250.239.106/31",
    "87.250.239.108/31",
    "87.250.239.110/31",
    "87.250.239.112/31",
    "87.250.239.114/31",
    "87.250.239.116/31",
    "87.250.239.118/31",
    "87.250.239.120/31",
    "87.250.239.122/31",
    "87.250.239.124/31",
    "87.250.239.126/31",
    "87.250.239.128/31",
    "87.250.239.130/31",
    "87.250.239.132/31",
    "87.250.239.134/31",
    "87.250.239.140/31",
    "87.250.239.142/31",
    "87.250.239.144/30",
    "87.250.239.148/31",
    "87.250.239.150/31",
    "87.250.239.152/31",
    "87.250.239.154/31",
    "87.250.239.156/30",
    "87.250.239.160/30",
    "87.250.239.164/30",
    "87.250.239.168/31",
    "87.250.239.170/31",
    "87.250.239.172/31",
    "87.250.239.174/31",
    "87.250.239.176/29",
    "87.250.239.184/31",
    "87.250.239.186/31",
    "87.250.240.0/24",
    "87.250.240.16/28",
    "87.250.240.48/29",
    "87.250.240.64/26",
    "87.250.240.128/25",
    "87.250.241.0/24",
    "87.250.241.192/26",
    "87.250.241.196/30",
    "87.250.241.200/29",
    "87.250.241.224/27",
    "87.250.242.0/24",
    "87.250.242.0/27",
    "87.250.242.128/27",
    "87.250.242.160/29",
    "87.250.242.168/29",
    "87.250.242.176/28",
    "87.250.242.208/28",
    "87.250.242.224/27",
    "87.250.243.0/24",
    "87.250.243.0/27",
    "87.250.243.32/28",
    "87.250.243.48/28",
    "87.250.243.64/26",
    "87.250.243.128/27",
    "87.250.243.160/27",
    "87.250.243.192/26",
    "87.250.244.0/24",
    "87.250.244.0/29",
    "87.250.244.8/29",
    "87.250.245.0/24",
    "87.250.246.0/24",
    "87.250.246.0/25",
    "87.250.246.128/27",
    "87.250.246.160/28",
    "87.250.246.176/28",
    "87.250.246.192/26",
    "87.250.247.0/24",
    "87.250.248.0/23",
    "87.250.248.0/24",
    "87.250.249.0/24",
    "87.250.249.4/30",
    "87.250.249.8/31",
    "87.250.249.10/31",
    "87.250.249.12/31",
    "87.250.249.14/31",
    "87.250.249.16/29",
    "87.250.249.24/29",
    "87.250.249.32/28",
    "87.250.249.128/25",
    "87.250.250.0/24",
    "87.250.251.0/24",
    "87.250.252.0/23",
    "87.250.252.0/25",
    "87.250.252.128/27",
    "87.250.252.160/28",
    "87.250.252.176/28",
    "87.250.252.192/26",
    "87.250.253.64/26",
    "87.250.253.128/25",
    "87.250.254.0/24",
    "87.250.255.0/24",
    "93.158.128.0/24",
    "93.158.129.0/24",
    "93.158.130.0/24",
    "93.158.130.0/26",
    "93.158.130.64/28",
    "93.158.130.80/28",
    "93.158.130.96/27",
    "93.158.130.128/25",
    "93.158.131.0/24",
    "93.158.131.252/30",
    "93.158.132.0/24",
    "93.158.132.0/27",
    "93.158.132.64/28",
    "93.158.132.96/27",
    "93.158.132.128/27",
    "93.158.132.160/27",
    "93.158.132.192/27",
    "93.158.132.224/27",
    "93.158.133.0/24",
    "93.158.133.0/26",
    "93.158.133.64/28",
    "93.158.133.80/28",
    "93.158.133.128/25",
    "93.158.133.192/28",
    "93.158.134.0/24",
    "93.158.135.0/24",
    "93.158.136.0/24",
    "93.158.136.0/27",
    "93.158.136.32/28",
    "93.158.136.48/28",
    "93.158.136.112/28",
    "93.158.136.128/27",
    "93.158.136.160/27",
    "93.158.136.192/27",
    "93.158.136.224/28",
    "93.158.136.240/28",
    "93.158.137.0/24",
    "93.158.138.0/23",
    "93.158.140.0/22",
    "93.158.140.0/24",
    "93.158.140.0/27",
    "93.158.140.32/27",
    "93.158.140.192/26",
    "93.158.141.0/26",
    "93.158.141.96/28",
    "93.158.141.112/28",
    "93.158.141.112/30",
    "93.158.141.128/25",
    "93.158.142.0/23",
    "93.158.144.0/23",
    "93.158.146.0/23",
    "93.158.146.0/24",
    "93.158.147.0/24",
    "93.158.148.0/22",
    "93.158.152.0/24",
    "93.158.153.0/24",
    "93.158.153.0/25",
    "93.158.153.192/26",
    "93.158.154.0/24",
    "93.158.155.0/24",
    "93.158.155.0/28",
    "93.158.155.16/29",
    "93.158.155.24/29",
    "93.158.155.32/27",
    "93.158.155.64/27",
    "93.158.155.96/29",
    "93.158.155.104/29",
    "93.158.155.112/28",
    "93.158.155.128/26",
    "93.158.155.192/27",
    "93.158.155.240/28",
    "93.158.156.0/24",
    "93.158.156.0/26",
    "93.158.156.64/27",
    "93.158.156.96/27",
    "93.158.156.128/26",
    "93.158.156.192/26",
    "93.158.157.0/24",
    "93.158.158.0/24",
    "93.158.158.0/26",
    "93.158.158.88/29",
    "93.158.158.98/31",
    "93.158.158.112/28",
    "93.158.158.128/26",
    "93.158.158.216/29",
    "93.158.158.224/28",
    "93.158.159.0/24",
    "93.158.161.0/24",
    "93.158.161.0/25",
    "93.158.163.96/27",
    "93.158.164.0/22",
    "93.158.168.0/22",
    "93.158.172.0/23",
    "93.158.174.0/24",
    "93.158.174.0/26",
    "93.158.174.132/30",
    "93.158.174.136/29",
    "93.158.174.196/31",
    "93.158.174.240/28",
    "93.158.175.0/24",
    "93.158.175.0/31",
    "93.158.175.2/31",
    "93.158.175.4/30",
    "93.158.175.8/29",
    "93.158.175.16/28",
    "93.158.175.32/27",
    "93.158.175.64/28",
    "93.158.175.80/29",
    "93.158.175.88/29",
    "93.158.175.128/29",
    "93.158.175.136/29",
    "93.158.175.144/29",
    "93.158.175.152/29",
    "93.158.175.192/27",
    "93.158.175.224/28",
    "93.158.175.240/28",
    "93.158.176.0/24",
    "93.158.176.0/25",
    "93.158.176.128/28",
    "93.158.176.144/28",
    "93.158.176.160/27",
    "93.158.176.192/26",
    "93.158.178.0/24",
    "93.158.178.0/26",
    "93.158.178.64/28",
    "93.158.178.80/29",
    "93.158.178.88/29",
    "93.158.178.128/25",
    "93.158.178.128/26",
    "93.158.178.192/26",
    "93.158.180.0/22",
    "93.158.184.0/22",
    "93.158.188.0/22",
    "93.158.188.0/23",
    "93.158.190.0/23",
    "95.108.128.0/20",
    "95.108.128.0/24",
    "95.108.129.0/26",
    "95.108.129.128/26",
    "95.108.129.192/27",
    "95.108.129.224/29",
    "95.108.129.232/29",
    "95.108.129.240/28",
    "95.108.130.0/23",
    "95.108.130.0/24",
    "95.108.131.0/24",
    "95.108.132.0/27",
    "95.108.132.32/27",
    "95.108.132.64/26",
    "95.108.132.128/27",
    "95.108.132.160/27",
    "95.108.132.200/29",
    "95.108.132.208/28",
    "95.108.133.0/27",
    "95.108.133.32/27",
    "95.108.133.128/26",
    "95.108.134.0/25",
    "95.108.134.128/25",
    "95.108.135.128/25",
    "95.108.136.0/26",
    "95.108.136.64/26",
    "95.108.136.128/26",
    "95.108.136.192/26",
    "95.108.136.200/29",
    "95.108.136.208/29",
    "95.108.136.232/29",
    "95.108.137.0/27",
    "95.108.137.64/26",
    "95.108.137.128/27",
    "95.108.137.160/29",
    "95.108.137.168/29",
    "95.108.137.192/26",
    "95.108.138.0/23",
    "95.108.138.0/24",
    "95.108.139.0/24",
    "95.108.140.0/23",
    "95.108.142.0/24",
    "95.108.144.0/24",
    "95.108.145.0/24",
    "95.108.146.32/28",
    "95.108.146.32/31",
    "95.108.146.34/31",
    "95.108.146.36/31",
    "95.108.146.48/28",
    "95.108.147.0/24",
    "95.108.148.0/26",
    "95.108.148.96/27",
    "95.108.148.96/29",
    "95.108.148.104/29",
    "95.108.148.112/29",
    "95.108.148.120/29",
    "95.108.148.128/26",
    "95.108.149.0/24",
    "95.108.150.0/23",
    "95.108.152.0/22",
    "95.108.156.0/23",
    "95.108.158.0/26",
    "95.108.158.96/27",
    "95.108.158.128/25",
    "95.108.159.0/24",
    "95.108.160.0/20",
    "95.108.160.0/21",
    "95.108.168.0/21",
    "95.108.168.0/28",
    "95.108.168.16/28",
    "95.108.168.32/27",
    "95.108.168.64/27",
    "95.108.168.96/27",
    "95.108.168.128/25",
    "95.108.169.0/25",
    "95.108.169.128/25",
    "95.108.170.0/24",
    "95.108.171.0/24",
    "95.108.171.0/25",
    "95.108.171.128/25",
    "95.108.172.0/22",
    "95.108.176.0/24",
    "95.108.176.0/28",
    "95.108.176.0/29",
    "95.108.176.8/29",
    "95.108.176.16/29",
    "95.108.176.24/29",
    "95.108.176.32/29",
    "95.108.176.40/29",
    "95.108.176.64/27",
    "95.108.176.96/27",
    "95.108.176.128/26",
    "95.108.176.192/27",
    "95.108.176.224/29",
    "95.108.176.232/29",
    "95.108.176.240/29",
    "95.108.177.0/24",
    "95.108.177.0/25",
    "95.108.178.0/24",
    "95.108.178.0/26",
    "95.108.178.64/26",
    "95.108.178.128/29",
    "95.108.178.136/29",
    "95.108.178.144/29",
    "95.108.178.152/29",
    "95.108.178.160/28",
    "95.108.178.176/28",
    "95.108.178.192/27",
    "95.108.178.224/28",
    "95.108.178.240/28",
    "95.108.179.0/24",
    "95.108.180.0/24",
    "95.108.180.0/28",
    "95.108.180.16/29",
    "95.108.180.24/29",
    "95.108.181.0/24",
    "95.108.181.0/25",
    "95.108.181.104/30",
    "95.108.181.108/30",
    "95.108.181.120/29",
    "95.108.181.128/25",
    "95.108.181.128/26",
    "95.108.181.128/30",
    "95.108.181.132/30",
    "95.108.181.136/30",
    "95.108.181.140/30",
    "95.108.181.144/30",
    "95.108.181.148/30",
    "95.108.181.152/30",
    "95.108.181.156/30",
    "95.108.181.160/30",
    "95.108.181.164/30",
    "95.108.181.168/30",
    "95.108.181.172/30",
    "95.108.181.176/28",
    "95.108.181.192/27",
    "95.108.181.200/29",
    "95.108.181.208/30",
    "95.108.181.212/30",
    "95.108.181.216/30",
    "95.108.181.240/29",
    "95.108.181.248/29",
    "95.108.183.0/24",
    "95.108.183.0/25",
    "95.108.184.0/23",
    "95.108.186.0/24",
    "95.108.188.0/22",
    "95.108.188.0/28",
    "95.108.188.16/28",
    "95.108.188.32/28",
    "95.108.188.48/28",
    "95.108.188.64/26",
    "95.108.188.128/25",
    "95.108.189.0/27",
    "95.108.189.0/29",
    "95.108.189.64/27",
    "95.108.189.96/29",
    "95.108.189.104/30",
    "95.108.189.112/28",
    "95.108.189.128/26",
    "95.108.189.192/26",
    "95.108.193.0/24",
    "95.108.194.0/24",
    "95.108.194.0/27",
    "95.108.194.32/28",
    "95.108.194.48/28",
    "95.108.194.64/26",
    "95.108.194.64/30",
    "95.108.194.68/30",
    "95.108.194.72/30",
    "95.108.194.76/30",
    "95.108.194.80/30",
    "95.108.194.84/30",
    "95.108.194.88/30",
    "95.108.194.92/30",
    "95.108.194.96/30",
    "95.108.194.100/30",
    "95.108.194.104/30",
    "95.108.194.108/30",
    "95.108.194.112/30",
    "95.108.194.116/30",
    "95.108.194.120/30",
    "95.108.194.124/30",
    "95.108.194.128/26",
    "95.108.194.192/28",
    "95.108.194.208/28",
    "95.108.194.224/28",
    "95.108.194.240/28",
    "95.108.195.0/24",
    "95.108.196.0/24",
    "95.108.196.0/25",
    "95.108.197.0/24",
    "95.108.197.16/28",
    "95.108.197.32/27",
    "95.108.197.96/29",
    "95.108.197.112/28",
    "95.108.197.208/28",
    "95.108.197.224/27",
    "95.108.198.0/23",
    "95.108.198.0/24",
    "95.108.198.0/27",
    "95.108.198.32/29",
    "95.108.198.40/29",
    "95.108.198.48/28",
    "95.108.198.64/27",
    "95.108.198.96/29",
    "95.108.198.104/29",
    "95.108.198.112/28",
    "95.108.198.128/27",
    "95.108.198.164/30",
    "95.108.198.168/29",
    "95.108.198.176/28",
    "95.108.198.192/27",
    "95.108.198.224/27",
    "95.108.199.0/24",
    "95.108.199.0/26",
    "95.108.199.64/26",
    "95.108.199.128/27",
    "95.108.199.160/29",
    "95.108.199.168/29",
    "95.108.199.176/28",
    "95.108.199.192/27",
    "95.108.199.224/27",
    "95.108.200.0/22",
    "95.108.200.0/24",
    "95.108.201.0/25",
    "95.108.202.0/23",
    "95.108.204.0/23",
    "95.108.204.0/24",
    "95.108.205.0/24",
    "95.108.206.0/24",
    "95.108.207.0/24",
    "95.108.207.0/27",
    "95.108.207.128/25",
    "95.108.212.0/24",
    "95.108.212.0/26",
    "95.108.212.64/26",
    "95.108.212.128/26",
    "95.108.212.192/26",
    "95.108.213.0/24",
    "95.108.214.0/23",
    "95.108.214.0/24",
    "95.108.216.0/23",
    "95.108.218.0/23",
    "95.108.220.128/28",
    "95.108.220.160/27",
    "95.108.221.0/24",
    "95.108.222.0/23",
    "95.108.224.0/21",
    "95.108.224.0/24",
    "95.108.224.0/25",
    "95.108.224.0/26",
    "95.108.224.64/26",
    "95.108.224.128/26",
    "95.108.225.0/27",
    "95.108.225.0/29",
    "95.108.225.8/29",
    "95.108.225.16/29",
    "95.108.225.24/29",
    "95.108.225.32/28",
    "95.108.225.48/28",
    "95.108.225.64/29",
    "95.108.225.72/29",
    "95.108.225.80/29",
    "95.108.225.88/29",
    "95.108.225.96/27",
    "95.108.225.128/26",
    "95.108.225.192/27",
    "95.108.225.224/27",
    "95.108.226.0/24",
    "95.108.227.0/24",
    "95.108.228.0/23",
    "95.108.230.0/24",
    "95.108.231.0/24",
    "95.108.232.0/22",
    "95.108.232.0/24",
    "95.108.232.128/26",
    "95.108.233.0/24",
    "95.108.234.0/23",
    "95.108.234.0/24",
    "95.108.235.0/24",
    "95.108.236.0/24",
    "95.108.236.0/26",
    "95.108.236.64/26",
    "95.108.236.128/27",
    "95.108.236.160/29",
    "95.108.236.168/30",
    "95.108.236.172/30",
    "95.108.236.176/28",
    "95.108.236.192/26",
    "95.108.237.0/24",
    "95.108.237.0/25",
    "95.108.237.128/25",
    "95.108.238.0/23",
    "95.108.240.0/21",
    "95.108.240.0/23",
    "95.108.242.0/29",
    "95.108.242.8/29",
    "95.108.242.16/28",
    "95.108.242.32/27",
    "95.108.242.64/26",
    "95.108.242.128/25",
    "95.108.243.0/24",
    "95.108.244.0/22",
    "95.108.244.0/23",
    "95.108.246.0/23",
    "95.108.248.0/23",
    "95.108.250.0/23",
    "95.108.252.0/23",
    "95.108.252.0/24",
    "95.108.253.0/24",
    "95.108.254.0/24",
    "95.108.255.0/24",
    "95.108.255.0/27",
    "95.108.255.32/27",
    "95.108.255.64/26",
    "95.108.255.128/25",
    "100.43.64.0/20",
    "100.43.78.0/24",
    "100.43.78.8/29",
    "100.43.78.192/26",
    "100.43.80.0/20",
    "100.43.81.128/27",
    "100.43.85.0/27",
    "100.43.86.168/29",
    "100.43.86.176/28",
    "100.43.87.0/24",
    "100.43.90.0/27",
    "100.43.91.0/27",
    "100.43.92.0/27",
    "100.43.92.32/27",
    "100.43.92.64/27",
    "100.43.92.96/27",
    "100.43.92.128/28",
    "100.43.92.144/28",
    "100.43.92.160/29",
    "100.43.92.168/29",
    "100.43.92.176/31",
    "100.43.93.0/24",
    "100.43.94.0/25",
    "130.193.37.0/24",
    "130.193.37.0/28",
    "130.193.37.16/28",
    "130.193.37.32/29",
    "130.193.37.40/29",
    "130.193.37.52/31",
    "130.193.37.56/31",
    "130.193.37.96/27",
    "130.193.38.0/23",
    "130.193.44.0/24",
    "130.193.45.0/24",
    "130.193.45.0/26",
    "130.193.45.64/26",
    "130.193.45.128/27",
    "130.193.45.160/28",
    "130.193.45.176/28",
    "130.193.45.192/26",
    "130.193.45.192/27",
    "130.193.45.224/27",
    "130.193.46.0/23",
    "130.193.46.0/24",
    "130.193.47.0/24",
    "130.193.56.0/23",
    "130.193.56.0/24",
    "130.193.59.0/24",
    "130.193.62.0/23",
    "130.193.62.0/26",
    "130.193.62.64/29",
    "130.193.62.72/29",
    "130.193.62.80/28",
    "130.193.62.96/27",
    "130.193.62.128/25",
    "130.193.63.0/24",
    "141.8.128.0/22",
    "141.8.132.0/22",
    "141.8.132.0/24",
    "141.8.133.0/24",
    "141.8.134.0/23",
    "141.8.136.0/21",
    "141.8.136.0/29",
    "141.8.136.8/29",
    "141.8.136.128/25",
    "141.8.144.0/24",
    "141.8.144.0/25",
    "141.8.144.128/29",
    "141.8.144.136/29",
    "141.8.144.144/29",
    "141.8.144.152/29",
    "141.8.144.160/29",
    "141.8.144.176/29",
    "141.8.144.184/29",
    "141.8.144.192/26",
    "141.8.145.0/24",
    "141.8.146.0/24",
    "141.8.147.0/24",
    "141.8.147.0/27",
    "141.8.148.0/22",
    "141.8.152.0/24",
    "141.8.152.32/28",
    "141.8.153.0/24",
    "141.8.153.0/26",
    "141.8.153.64/27",
    "141.8.153.64/29",
    "141.8.153.96/29",
    "141.8.153.104/29",
    "141.8.153.112/28",
    "141.8.153.128/25",
    "141.8.154.0/24",
    "141.8.154.64/26",
    "141.8.154.128/30",
    "141.8.154.134/31",
    "141.8.154.136/31",
    "141.8.154.144/29",
    "141.8.154.192/29",
    "141.8.154.200/29",
    "141.8.154.208/28",
    "141.8.154.240/28",
    "141.8.155.0/24",
    "141.8.155.0/26",
    "141.8.155.64/27",
    "141.8.155.96/29",
    "141.8.156.0/22",
    "141.8.156.0/24",
    "141.8.157.0/28",
    "141.8.157.16/29",
    "141.8.157.24/29",
    "141.8.157.32/27",
    "141.8.157.64/26",
    "141.8.157.128/26",
    "141.8.157.192/26",
    "141.8.158.0/24",
    "141.8.159.0/26",
    "141.8.159.64/26",
    "141.8.159.128/25",
    "141.8.160.0/21",
    "141.8.160.0/25",
    "141.8.160.128/25",
    "141.8.162.0/23",
    "141.8.164.0/25",
    "141.8.164.128/26",
    "141.8.164.192/27",
    "141.8.164.192/29",
    "141.8.164.224/27",
    "141.8.165.0/24",
    "141.8.166.0/24",
    "141.8.168.0/24",
    "141.8.169.0/24",
    "141.8.170.0/23",
    "141.8.172.0/23",
    "141.8.172.0/25",
    "141.8.173.0/25",
    "141.8.173.128/26",
    "141.8.173.192/27",
    "141.8.173.224/27",
    "141.8.174.0/24",
    "141.8.174.0/25",
    "141.8.174.128/27",
    "141.8.174.160/29",
    "141.8.174.168/29",
    "141.8.174.176/29",
    "141.8.174.184/30",
    "141.8.174.188/30",
    "141.8.174.192/26",
    "141.8.175.0/24",
    "141.8.175.0/28",
    "141.8.175.16/31",
    "141.8.175.18/31",
    "141.8.175.20/30",
    "141.8.175.24/29",
    "141.8.175.32/28",
    "141.8.175.48/29",
    "141.8.175.56/29",
    "141.8.175.64/26",
    "141.8.175.192/29",
    "141.8.175.200/29",
    "141.8.175.208/31",
    "141.8.175.224/27",
    "141.8.176.0/24",
    "141.8.177.0/24",
    "141.8.178.0/23",
    "141.8.178.0/25",
    "141.8.178.8/29",
    "141.8.178.16/29",
    "141.8.178.24/29",
    "141.8.178.32/29",
    "141.8.178.40/29",
    "141.8.178.48/29",
    "141.8.178.128/25",
    "141.8.179.0/24",
    "141.8.180.0/22",
    "141.8.180.0/24",
    "141.8.181.0/24",
    "141.8.182.0/27",
    "141.8.182.32/27",
    "141.8.182.64/26",
    "141.8.182.128/26",
    "141.8.182.192/28",
    "141.8.182.208/28",
    "141.8.182.224/29",
    "141.8.182.232/29",
    "141.8.182.240/28",
    "141.8.183.0/24",
    "141.8.184.0/22",
    "141.8.184.0/24",
    "141.8.185.0/29",
    "141.8.185.8/29",
    "141.8.188.0/24",
    "141.8.188.0/27",
    "141.8.188.32/27",
    "141.8.188.128/25",
    "141.8.189.0/24",
    "141.8.189.0/26",
    "141.8.189.64/28",
    "141.8.189.80/28",
    "141.8.189.96/27",
    "141.8.189.128/27",
    "141.8.189.160/27",
    "141.8.189.192/27",
    "141.8.189.224/28",
    "141.8.189.240/29",
    "141.8.189.248/29",
    "141.8.190.0/23",
    "141.8.190.0/24",
    "141.8.191.0/26",
    "141.8.191.64/26",
    "141.8.191.128/26",
    "141.8.191.192/28",
    "141.8.191.208/28",
    "141.8.191.224/27",
    "178.154.128.0/24",
    "178.154.128.0/25",
    "178.154.128.128/25",
    "178.154.129.0/24",
    "178.154.129.0/25",
    "178.154.129.0/29",
    "178.154.129.8/29",
    "178.154.129.16/29",
    "178.154.129.24/29",
    "178.154.129.32/29",
    "178.154.129.128/25",
    "178.154.129.128/29",
    "178.154.129.136/29",
    "178.154.130.0/24",
    "178.154.130.0/26",
    "178.154.130.64/27",
    "178.154.130.112/30",
    "178.154.130.116/30",
    "178.154.130.128/25",
    "178.154.131.0/24",
    "178.154.132.0/22",
    "178.154.140.0/23",
    "178.154.142.0/23",
    "178.154.142.0/24",
    "178.154.143.0/24",
    "178.154.144.0/22",
    "178.154.148.0/22",
    "178.154.148.0/24",
    "178.154.149.0/24",
    "178.154.150.0/24",
    "178.154.151.0/24",
    "178.154.152.0/24",
    "178.154.152.0/25",
    "178.154.152.128/26",
    "178.154.152.192/26",
    "178.154.153.0/24",
    "178.154.154.0/23",
    "178.154.154.0/24",
    "178.154.155.0/24",
    "178.154.156.0/22",
    "178.154.160.0/21",
    "178.154.160.0/23",
    "178.154.162.0/23",
    "178.154.164.0/23",
    "178.154.166.0/27",
    "178.154.166.32/27",
    "178.154.166.64/26",
    "178.154.166.128/25",
    "178.154.167.0/25",
    "178.154.168.0/23",
    "178.154.168.64/27",
    "178.154.168.104/29",
    "178.154.168.112/28",
    "178.154.168.128/25",
    "178.154.170.0/24",
    "178.154.171.0/24",
    "178.154.172.0/23",
    "178.154.174.0/23",
    "178.154.176.0/22",
    "178.154.176.0/23",
    "178.154.178.0/23",
    "178.154.180.0/23",
    "178.154.182.0/23",
    "178.154.182.0/24",
    "178.154.183.0/24",
    "178.154.184.0/23",
    "178.154.186.0/26",
    "178.154.188.0/22",
    "178.154.188.0/28",
    "178.154.188.16/28",
    "178.154.188.32/27",
    "178.154.188.64/26",
    "178.154.188.128/26",
    "178.154.188.128/27",
    "178.154.188.160/29",
    "178.154.188.168/29",
    "178.154.188.176/29",
    "178.154.188.192/26",
    "178.154.189.0/25",
    "178.154.189.128/27",
    "178.154.189.160/28",
    "178.154.189.176/28",
    "178.154.189.192/26",
    "178.154.190.0/25",
    "178.154.190.128/25",
    "178.154.191.0/27",
    "178.154.191.32/28",
    "178.154.191.64/27",
    "178.154.191.96/27",
    "178.154.191.128/27",
    "178.154.191.160/28",
    "178.154.191.176/28",
    "178.154.191.192/28",
    "178.154.191.208/29",
    "178.154.191.216/29",
    "178.154.191.224/27",
    "178.154.224.0/23",
    "178.154.224.0/24",
    "178.154.224.0/27",
    "178.154.224.32/28",
    "178.154.224.48/28",
    "178.154.224.64/26",
    "178.154.224.128/25",
    "178.154.225.0/26",
    "178.154.225.64/26",
    "178.154.225.192/26",
    "178.154.228.0/22",
    "178.154.232.0/21",
    "178.154.232.0/23",
    "178.154.232.0/24",
    "178.154.233.0/24",
    "178.154.234.0/24",
    "178.154.235.0/24",
    "178.154.235.0/25",
    "178.154.236.0/24",
    "178.154.237.0/24",
    "178.154.238.0/24",
    "178.154.239.0/25",
    "178.154.239.128/26",
    "178.154.239.192/26",
    "178.154.240.0/21",
    "178.154.240.0/23",
    "178.154.242.0/24",
    "178.154.243.0/28",
    "178.154.243.16/28",
    "178.154.243.32/29",
    "178.154.243.64/26",
    "178.154.243.128/25",
    "178.154.244.0/22",
    "178.154.244.0/24",
    "178.154.245.0/26",
    "178.154.245.64/28",
    "178.154.245.80/28",
    "178.154.245.96/27",
    "178.154.245.128/26",
    "178.154.245.192/26",
    "178.154.246.0/23",
    "178.154.248.0/21",
    "178.154.248.0/24",
    "178.154.249.0/24",
    "178.154.250.0/24",
    "178.154.251.0/24",
    "178.154.252.0/24",
    "178.154.253.8/29",
    "178.154.253.16/28",
    "178.154.253.32/27",
    "178.154.253.64/26",
    "178.154.253.128/25",
    "178.154.254.0/28",
    "178.154.254.32/27",
    "178.154.254.64/27",
    "178.154.254.96/28",
    "178.154.254.112/28",
    "178.154.254.128/27",
    "178.154.254.160/27",
    "178.154.254.192/27",
    "178.154.254.224/27",
    "178.154.255.0/25",
    "178.154.255.0/28",
    "178.154.255.128/27",
    "178.154.255.160/27",
    "178.154.255.192/27",
    "178.154.255.192/29",
    "178.154.255.224/28",
    "178.154.255.240/28",
    "185.32.184.0/24",
    "185.32.184.0/25",
    "185.32.184.128/28",
    "185.32.184.144/28",
    "185.32.184.160/30",
    "185.32.184.164/31",
    "185.32.184.166/31",
    "185.32.184.168/29",
    "185.32.185.0/24",
    "185.32.185.0/30",
    "185.32.185.4/31",
    "185.32.185.6/31",
    "185.32.185.8/31",
    "185.32.185.10/31",
    "185.32.185.16/29",
    "185.32.185.24/29",
    "185.32.185.32/27",
    "185.32.185.64/26",
    "185.32.185.128/28",
    "185.32.185.144/29",
    "185.32.185.152/29",
    "185.32.185.160/28",
    "185.32.185.176/29",
    "185.32.185.184/29",
    "185.32.185.192/29",
    "185.32.185.200/29",
    "185.32.185.208/29",
    "185.32.186.0/23",
    "199.21.96.0/24",
    "199.21.97.0/25",
    "199.21.97.128/26",
    "199.21.97.192/26",
    "199.21.98.0/24",
    "199.21.98.0/25",
    "199.21.98.128/27",
    "199.21.98.160/27",
    "199.21.98.192/26",
    "199.21.99.0/27",
    "199.21.99.32/28",
    "199.21.99.48/28",
    "199.21.99.128/27",
    "199.21.99.160/31",
    "199.21.99.162/31",
    "199.21.99.168/29",
    "199.21.99.192/27",
    "199.36.240.8/29",
    "199.36.240.64/26",
    "199.36.240.128/25",
    "199.36.242.0/23",
    "213.180.192.0/24",
    "213.180.193.0/24",
    "213.180.194.0/24",
    "213.180.194.64/29",
    "213.180.194.96/29",
    "213.180.195.0/24",
    "213.180.197.0/24",
    "213.180.197.0/26",
    "213.180.198.0/24",
    "213.180.199.0/24",
    "213.180.200.0/24",
    "213.180.200.0/25",
    "213.180.200.128/26",
    "213.180.200.192/29",
    "213.180.200.200/29",
    "213.180.200.208/28",
    "213.180.200.224/28",
    "213.180.200.240/28",
    "213.180.201.0/24",
    "213.180.201.0/28",
    "213.180.201.16/30",
    "213.180.201.20/30",
    "213.180.201.24/29",
    "213.180.201.32/27",
    "213.180.201.80/29",
    "213.180.201.88/29",
    "213.180.201.96/27",
    "213.180.201.128/27",
    "213.180.201.192/26",
    "213.180.202.0/24",
    "213.180.203.0/24",
    "213.180.203.0/31",
    "213.180.203.2/31",
    "213.180.203.4/30",
    "213.180.203.16/28",
    "213.180.203.32/29",
    "213.180.203.40/31",
    "213.180.203.42/31",
    "213.180.203.44/31",
    "213.180.203.46/31",
    "213.180.203.48/28",
    "213.180.203.64/29",
    "213.180.204.0/24",
    "213.180.205.0/24",
    "213.180.206.0/23",
    "213.180.206.0/27",
    "213.180.206.32/28",
    "213.180.206.52/30",
    "213.180.206.56/29",
    "213.180.206.64/26",
    "213.180.206.128/27",
    "213.180.206.160/28",
    "213.180.206.176/28",
    "213.180.206.192/28",
    "213.180.206.208/29",
    "213.180.206.216/29",
    "213.180.206.224/28",
    "213.180.206.240/28",
    "213.180.207.0/24",
    "213.180.208.0/24",
    "213.180.208.0/29",
    "213.180.208.16/30",
    "213.180.208.24/29",
    "213.180.208.32/30",
    "213.180.208.48/29",
    "213.180.208.56/30",
    "213.180.208.80/29",
    "213.180.208.96/29",
    "213.180.209.0/24",
    "213.180.209.0/31",
    "213.180.209.2/31",
    "213.180.209.4/30",
    "213.180.209.8/31",
    "213.180.209.16/28",
    "213.180.209.64/29",
    "213.180.209.96/27",
    "213.180.209.128/26",
    "213.180.209.192/28",
    "213.180.209.208/28",
    "213.180.209.224/29",
    "213.180.209.232/29",
    "213.180.209.240/28",
    "213.180.210.0/26",
    "213.180.210.0/30",
    "213.180.210.4/30",
    "213.180.210.64/26",
    "213.180.210.64/28",
    "213.180.210.128/25",
    "213.180.211.0/24",
    "213.180.212.0/24",
    "213.180.212.0/27",
    "213.180.212.32/28",
    "213.180.212.48/28",
    "213.180.212.64/26",
    "213.180.212.64/30",
    "213.180.212.68/30",
    "213.180.212.72/30",
    "213.180.212.76/30",
    "213.180.212.80/30",
    "213.180.212.84/30",
    "213.180.212.88/30",
    "213.180.212.92/30",
    "213.180.212.96/30",
    "213.180.212.100/30",
    "213.180.212.104/30",
    "213.180.212.108/30",
    "213.180.212.112/30",
    "213.180.212.116/30",
    "213.180.212.120/30",
    "213.180.212.124/30",
    "213.180.212.128/25",
    "213.180.213.0/24",
    "213.180.213.0/25",
    "213.180.213.0/31",
    "213.180.213.2/31",
    "213.180.213.4/31",
    "213.180.213.6/31",
    "213.180.213.8/31",
    "213.180.213.10/31",
    "213.180.213.12/31",
    "213.180.213.14/31",
    "213.180.213.20/31",
    "213.180.213.22/31",
    "213.180.213.24/31",
    "213.180.213.26/31",
    "213.180.213.28/31",
    "213.180.213.30/31",
    "213.180.213.32/31",
    "213.180.213.34/31",
    "213.180.213.38/31",
    "213.180.213.40/31",
    "213.180.213.50/31",
    "213.180.213.52/31",
    "213.180.213.56/29",
    "213.180.213.66/31",
    "213.180.213.68/31",
    "213.180.213.70/31",
    "213.180.213.72/31",
    "213.180.213.74/31",
    "213.180.213.88/31",
    "213.180.213.96/31",
    "213.180.213.100/31",
    "213.180.213.102/31",
    "213.180.213.104/29",
    "213.180.213.112/31",
    "213.180.213.114/31",
    "213.180.213.116/31",
    "213.180.213.118/31",
    "213.180.213.120/31",
    "213.180.213.122/31",
    "213.180.213.124/31",
    "213.180.213.126/31",
    "213.180.213.128/25",
    "213.180.213.128/28",
    "213.180.213.144/29",
    "213.180.213.152/29",
    "213.180.213.160/29",
    "213.180.213.168/29",
    "213.180.213.176/29",
    "213.180.213.184/31",
    "213.180.213.192/31",
    "213.180.213.194/31",
    "213.180.213.200/29",
    "213.180.213.208/29",
    "213.180.214.0/24",
    "213.180.215.0/24",
    "213.180.215.0/27",
    "213.180.215.32/28",
    "213.180.215.64/26",
    "213.180.215.128/26",
    "213.180.215.192/26",
    "213.180.216.0/22",
    "213.180.220.0/23",
    "213.180.220.8/29",
    "213.180.220.16/28",
    "213.180.220.32/27",
    "213.180.220.64/28",
    "213.180.220.80/29",
    "213.180.220.88/29",
    "213.180.220.96/27",
    "213.180.220.128/28",
    "213.180.220.144/28",
    "213.180.220.160/29",
    "213.180.220.168/29",
    "213.180.220.176/29",
    "213.180.220.192/28",
    "213.180.220.208/29",
    "213.180.220.224/27",
    "213.180.221.0/26",
    "213.180.221.128/25",
    "213.180.222.0/24",
    "213.180.222.0/27",
    "213.180.222.32/27",
    "213.180.222.224/30",
    "213.180.222.240/28",
    "213.180.223.0/24",
    "213.180.223.0/29",
    "213.180.223.8/29",
    "213.180.223.16/30",
    "213.180.223.20/31",
    "213.180.223.22/31",
    "213.180.223.32/27",
    "213.180.223.128/25",
]


IP_AND_MASK = [(ip_to_num(ipStr), CalcMask(int(maskStr))) for ipStr, maskStr in [subnet.split('/') for subnet in YANDEX_SUBNETS]]


def is_yandex(ip):
    for yandexIp, yandexMask in IP_AND_MASK:
        if ip & yandexMask == yandexIp:
            return True

    return False


def main():
    inMapReduce = len(sys.argv) > 1 and sys.argv[1] == "-m"

    if inMapReduce:
        for line in sys.stdin:
            iterLine = iter(line)

            ipStart = 0
            for c in iterLine:
                if not c.isspace():
                    break
                ipStart += 1

            ipEnd = ipStart
            for c in iterLine:
                ipEnd += 1
                if not c.isdigit() and c != ".":
                    break

            try:
                ip = ip_to_num(line[ipStart:ipEnd])
            except:
                raise Exception("invalid ip in line '%s', ipStart = %d, ipEnd = %d, ip = '%s'" % (line, ipStart, ipEnd, line[ipStart:ipEnd]))

            if not is_yandex(ip):
                print line,
    else:
        for line in sys.stdin:
            i = 0
            for c in line:
                if not c.isdigit() and c != ".":
                    break
                i += 1

            try:
                ip = ip_to_num(line[:i])
            except:
                raise Exception("invalid ip in line '%s', i = %d, ip = '%s'" % (line, i, line[:i]))

            if not is_yandex(ip):
                print line,


if __name__ == "__main__":
    main()
