OWNER(g:yatool)

INCLUDE(${ARCADIA_ROOT}/autocheck/common_targets.inc)

SET_APPEND(AUTOCHECK_LINUX_TARGETS
    ${AUTOCHECK_COMMON_TARGETS}
    autocheck/tests
)

IF(MAPSMOBI_BUILD_TARGET)
    INCLUDE(${ARCADIA_ROOT}/autocheck/mapsmobi_targets.inc)
    SET(AUTOCHECK_LINUX_TARGETS ${AUTOCHECK_MAPSMOBI_TARGETS})
ELSEIF (TSTRING_IS_STD_STRING)
    INCLUDE(${CURDIR}/tstring_is_std_string_targets.inc)
    SET(AUTOCHECK_LINUX_TARGETS ${AUTOCHECK_TSTRING_IS_STD_STRING_TARGETS})
ELSEIF (YANDEXIO_BUILD_TARGET)
    # TODO: remove unnecessary when https://st.yandex-team.ru/QUASAR-5576 will be done
    INCLUDE(${CURDIR}/yandexio_targets.inc)
    SET(AUTOCHECK_LINUX_TARGETS ${AUTOCHECK_YANDEXIO_TARGETS})
ELSEIF (ARCH_AARCH64)
    INCLUDE(${CURDIR}/aarch64_targets.inc)
ELSEIF(AUTOCHECK_TEMPORARY_EMPTY_PROJECTS)
    SET(AUTOCHECK_LINUX_TARGETS)
ELSEIF (ARCH_PPC64LE)
    INCLUDE(${CURDIR}/ppc64le_targets.inc)
ELSEIF (MUSL)
    INCLUDE(${CURDIR}/musl_targets.inc)
ELSEIF (FUZZY_TESTS)
    INCLUDE(${CURDIR}/fuzzy_tests_targets.inc)
ELSEIF (SANITIZER_TYPE)
    SET(AUTOCHECK_BALANCING_OPTIONS
        BALANCING_CONFIG autocheck/balancing_configs/autocheck-sanitizers.json
    )
    INCLUDE(${CURDIR}/sanitizer_common_targets.inc)
    IF (SANITIZER_TYPE == "address")
        INCLUDE(${CURDIR}/sanitizer_address_targets.inc)
    ENDIF()
    IF (SANITIZER_TYPE == "memory")
        INCLUDE(${CURDIR}/sanitizer_memory_targets.inc)
    ENDIF()
    IF (SANITIZER_TYPE == "thread")
        INCLUDE(${CURDIR}/sanitizer_thread_targets.inc)
    ENDIF()
ELSEIF (USE_STL_SYSTEM)
    INCLUDE(${CURDIR}/system_stl_targets.inc)
ELSEIF (GCC)
    INCLUDE(${CURDIR}/gcc_targets.inc)
ELSEIF (NOT CGO_ENABLED)
    INCLUDE(${CURDIR}/cgo_targets.inc)
ELSEIF (RACE)
    INCLUDE(${CURDIR}/go_race_targets.inc)
ELSEIF (TENSORFLOW_WITH_CUDA)
    INCLUDE(${CURDIR}/tensorflow_with_cuda_targets.inc)
ELSEIF (JDK_VERSION == "8")
    INCLUDE(${CURDIR}/jdk8_targets.inc)
ELSEIF (JDK_VERSION == "15")
    INCLUDE(${CURDIR}/jdk15_targets.inc)
    SET(AUTOCHECK_LINUX_TARGETS ${AUTOCHECK_JDK15_TARGETS})
ELSEIF (JDK_VERSION == "16")
    INCLUDE(${CURDIR}/jdk16_targets.inc)
    SET(AUTOCHECK_LINUX_TARGETS ${AUTOCHECK_JDK16_TARGETS})
ELSEIF (USE_FPGA)
    INCLUDE(${CURDIR}/fpga_targets.inc)
ELSEIF (HARDENING)
    INCLUDE(${CURDIR}/hardening_targets.inc)
ELSEIF (SANDBOXING AND NOT CONTRIB_METRICS)
    INCLUDE(${CURDIR}/sandboxing_targets.inc)
ELSEIF (OPENSOURCE)
    INCLUDE(${CURDIR}/opensource_targets.inc)
ELSEIF (USE_SYSTEM_PYTHON == "2.7")
    INCLUDE(${CURDIR}/system_python27_targets.inc)
ELSEIF (USE_SYSTEM_PYTHON == "3.5")
    INCLUDE(${CURDIR}/system_python35_targets.inc)
ELSEIF (USE_SYSTEM_PYTHON == "3.6")
    INCLUDE(${CURDIR}/system_python36_targets.inc)
ELSEIF (TIDY)
    INCLUDE(${CURDIR}/clang_tidy_targets.inc)
ELSE()
    SET(AUTOCHECK_BALANCING_OPTIONS
        BALANCING_CONFIG autocheck/balancing_configs/autocheck-linux.json
    )
    INCLUDE(${CURDIR}/linux_targets.inc)
ENDIF()

PARTITIONED_RECURSE_ROOT_RELATIVE(
    ${AUTOCHECK_BALANCING_OPTIONS}
    ${AUTOCHECK_LINUX_TARGETS}
)
