import os
import json
import logging

import yatest.common
import pytest
import yaml


EXPECTED_FIELDS = set(['host_platform_flags', 'autocheck_build_vars', 'ignored_toolchains', 'target_platforms', 'toolchain_transforms'])

PARTITITION_LIST_FIELDS = ['graph_generation_requirements', 'coordinator_filters']

DEFAULT_KEY = "default"


def check_config(config_path):
    with open(config_path) as fp:
        conf_json = json.load(fp)

    assert set(conf_json.keys()) == EXPECTED_FIELDS


@pytest.mark.parametrize('config_name', filter(lambda s: s.endswith('.json'), os.listdir(yatest.common.source_path('autocheck'))))
def test_autocheck_json(config_name):
    logging.debug('analize %s', config_name)
    config_path = os.path.join(yatest.common.source_path('autocheck'), config_name)
    check_config(config_path)


def _check_partition_prop(values, count):
    icnt = 0
    for key in values:
        try:
            ikey = int(key)
            assert(ikey >= 0 and ikey < count)
            icnt += 1
        except ValueError:
            assert(key == DEFAULT_KEY)
    assert(DEFAULT_KEY in values or icnt == count)


def test_autocheck_yaml():
    logging.debug('analyze autocheck.yaml')
    config_path = os.path.join(yatest.common.source_path('autocheck'), 'autocheck.yaml')
    with open(config_path) as fp:
        autocheck_conf = yaml.load(fp)

    for _, config in autocheck_conf['configurations'].items():
        check_config(yatest.common.source_path(config['config']))
        partitions = config['partitions']
        part_count = partitions['count']
        assert(part_count > 0)
        for field in PARTITITION_LIST_FIELDS:
            if field in partitions:
                _check_partition_prop(partitions[field], part_count)
