#pragma once

#include <balancer/kernel/memory/chunks.h>

#include <library/cpp/http/io/headers.h>

#include <util/generic/vector.h>

#include <variant>
#include <any>

namespace NHttp {
/// Класс THeadFrame содержит данные стартовой строки ответа и заголовки
class TResponseHeadFrame {
  public:
    /// Значение кода ответа. Например 200
    int StatusCode = 0;

    /// Пояснение к коду ответа. Например "OK"
    /// В HTTP/2 ушли от понятия "reason phrase", поэтому для HTTP/2 поле может быть пустым.
    TString ReasonPhrase;

    /// Заголовки
    THttpHeaders Headers;
};

using THeadersFrame = THttpHeaders;
using TDataFrame = NSrvKernel::TChunkList;
using TResponseFrame = std::variant<TResponseHeadFrame, TDataFrame, THeadersFrame>;
using TRequestFrame = std::variant<TDataFrame, THeadersFrame>;
}
