#pragma once

#include "request.h"
#include "request_context.h"

#include <memory>

namespace NHttp {
/// IRequester реализует механику отправки запроса
class IRequester {
  public:
    virtual ~IRequester() = default;

    /// В методе Send реализуется механика отправки запроса.
    /// Переданный запрос и все его копии уничтожаются,
    /// если сработает деструктор IRequestContext
    /// или будет вызван метод IRequestContext::Cancel
    /// \param request запрос, который нужно послать
    /// \return указатель на контекст, через который можно отменить запрос, прочитать ответ, записать данные в стрим
    virtual std::unique_ptr<IRequestContext> Send(TRequest request) noexcept = 0;
};
}
