#pragma once

#include <util/generic/string.h>
#include <util/generic/hash.h>
#include <util/generic/yexception.h>
#include <util/network/address.h>

namespace NHttp {
/// TResolvedEndpoint содержит информацию о хосте
class TResolvedEndpoint {
  public:
    using TMetaInfo = THashMap<TString, TString>;

    // IPv4 или IPv6
    TString Ip;

    // Порт
    ui16 Port;

    /// Мета данные, которые могут пригодиться в целях оптимизации.
    /// Например, резолвер может указать тут датацентр, в котором находится
    /// данный инстанс. На основе этой информации мы в дальнейшем можем
    /// выбрать оптимальный таймаут установки соединения.
    TMetaInfo MetaInfo;
};
}
