#pragma once

#include "frames.h"

#include <balancer/client/experimental/error/error.h>

#include <infra/libs/outcome/result.h>

#include <util/generic/maybe.h>
#include <util/datetime/base.h>

#include <functional>

namespace NHttp {
/// IResponseStream предоставляет асинхронный интерфейс для чтения данных
class IResponseStream {
  public:
    using TReadResult = TExpected<TMaybe<TResponseFrame>, TError>;
    using TReadHandler = std::function<void (TReadResult)>;

    virtual ~IResponseStream() = default;

    /// Метод Read возвращает данные через переданный callback.
    /// Данные могут быть трёх типов, а их порядок строго определён: THead -> TBodyChunk -> TTrailerHeaders.
    /// Если данных больше не будет, то Read вернёт пустой TMaybe.
    /// \param sizeLimit максимальный размер блока данных TBodyChunk. 0 = unlimited.
    /// \param peek позволяет при следующем вызове Read прочитать те же данные повторно
    /// \param deadline максимальное время ожидания ответа
    /// \param callback должен быть вызван, когда станут доступны новые данные
    virtual void Read(size_t sizeLimit, bool peek, TInstant deadline, TReadHandler callback) noexcept = 0;
};
}

