#pragma once

#include <balancer/client/experimental/requesters/balancer_client/balancer_client.h>

#include <balancer/client/experimental/base/full_response.h>
#include <balancer/client/experimental/util/requester_utils.h>
#include <balancer/client/experimental/util/request_utils.h>


namespace NHttp {
using TClient = NRequesters::TBalancerClient;

/// Возвращает глобальный клиент, который можно использовать без инициализации
/// Безопасно использовать из любого потока
TClient& Client();

/// Синхронно делает GET запрос и полностью считывает ответ
/// Использует глобальный клиент
TExpected<TFullResponse, TError> Get(TStringBuf url, TInstant deadline);

/// Синхронно делает GET запрос и возвращает десериализованный типизированный ответ
/// Использует глобальный клиент
template<CResponseParser TParser>
TExpected<typename TParser::TParsedType, TError> GetTyped(TStringBuf url, TParser& parser, TInstant deadline) {
    auto request = NUtils::BuildRequest(url);
    if (request.IsError()) {
        return std::move(request.Error());
    }
    return NUtils::SendTyped(Client(), std::move(request.Success()), parser, deadline);
}
}
