#include "error.h"

#include <util/system/type_name.h>

#include <any>

namespace NHttp {
TError::TError(TString message): Message_{std::move(message)} {}

void TError::Print(IOutputStream& out) const {
    if (Message_) {
        out << "(" << TypeName(*this) << ") " << Message_;
        if (Info_.has_value()) {
            out << Endl << "  with info: ";
        }
    }
    if (Info_.has_value()) {
        auto info = InfoViewer_(const_cast<std::any&>(Info_));
        out << *info;
    }
}
}

template <>
void Out<NHttp::TError>(IOutputStream& out, const NHttp::TError& errorInfo) {
    errorInfo.Print(out);
}

TString NPrivate::SuccessCastErrorMessageGetter<NHttp::TError>::GetMessage(const NHttp::TError* const error) {
    TStringStream ss;
    ss << *error;
    return ss.Str();
}
