#include <balancer/client/experimental/client.h>
#include <balancer/client/experimental/util/request_context_utils.h>

int main(int /*argc*/, char** /*argv*/) {
    auto request = NHttp::NUtils::BuildRequest("https://yandex.ru").Success();
    auto context = NHttp::Client().Send(request);
    while(auto chunk = NHttp::NUtils::ReadRaw(*context, TDuration::Seconds(5).ToDeadLine()).GetValueSync().Success()) {
        if (auto head = std::get_if<NHttp::TResponseHeadFrame>(chunk.Get())) {
            Cout << "head received, status code: " << head->StatusCode << Endl;
        } else if(auto data = std::get_if<NHttp::TDataFrame>(chunk.Get())) {
            Cout << "chunk received, size: " << data->size() << " bytes" << Endl;
        }
    }
    return 0;
}
