#include <balancer/client/experimental/parsers/json/json_parser.h>
#include <balancer/client/experimental/requesters/static/buffer_response_stream.h>
#include <balancer/client/experimental/util/response_parser_utils.h>

#include <library/cpp/testing/gtest/gtest.h>

using NHttp::NParsers::TJsonParser;
using NHttp::NRequesters::TBufferResponseStream;
using NHttp::NUtils::ParseTyped;

TEST(JsonParser, Test) {
    TJsonParser jsonParser;
    TBufferResponseStream bufferStream{NSrvKernel::TChunkList{TString{R"({"value":"hello world"})"}}};
    auto json =  ParseTyped(jsonParser, bufferStream, TInstant::Max()).Success();
    ASSERT_EQ(json["value"], "hello world");
}
