#include "transparent_parser.h"

#include <balancer/client/experimental/base/response_stream.h>

namespace NHttp::NParsers {
void TTransparentChunkParser::Parse(IResponseStream& stream, TInstant deadline, THandler callback) noexcept {
    stream.Read(0, false, deadline, [callback = std::move(callback)](IResponseStream::TReadResult result) {
        if (result.IsError()) {
            return callback(std::move(result.Error()));
        }

        if (result.Success().Defined()) {
            return callback(std::make_any<TResponseFrame>(std::move(result.Success().GetRef())));
        }

        return callback(std::any{});
    });
}
}
