#pragma once

#include "balancer_client_options.h"
#include "internal/tls.h"
#include "internal/connection_manager.h"

#include <balancer/client/experimental/base/requester.h>
#include <balancer/client/experimental/base/request.h>

#include <balancer/modules/proxy/proxy.h>

namespace NHttp::NRequesters {
// Реализация IRequester на основе балансерного кода.
// Умеет отправлять запросы в конкретный endpoint.
// Поддерживает: HTTP/1/2, HTTPS, Streaming
class TBalancerClient final: public IRequester {
    class TRequestContext;
    class TResponseStream;

  public:
    using TOptions = TBalancerClientOptions;

    TBalancerClient(TOptions options = TOptions{});

    std::unique_ptr<IRequestContext> Send(TRequest request) noexcept override;

  private:
    TOptions Options_;
    NModProxy::TProxyConfig ProxyConfig_;
    TConnectionManager ConnectionManager_;
    NModProxy::TModuleProxy Proxy_;
    NSrvKernel::TSharedAllocator Allocator_;
    NSrvKernel::TSharedStatsManager StatsManager_;
    TVector<std::unique_ptr<TTls>> Tls_;
};
}
