#pragma once

#include <util/generic/string.h>
#include <util/datetime/base.h>
#include <util/system/info.h>

namespace NHttp::NRequesters {
struct TBalancerClientOptions {
    // Кол-во потоков, которые будут обрабатывать запросы
    size_t WorkersCount = NSystemInfo::NumberOfCpus() * 2;

    // Путь к TLS сертификату
    // Если строка пустая, то устанавливается по-умолчанию:
    // mac os: "/etc/ssl/cert.pem"
    // linux: "/etc/ssl/certs/ca-certificates.crt"
    TString CertPath;

    // Максимальное кол-во закешированных HTTP/1 соединений
    size_t KeepAliveCount = 10000;
};
} // namespace NHttp
