#pragma once

#include "worker.h"

#include <balancer/client/experimental/base/resolved_endpoint.h>

#include <balancer/kernel/connection_manager/connection_manager.h>

namespace NHttp::NRequesters {
class TConnectionManager {
  public:
    TConnectionManager(size_t keepAliveCount, TDuration keepAliveTimeout, TDuration connectTimeout);

    ~TConnectionManager();

    THolder<NModProxy::TKeepAliveData> TryPullConnection(const NSrvKernel::TConnDescr& descr, const NSrvKernel::THostInfo& hostInfo);
    void StoreConnection(THolder<NModProxy::TKeepAliveData> connection);

  private:
    NConnectionManager::TConnectionPool* GetPool(const TString& ip, ui16 port, const TString& sniHost);

    TWorker Worker_;
    TIntrusivePtr<NConnectionManager::TConnectionManager> ConnectionManager_;
    THolder<NConnectionManager::TConnectionManager::TRuntime> ConnectionManagerRuntime_;
    size_t Counter_ = 0;
    size_t KeepAliveCount_ = 0;
    TDuration KeepAliveTimeout_;
    TDuration ConnectTimeout_;
    THashMap<std::tuple<TString, ui16, TString>, NConnectionManager::TConnectionPool*> PoolMap_;
    TMutex Mutex_;
};
}
