#pragma once

#include "../balancer_client.h"
#include "response_stream.h"

#include <balancer/client/experimental/base/request_context.h>

#include <balancer/kernel/coro/waked.h>

namespace NHttp::NRequesters {
class TBalancerClient::TRequestContext final: public IRequestContext {
  public:
    TRequestContext(TBalancerClient& client, TTls& tls,  TRequest request);

    void Cancel() noexcept override;

    void Write(TMaybe<TRequestFrame> frame) noexcept override;

    void Read(IResponseParser& parser, TInstant deadline, TReadHandler callback) noexcept override;

    void Run() noexcept;

  private:
    TBalancerClient& Client_;
    TTls& Tls_;
    NSrvKernel::TU2WChannel<NSrvKernel::TChunkList> InputChannel_;
    TRequest Request_;
    TResponseStream ResponseStream_;
    std::unique_ptr<TWorker::TCoroutine> Coro_;
};
}
