#include "tls.h"

namespace NHttp::NRequesters {
TTls::TTls(NSrvKernel::TSharedStatsManager& statsManager, TConnectionManager& connectionManager)
    : NModProxy::TTls{statsManager}
    , ConnectionManager_{connectionManager}
{}

THolder<NModProxy::TKeepAliveData> TTls::GetKeepAliveConnection(const NSrvKernel::TConnDescr& descr, const NSrvKernel::THostInfo& hostInfo) noexcept {
    return ConnectionManager_.TryPullConnection(descr, hostInfo);
}

bool TTls::CanStoreKeepaliveConnection(const NSrvKernel::TConnDescr& /*descr*/, const NSrvKernel::THostInfo& /*hostInfo*/) const noexcept {
    return true;
}

void TTls::StoreKeepaliveConnection(THolder<NModProxy::TKeepAliveData> keepAlive) noexcept {
    ConnectionManager_.StoreConnection(std::move(keepAlive));
}
}
