#pragma once

#include "worker.h"
#include "connection_manager.h"

#include <balancer/modules/proxy/tls.h>

namespace NHttp::NRequesters {
  class TTls: public NModProxy::TTls, public TWorker {
    public:
      TTls(NSrvKernel::TSharedStatsManager& statsManager, TConnectionManager& connectionManager);

      THolder<NModProxy::TKeepAliveData> GetKeepAliveConnection(const NSrvKernel::TConnDescr& descr, const NSrvKernel::THostInfo& hostInfo) noexcept override;
      bool CanStoreKeepaliveConnection(const NSrvKernel::TConnDescr& descr, const NSrvKernel::THostInfo& hostInfo) const noexcept override;
      void StoreKeepaliveConnection(THolder<NModProxy::TKeepAliveData> keepAlive) noexcept override;

    private:
      TConnectionManager& ConnectionManager_;
  };
}
