#include "buffer_response_stream.h"

namespace NHttp::NRequesters {
TBufferResponseStream::TBufferResponseStream(NSrvKernel::TChunkList buffer) : Buffer_(std::move(buffer)) {}

void TBufferResponseStream::Read(size_t sizeLimit, bool peek, TInstant /*deadline*/, TReadHandler callback) noexcept {
    if (Buffer_.Empty()) {
        return callback(TMaybe<NHttp::TResponseFrame>{});
    }

    NSrvKernel::TChunkList part;
    if (peek) {
        part = sizeLimit ? Buffer_.SubList(sizeLimit) : Buffer_;
    } else {
        part = sizeLimit ? Buffer_.Cut(sizeLimit) : std::move(Buffer_);
    }

    return callback(TMaybe<NHttp::TResponseFrame>{std::move(part)});
}
}
