#include "static_requester.h"
#include "buffer_response_stream.h"

#include <balancer/client/experimental/base/response_parser.h>

namespace {
class TChunkContext: public NHttp::IRequestContext {
  public:
    TChunkContext(NSrvKernel::TChunkList buffer) : Stream_{std::move(buffer)} {}

    void Cancel() noexcept override {}

    void Write(TMaybe<NHttp::TRequestFrame> data) noexcept override {
        Y_UNUSED(data);
        Y_FAIL("not implemented");
    }

    void Read(NHttp::IResponseParser& parser, TInstant deadline, TReadHandler callback) noexcept override {
        return parser.Parse(Stream_, deadline, std::move(callback));
    }

  private:
    NHttp::NRequesters::TBufferResponseStream Stream_;
};
}

namespace NHttp::NRequesters {
TStaticRequester::TStaticRequester(NSrvKernel::TChunkList buffer) : Buffer_(std::move(buffer)) {}

std::unique_ptr<IRequestContext> TStaticRequester::Send(NHttp::TRequest request) noexcept {
    Y_UNUSED(request);
    return std::make_unique<TChunkContext>(Buffer_);
}
}
