#pragma once

#include <balancer/client/experimental/base/full_response.h>
#include <balancer/client/experimental/base/requester.h>
#include <balancer/client/experimental/base/response_parser.h>
#include <balancer/client/experimental/error/error.h>

#include <infra/libs/outcome/result.h>

namespace NHttp::NUtils {
/// Синхронно делает запрос и считывает полностью ответ
TExpected<TFullResponse, TError> Send(IRequester& requester, TRequest request, TInstant deadline);

/// Синхронно делает GET запрос и возвращает десериализованный ответ
IResponseParser::TResult SendParsed(IRequester& requester, TRequest request, IResponseParser& parser, TInstant deadline);

/// Синхронно делает GET запрос и возвращает десериализованный типизированный ответ
template<CResponseParser TParser>
TExpected<typename TParser::TParsedType, TError> SendTyped(IRequester& requester, TRequest request, TParser& parser, TInstant deadline) {
    auto result = SendParsed(requester, std::move(request), parser, deadline);
    if (result.IsError()) {
        return std::move(result.Error());
    }

    return std::any_cast<typename TParser::TParsedType>(std::move(result.Success()));
}
}
