#include "response_parser_utils.h"

#include <semaphore>

namespace NHttp::NUtils {
IResponseParser::TResult Parse(IResponseParser& parser, IResponseStream& stream, TInstant deadline) {
    TMaybe <IResponseParser::TResult> out;
    std::binary_semaphore semaphore{0};
    parser.Parse(stream, deadline, [&](IResponseParser::TResult result) {
        out = std::move(result);
        semaphore.release();

    });

    semaphore.acquire();
    return std::move(out.GetRef());
}
}
