#pragma once

#include <balancer/client/experimental/base/response_parser.h>

namespace NHttp::NUtils {
IResponseParser::TResult Parse(IResponseParser& parser, IResponseStream& stream, TInstant deadline);

template<CResponseParser TParser>
TExpected<typename TParser::TParsedType, TError> ParseTyped(TParser& parser, IResponseStream& stream, TInstant deadline) {
    IResponseParser::TResult result = Parse(parser, stream, deadline);
    if (result.IsError()) {
        return result.Error();
    }

    return std::any_cast<typename TParser::TParsedType>(std::move(result.Success()));
}
}
