#pragma once

#include <balancer/client/experimental/base/full_response.h>
#include <balancer/client/experimental/base/response_stream.h>

namespace NHttp::NUtils {
using TReadAllResult = TExpected<TMaybe<TFullResponse>, TError>;
using TReadAllHandler = std::function<void (TReadAllResult)>;

/// Метод ReadAll ожидает получения всех данных и возвращает их всех разом.
/// \param callback будет вызван, когда придут все данные
void ReadAll(IResponseStream& responseStream, TInstant deadline, TReadAllHandler callback) noexcept;
}
