#include "service.h"

#include <library/cpp/coroutine/engine/helper.h>
#include <library/cpp/testing/unittest/registar.h>

namespace NBalancerClient::NTesting {
namespace {
    NBalancerServer::TOptions OptionsWithPort(NBalancerServer::TOptions options, ui64 port) {
        if (options.SslConfigPath) {
            options.SslPort = port;
        } else {
            options.SetPort(port);
        }
        return options;
    }
}

    TService::TService(const NBalancerServer::TServerCallback& callback, NBalancerServer::TOptions options, ui16 port)
        : Port(port ? port : PM.GetPort())
        , Server(callback, OptionsWithPort(std::move(options), Port))
        , ServerThread([this]() {
            Server.Run();
        })
    {
        ServerThread.Start();
        UNIT_ASSERT(NCoro::WaitUntilConnectable("localhost", Port, TDuration::Seconds(5)));
    }

    TService::~TService() {
        Server.Shutdown();
        ServerThread.Join();
    }
}
