from argparse import ArgumentParser
import tarfile
import StringIO

from library.python import resource


def main():
    parser = ArgumentParser(description='Fetch GencCFG cache')
    parser.add_argument(
        '-o',
        '--output',
        type=str,
        help='Pickle outdir path',
        required=True,
    )
    parser.add_argument(
        '-n',
        '--name',
        type=str,
        help='Name of project',
        required=True,
    )
    options = parser.parse_args()

    name = options.name + '_gencfg_cache.pickle'

    with tarfile.open(fileobj=StringIO.StringIO(resource.find('pickles.tgz')), mode='r:gz') as tar:
        tar.extract(name, options.output)


if __name__ == "__main__":
    main()
