#include <balancer/modules/factory/common.h>

#include <balancer/modules/aab_cookie_verify/module.h>
#include <balancer/modules/antiddos/module.h>
#include <balancer/modules/antirobot/module.h>
#include <balancer/modules/antirobot_wrapper/module.h>
#include <balancer/modules/cachalot/module.h>
#include <balancer/modules/cache/client.h>
#include <balancer/modules/cache/server.h>
#include <balancer/modules/cache2/module.h>
#include <balancer/modules/cgi_hasher/module.h>
#include <balancer/modules/click/module.h>
#include <balancer/modules/compressor/module.h>
#include <balancer/modules/cookie_policy/module.h>
#include <balancer/modules/cryprox/module.h>
#include <balancer/modules/exp_getter/module.h>
#include <balancer/modules/exp_static/module.h>
#include <balancer/modules/flags_getter/module.h>
#include <balancer/modules/geobase/module.h>
#include <balancer/modules/hasher/module.h>
#include <balancer/modules/headers_hasher/module.h>
#include <balancer/modules/icookie/module.h>
#include <balancer/modules/quota/module.h>
#include <balancer/modules/quota_sync/module.h>
#include <balancer/modules/rate_limiter/module.h>
#include <balancer/modules/redirects/module.h>
#include <balancer/modules/remote_log/module.h>
#include <balancer/modules/request_replier/module.h>
#include <balancer/modules/response_matcher/module.h>
#include <balancer/modules/rpcrewrite/module.h>
#include <balancer/modules/rps_limiter/module.h>
#include <balancer/modules/rpslimiter_instance/module.h>
#include <balancer/modules/thdbversion/module.h>
#include <balancer/modules/thumb_consistent_hash/module.h>
#include <balancer/modules/thumbs_exist_spreader/module.h>
#include <balancer/modules/thumbsban/module.h>
#include <balancer/modules/tvm_service_router/module.h>
#include <balancer/modules/unpack/module.h>
#include <balancer/modules/webauth/module.h>

#include <balancer/kernel/client_hints/impl/client_hints.h>

#include <balancer/kernel/module/iface.h>
#include <balancer/kernel/module/node.h>
#include <balancer/kernel/process/main.h>

#include <util/generic/yexception.h>

using namespace NSrvKernel;
using namespace NModulesFactory;

int main(int argc, char** argv) noexcept try {
    struct TFactory : public TNodeFactory<IModule> {
        inline TFactory()
            : TNodeFactory(CommonModules())
        {
            AddHandle(NModAabCookieVerify::Handle());
            AddHandle(NModAntiDDOS::Handle());
            AddHandle(NModAntiRobot::Handle());
            AddHandle(NModAntiRobotWrapper::Handle());
            AddHandle(NModCachalot::Handle());
            AddHandle(NModCache2::Handle());
            AddHandle(NModCacheClient::Handle());
            AddHandle(NModCacheServer::Handle());
            AddHandle(NModCgiHasher::Handle());
            AddHandle(NModClick::Handle());
            AddHandle(NModCompressor::Handle());
            AddHandle(NModCookiePolicy::Handle());
            AddHandle(NModCryprox::Handle());
            AddHandle(NModExpGetter::Handle());
            AddHandle(NModExpStatic::Handle());
            AddHandle(NModFlagsGetter::Handle());
            AddHandle(NModGeobaseStandalone::Handle());
            AddHandle(NModHasher::Handle());
            AddHandle(NModHeadersHasher::Handle());
            AddHandle(NModIcookie::Handle());
            AddHandle(NModQuota::Handle());
            AddHandle(NModQuotaSync::Handle());
            AddHandle(NModRateLimiter::Handle());
            AddHandle(NModRedirects::Handle());
            AddHandle(NModRemoteLog::Handle());
            AddHandle(NModRequestReplier::Handle());
            AddHandle(NModResponseMatcher::Handle());
            AddHandle(NModRpcRewrite::Handle());
            AddHandle(NModRpsLimiter::Handle());
            AddHandle(NModRpsLimiterInstance::Handle());
            AddHandle(NModThDbVersion::Handle());
            AddHandle(NModThumbConsistentHash::Handle());
            AddHandle(NModThumbsBan::Handle());
            AddHandle(NModThumbsExist::Handle());
            AddHandle(NModTvmServiceRouter::Handle());
            AddHandle(NModUnpack::Handle());
            AddHandle(NModWebAuth::Handle());
        }
    } factory;

    SetUARestore(MakeHolder<TUARestorerImpl>());

    return RunMain(argc, argv, &factory);
} catch (...) {
    Cerr << CurrentExceptionMessage() << Endl;

    return 1;
}
