#pragma once

#include "stats_collector.h"

#include <library/cpp/http/server/http.h>

class TCollectorRequestReplier;

class TAdminServer: public THttpServer, public THttpServer::ICallBack {
public:
    typedef std::function<void()> TCallback;

    TAdminServer(TCallback onShutdown, TCallback onReopenlog, const THttpServer::TOptions& opts)
        : THttpServer(this, opts)
        , OnShutdown(onShutdown)
        , OnReopenlog(onReopenlog)
    { }

private:
    TClientRequest* CreateClient() override;

    void OnException() override;

public:
    const TCallback OnShutdown;
    const TCallback OnReopenlog;
};

class TAdminRequestReplier: public TRequestReplier {
public:
    TAdminRequestReplier(TAdminServer* srv)
        : Server_(srv)
    { }

private:
    bool DoReply(const TReplyParams& params) override;

private:
    TAdminServer* const Server_;
};
